/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import org.jhotdraw.gui.DisclosureIcon;
import org.jhotdraw.gui.EmptyIcon;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.gui.plaf.palette.PaletteToolBarUI;

public class JDisclosureToolBar
extends JToolBar {
    private JButton disclosureButton;
    public static final String DISCLOSURE_STATE_PROPERTY = "disclosureState";
    public static final String DISCLOSURE_STATE_COUNT_PROPERTY = "disclosureStateCount";

    public JDisclosureToolBar() {
        this.setUI(PaletteToolBarUI.createUI(this));
        this.initComponents();
    }

    private void initComponents() {
        JButton jButton;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.disclosureButton == null) {
            jButton = new JButton();
            jButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(jButton));
            jButton.setBorderPainted(false);
            jButton.setIcon(new DisclosureIcon());
            jButton.setOpaque(false);
            this.disclosureButton = jButton;
            this.disclosureButton.putClientProperty("DisclosureIcon.currentState", 1);
            this.disclosureButton.putClientProperty("DisclosureIcon.numberOfStates", 2);
            this.disclosureButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ((Integer)JDisclosureToolBar.this.disclosureButton.getClientProperty("DisclosureIcon.currentState") + 1) % (Integer)JDisclosureToolBar.this.disclosureButton.getClientProperty("DisclosureIcon.numberOfStates");
                    JDisclosureToolBar.this.setDisclosureState(n);
                }
            });
        } else {
            jButton = this.disclosureButton;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jButton, gridBagConstraints);
        this.putClientProperty("Palette.ToolBar.insetsOverride", new Insets(0, 0, 0, 0));
        this.putClientProperty("Palette.ToolBar.icon", new EmptyIcon(10, 8));
    }

    public void setDisclosureStateCount(int n) {
        int n2 = this.getDisclosureStateCount();
        this.disclosureButton.putClientProperty("DisclosureIcon.numberOfStates", n);
        this.firePropertyChange(DISCLOSURE_STATE_COUNT_PROPERTY, n2, n);
    }

    public void setDisclosureState(int n) {
        int n2 = this.getDisclosureState();
        this.disclosureButton.putClientProperty("DisclosureIcon.currentState", n);
        this.removeAll();
        JComponent jComponent = this.getDisclosedComponent(n);
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (jComponent != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            this.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 1, 0, 1);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 16;
            this.add((Component)this.disclosureButton, gridBagConstraints);
        } else {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.insets = new Insets(0, 1, 0, 1);
            this.add((Component)this.disclosureButton, gridBagConstraints);
        }
        this.invalidate();
        Container container = this.getParent();
        while (container.getParent() != null && !container.getParent().isValid()) {
            container = container.getParent();
        }
        container.validate();
        this.repaint();
        this.firePropertyChange(DISCLOSURE_STATE_PROPERTY, n2, n);
    }

    public int getDisclosureStateCount() {
        Integer n = (Integer)this.disclosureButton.getClientProperty("DisclosureIcon.numberOfStates");
        return n == null ? 2 : n;
    }

    public int getDisclosureState() {
        Integer n = (Integer)this.disclosureButton.getClientProperty("DisclosureIcon.currentState");
        return n == null ? 1 : n;
    }

    protected JComponent getDisclosedComponent(int n) {
        return new JLabel(Integer.toString(n));
    }
}

