# about.py
# 
# Copyright (C) 2006-2008 Betz Stefan <stefan_betz@gmx.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pygtk
pygtk.require('2.0')
import gtk
import gettext
import webbrowser
from subprocess import Popen
from pyneighborhood.misc import sharepath, version

_ = gettext.gettext

class AboutDialog(object):
    """
    The About Dialog for pyNeighborhood
    """

    def __init__(self):
        """
        The Constructor of the About Dialog
        """
        gtk.about_dialog_set_url_hook(self.handle_url)
        gtk.about_dialog_set_email_hook(self.handle_email)
        self.xml = gtk.Builder()
        self.xml.set_translation_domain('pyNeighborhood')
        self.xml.add_from_file(sharepath('ui/about.glade'))
        self.xml.connect_signals(self)
        
        self.window = self.xml.get_object("about_dialog")
        self.window.set_version(version)

    def handle_url(self, dialog, url):
        webbrowser.open(url, 2, True)

    def handle_email(self, dialog, email):
        Popen(["xdg-open", "mailto:%s" % email]).wait()

    def close_handler(self, widget = None, response_id = None):
        """
        Window Close Handler
        """
        self.window.destroy()
