/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptEngineWrapper;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class DefaultEngineWrapper
extends ScriptEngineWrapper {
    private Map<String, String> templateMap = new HashMap<String, String>();
    private static Logger logger = Logger.getLogger(DefaultEngineWrapper.class);

    public DefaultEngineWrapper(ScriptEngine scriptEngine) {
        super(scriptEngine);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getSyntaxStyle() {
        return null;
    }

    @Override
    public String getTemplate(String string) {
        if (!this.templateMap.containsKey(string)) {
            this.templateMap.put(string, this.getStringReource(this.getLanguageName().toLowerCase() + File.separator + string.toLowerCase() + "-template." + this.getExtensions().get(0)));
        }
        return this.templateMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringReource(String string) {
        File file = new File(ExtensionScript.TEMPLATES_DIR, string);
        if (!file.exists()) {
            logger.debug((Object)("No template at: " + file.getAbsolutePath()));
            file = new File(Constant.getZapHome() + File.separator + ExtensionScript.TEMPLATES_DIR, string);
            if (!file.exists()) {
                logger.debug((Object)("No template at: " + file.getAbsolutePath()));
                return "";
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append("\n");
                }
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            return "";
        }
    }

    @Override
    public List<String> getExtensions() {
        return this.getEngine().getFactory().getExtensions();
    }

    @Override
    public boolean isTextBased() {
        return true;
    }

    @Override
    public boolean isRawEngine() {
        return true;
    }

    @Override
    public boolean isSupportsMissingTemplates() {
        return true;
    }

    @Override
    public boolean isDefaultTemplate(ScriptWrapper scriptWrapper) {
        return false;
    }
}

