/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.allocation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.allocation.NodeExplanation;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;

public final class ClusterAllocationExplanation
implements ToXContent,
Writeable {
    private final ShardId shard;
    private final boolean primary;
    private final boolean hasPendingAsyncFetch;
    private final String assignedNodeId;
    private final UnassignedInfo unassignedInfo;
    private final long allocationDelayMillis;
    private final long remainingDelayMillis;
    private final Map<DiscoveryNode, NodeExplanation> nodeExplanations;
    private final ClusterInfo clusterInfo;

    public ClusterAllocationExplanation(ShardId shard, boolean primary, @Nullable String assignedNodeId, long allocationDelayMillis, long remainingDelayMillis, @Nullable UnassignedInfo unassignedInfo, boolean hasPendingAsyncFetch, Map<DiscoveryNode, NodeExplanation> nodeExplanations, @Nullable ClusterInfo clusterInfo) {
        this.shard = shard;
        this.primary = primary;
        this.hasPendingAsyncFetch = hasPendingAsyncFetch;
        this.assignedNodeId = assignedNodeId;
        this.unassignedInfo = unassignedInfo;
        this.allocationDelayMillis = allocationDelayMillis;
        this.remainingDelayMillis = remainingDelayMillis;
        this.nodeExplanations = nodeExplanations;
        this.clusterInfo = clusterInfo;
    }

    public ClusterAllocationExplanation(StreamInput in) throws IOException {
        this.shard = ShardId.readShardId(in);
        this.primary = in.readBoolean();
        this.hasPendingAsyncFetch = in.readBoolean();
        this.assignedNodeId = in.readOptionalString();
        this.unassignedInfo = in.readOptionalWriteable(UnassignedInfo::new);
        this.allocationDelayMillis = in.readVLong();
        this.remainingDelayMillis = in.readVLong();
        int mapSize = in.readVInt();
        HashMap<DiscoveryNode, NodeExplanation> nodeToExplanation = new HashMap<DiscoveryNode, NodeExplanation>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            NodeExplanation nodeExplanation = new NodeExplanation(in);
            nodeToExplanation.put(nodeExplanation.getNode(), nodeExplanation);
        }
        this.nodeExplanations = nodeToExplanation;
        this.clusterInfo = in.readBoolean() ? new ClusterInfo(in) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.getShard().writeTo(out);
        out.writeBoolean(this.isPrimary());
        out.writeBoolean(this.isStillFetchingShardData());
        out.writeOptionalString(this.getAssignedNodeId());
        out.writeOptionalWriteable(this.getUnassignedInfo());
        out.writeVLong(this.allocationDelayMillis);
        out.writeVLong(this.remainingDelayMillis);
        out.writeVInt(this.nodeExplanations.size());
        for (NodeExplanation explanation : this.nodeExplanations.values()) {
            explanation.writeTo(out);
        }
        if (this.clusterInfo != null) {
            out.writeBoolean(true);
            this.clusterInfo.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public ShardId getShard() {
        return this.shard;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isStillFetchingShardData() {
        return this.hasPendingAsyncFetch;
    }

    public boolean isAssigned() {
        return this.assignedNodeId != null;
    }

    @Nullable
    public String getAssignedNodeId() {
        return this.assignedNodeId;
    }

    @Nullable
    public UnassignedInfo getUnassignedInfo() {
        return this.unassignedInfo;
    }

    public long getAllocationDelayMillis() {
        return this.allocationDelayMillis;
    }

    public long getRemainingDelayMillis() {
        return this.remainingDelayMillis;
    }

    public Map<DiscoveryNode, NodeExplanation> getNodeExplanations() {
        return this.nodeExplanations;
    }

    @Nullable
    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("shard");
        builder.field("index", this.shard.getIndexName());
        builder.field("index_uuid", this.shard.getIndex().getUUID());
        builder.field("id", this.shard.getId());
        builder.field("primary", this.primary);
        builder.endObject();
        builder.field("assigned", this.assignedNodeId != null);
        if (this.assignedNodeId != null) {
            builder.field("assigned_node_id", this.assignedNodeId);
        }
        builder.field("shard_state_fetch_pending", this.hasPendingAsyncFetch);
        if (this.unassignedInfo != null) {
            this.unassignedInfo.toXContent(builder, params);
            builder.timeValueField("allocation_delay_in_millis", "allocation_delay", TimeValue.timeValueMillis(this.allocationDelayMillis));
            builder.timeValueField("remaining_delay_in_millis", "remaining_delay", TimeValue.timeValueMillis(this.remainingDelayMillis));
        }
        builder.startObject("nodes");
        for (NodeExplanation explanation : this.nodeExplanations.values()) {
            explanation.toXContent(builder, params);
        }
        builder.endObject();
        if (this.clusterInfo != null) {
            builder.startObject("cluster_info");
            this.clusterInfo.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static enum StoreCopy {
        NONE(0),
        AVAILABLE(1),
        CORRUPT(2),
        IO_ERROR(3),
        STALE(4),
        UNKNOWN(5);

        private final byte id;

        private StoreCopy(byte id) {
            this.id = id;
        }

        private static StoreCopy fromId(byte id) {
            switch (id) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return AVAILABLE;
                }
                case 2: {
                    return CORRUPT;
                }
                case 3: {
                    return IO_ERROR;
                }
                case 4: {
                    return STALE;
                }
                case 5: {
                    return UNKNOWN;
                }
            }
            throw new IllegalArgumentException("unknown id for store copy: [" + id + "]");
        }

        public String toString() {
            switch (this.id) {
                case 0: {
                    return "NONE";
                }
                case 1: {
                    return "AVAILABLE";
                }
                case 2: {
                    return "CORRUPT";
                }
                case 3: {
                    return "IO_ERROR";
                }
                case 4: {
                    return "STALE";
                }
                case 5: {
                    return "UNKNOWN";
                }
            }
            throw new IllegalArgumentException("unknown id for store copy: [" + this.id + "]");
        }

        static StoreCopy readFrom(StreamInput in) throws IOException {
            return StoreCopy.fromId(in.readByte());
        }

        void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.id);
        }
    }

    public static enum FinalDecision {
        YES(0),
        NO(1),
        ALREADY_ASSIGNED(2);

        private final byte id;

        private FinalDecision(byte id) {
            this.id = id;
        }

        private static FinalDecision fromId(byte id) {
            switch (id) {
                case 0: {
                    return YES;
                }
                case 1: {
                    return NO;
                }
                case 2: {
                    return ALREADY_ASSIGNED;
                }
            }
            throw new IllegalArgumentException("unknown id for final decision: [" + id + "]");
        }

        public String toString() {
            switch (this.id) {
                case 0: {
                    return "YES";
                }
                case 1: {
                    return "NO";
                }
                case 2: {
                    return "ALREADY_ASSIGNED";
                }
            }
            throw new IllegalArgumentException("unknown id for final decision: [" + this.id + "]");
        }

        static FinalDecision readFrom(StreamInput in) throws IOException {
            return FinalDecision.fromId(in.readByte());
        }

        void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.id);
        }
    }
}

