/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaEventProducer;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.PageViewport;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererEventProducer;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderPagesModel
extends AreaTreeModel {
    protected Renderer renderer;
    protected List<PageViewport> prepared = new ArrayList<PageViewport>();
    private List<OffDocumentItem> pendingODI = new ArrayList<OffDocumentItem>();
    private List<OffDocumentItem> endDocODI = new ArrayList<OffDocumentItem>();

    public RenderPagesModel(FOUserAgent userAgent, String outputFormat, FontInfo fontInfo, OutputStream stream) throws FOPException {
        this.renderer = userAgent.getRendererFactory().createRenderer(userAgent, outputFormat);
        try {
            this.renderer.setupFontInfo(fontInfo);
            if (!fontInfo.isSetupValid()) {
                throw new FOPException("No default font defined by OutputConverter");
            }
            this.renderer.startRenderer(stream);
        }
        catch (IOException e) {
            throw new FOPException(e);
        }
    }

    @Override
    public void setDocumentLocale(Locale locale) {
        this.renderer.setDocumentLocale(locale);
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) {
        super.startPageSequence(pageSequence);
        if (this.renderer.supportsOutOfOrder()) {
            this.renderer.startPageSequence(this.getCurrentPageSequence());
        }
    }

    @Override
    public void addPage(PageViewport page) {
        boolean ready;
        super.addPage(page);
        boolean bl = ready = this.renderer.supportsOutOfOrder() && page.isResolved();
        if (ready) {
            if (!this.renderer.supportsOutOfOrder() && page.getPageSequence().isFirstPage(page)) {
                this.renderer.startPageSequence(this.getCurrentPageSequence());
            }
            try {
                this.renderer.renderPage(page);
            }
            catch (RuntimeException re) {
                String err = "Error while rendering page " + page.getPageNumberString();
                log.error((Object)err, (Throwable)re);
                throw re;
            }
            catch (IOException ioe) {
                RendererEventProducer eventProducer = RendererEventProducer.Provider.get(this.renderer.getUserAgent().getEventBroadcaster());
                eventProducer.ioError(this, ioe);
            }
            catch (FOPException e) {
                String err = "Error while rendering page " + page.getPageNumberString();
                log.error((Object)err, (Throwable)e);
                throw new IllegalStateException("Fatal error occurred. Cannot continue. " + e.getClass().getName() + ": " + err);
            }
            page.clear();
        } else {
            this.preparePage(page);
        }
        boolean cont = this.checkPreparedPages(page, false);
        if (cont) {
            this.processOffDocumentItems(this.pendingODI);
            this.pendingODI.clear();
        }
    }

    protected boolean checkPreparedPages(PageViewport newPageViewport, boolean renderUnresolved) {
        Iterator<PageViewport> iter = this.prepared.iterator();
        while (iter.hasNext()) {
            PageViewport pageViewport = iter.next();
            if (pageViewport.isResolved() || renderUnresolved) {
                if (!this.renderer.supportsOutOfOrder() && pageViewport.getPageSequence().isFirstPage(pageViewport)) {
                    this.renderer.startPageSequence(pageViewport.getPageSequence());
                }
                this.renderPage(pageViewport);
                pageViewport.clear();
                iter.remove();
                continue;
            }
            if (this.renderer.supportsOutOfOrder()) continue;
            break;
        }
        return this.renderer.supportsOutOfOrder() || this.prepared.isEmpty();
    }

    protected void renderPage(PageViewport pageViewport) {
        block4: {
            try {
                this.renderer.renderPage(pageViewport);
                if (!pageViewport.isResolved()) {
                    String[] idrefs;
                    for (String idref : idrefs = pageViewport.getIDRefs()) {
                        AreaEventProducer eventProducer = AreaEventProducer.Provider.get(this.renderer.getUserAgent().getEventBroadcaster());
                        eventProducer.unresolvedIDReferenceOnPage(this, pageViewport.getPageNumberString(), idref);
                    }
                }
            }
            catch (Exception e) {
                AreaEventProducer eventProducer = AreaEventProducer.Provider.get(this.renderer.getUserAgent().getEventBroadcaster());
                eventProducer.pageRenderingError(this, pageViewport.getPageNumberString(), e);
                if (!(e instanceof RuntimeException)) break block4;
                throw (RuntimeException)e;
            }
        }
    }

    protected void preparePage(PageViewport page) {
        if (this.renderer.supportsOutOfOrder()) {
            this.renderer.preparePage(page);
        }
        this.prepared.add(page);
    }

    @Override
    public void handleOffDocumentItem(OffDocumentItem oDI) {
        switch (oDI.getWhenToProcess()) {
            case 0: {
                this.renderer.processOffDocumentItem(oDI);
                break;
            }
            case 1: {
                this.pendingODI.add(oDI);
                break;
            }
            case 2: {
                this.endDocODI.add(oDI);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void processOffDocumentItems(List<OffDocumentItem> list) {
        for (OffDocumentItem oDI : list) {
            this.renderer.processOffDocumentItem(oDI);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.checkPreparedPages(null, true);
        this.processOffDocumentItems(this.pendingODI);
        this.pendingODI.clear();
        this.processOffDocumentItems(this.endDocODI);
        try {
            this.renderer.stopRenderer();
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
    }
}

