/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBreak;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsContext;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsContinue;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsLabel;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsTry;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u0006J\b\u0010\u000e\u001a\u00020\fH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\tH\u0002J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/RedundantLabelRemoval;", "", "root", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsStatement;", "(Lcom/google/dart/compiler/backend/js/ast/JsStatement;)V", "hasChanges", "", "labelUsages", "", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsName;", "", "analyze", "", "apply", "perform", "statement", "name", "", "statements", "unuseLabel", "useLabel", "kotlin-compiler"})
public final class RedundantLabelRemoval {
    private final Map<JsName, Integer> labelUsages;
    private boolean hasChanges;
    private final JsStatement root;

    public final boolean apply() {
        this.analyze();
        this.perform();
        return this.hasChanges;
    }

    private final void analyze() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ RedundantLabelRemoval this$0;

            public void endVisit(@NotNull JsBreak x, @NotNull JsContext<?> ctx) {
                block1: {
                    Intrinsics.checkParameterIsNotNull(x, "x");
                    Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                    super.endVisit(x, ctx);
                    JsNameRef jsNameRef = x.getLabel();
                    if (jsNameRef == null) break block1;
                    JsNameRef jsNameRef2 = jsNameRef;
                    JsNameRef it = jsNameRef2;
                    JsName jsName = it.getName();
                    if (jsName == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "it.name!!");
                    RedundantLabelRemoval.access$useLabel(this.this$0, jsName);
                }
            }

            public void endVisit(@NotNull JsContinue x, @NotNull JsContext<?> ctx) {
                block1: {
                    Intrinsics.checkParameterIsNotNull(x, "x");
                    Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                    super.endVisit(x, ctx);
                    JsNameRef jsNameRef = x.getLabel();
                    if (jsNameRef == null) break block1;
                    JsNameRef jsNameRef2 = jsNameRef;
                    JsNameRef it = jsNameRef2;
                    JsName jsName = it.getName();
                    if (jsName == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "it.name!!");
                    RedundantLabelRemoval.access$useLabel(this.this$0, jsName);
                }
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
    }

    private final void perform() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ RedundantLabelRemoval this$0;

            public void endVisit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (MetadataProperties.getSynthetic(x)) {
                    JsStatement jsStatement = x.getStatement();
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement, "x.statement");
                    JsName jsName = x.getName();
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "x.name");
                    JsStatement statementReplacement = RedundantLabelRemoval.access$perform(this.this$0, jsStatement, jsName);
                    if (statementReplacement == null) {
                        RedundantLabelRemoval.access$setHasChanges$p(this.this$0, true);
                        ctx.removeMe();
                    } else {
                        Integer n = (Integer)RedundantLabelRemoval.access$getLabelUsages$p(this.this$0).get(x.getName());
                        if ((n != null ? n : 0) == 0) {
                            JsStatement replacement = statementReplacement;
                            if (replacement instanceof JsBlock) {
                                RedundantLabelRemoval.access$setHasChanges$p(this.this$0, true);
                                ctx.addPrevious(((JsBlock)replacement).getStatements());
                                ctx.removeMe();
                            } else if (Intrinsics.areEqual(replacement, ctx.getCurrentNode()) ^ true) {
                                RedundantLabelRemoval.access$setHasChanges$p(this.this$0, true);
                                ctx.replaceMe((JsNode)replacement);
                            }
                        } else {
                            x.setStatement(statementReplacement);
                        }
                    }
                }
                super.endVisit(x, ctx);
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return false;
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
    }

    private final JsStatement perform(JsStatement statement, JsName name) {
        JsStatement jsStatement;
        JsStatement jsStatement2 = statement;
        if (jsStatement2 instanceof JsBreak) {
            JsBreak jsBreak;
            JsNameRef jsNameRef = ((JsBreak)statement).getLabel();
            if (Intrinsics.areEqual(name, jsNameRef != null ? jsNameRef.getName() : null)) {
                this.unuseLabel(name);
                jsBreak = null;
            } else {
                jsBreak = (JsBreak)statement;
            }
            jsStatement = jsBreak;
        } else if (jsStatement2 instanceof JsLabel) {
            JsStatement jsStatement3 = ((JsLabel)statement).getStatement();
            Intrinsics.checkExpressionValueIsNotNull(jsStatement3, "statement.statement");
            JsStatement jsStatement4 = this.perform(jsStatement3, name);
            if (jsStatement4 != null) {
                JsStatement jsStatement5 = jsStatement4;
                JsStatement it = jsStatement5;
                jsStatement = statement;
            } else {
                jsStatement = null;
            }
        } else if (jsStatement2 instanceof JsBlock) {
            List<JsStatement> list2 = ((JsBlock)statement).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "statement.statements");
            jsStatement = this.perform(list2, name).isEmpty() ? (JsBlock)null : (JsBlock)statement;
        } else if (jsStatement2 instanceof JsIf) {
            JsIf jsIf;
            boolean elseRemoved;
            boolean bl;
            JsStatement jsStatement6 = ((JsIf)statement).getThenStatement();
            Intrinsics.checkExpressionValueIsNotNull(jsStatement6, "statement.thenStatement");
            boolean thenRemoved = this.perform(jsStatement6, name) == null;
            JsStatement jsStatement7 = ((JsIf)statement).getElseStatement();
            if (jsStatement7 != null) {
                JsStatement jsStatement8 = jsStatement7;
                JsStatement it = jsStatement8;
                bl = this.perform(it, name) == null;
            } else {
                bl = elseRemoved = false;
            }
            if (thenRemoved && elseRemoved) {
                jsIf = null;
            } else if (elseRemoved) {
                this.hasChanges = true;
                ((JsIf)statement).setElseStatement(null);
                jsIf = (JsIf)statement;
            } else if (thenRemoved) {
                this.hasChanges = true;
                ((JsIf)statement).setThenStatement(((JsIf)statement).getElseStatement());
                ((JsIf)statement).setElseStatement(null);
                ((JsIf)statement).setIfExpression(JsAstUtils.negated(((JsIf)statement).getIfExpression()));
                jsIf = (JsIf)statement;
            } else {
                jsIf = (JsIf)statement;
            }
            jsStatement = jsIf;
        } else if (jsStatement2 instanceof JsTry) {
            JsBlock finallyBlock = ((JsTry)statement).getFinallyBlock();
            JsStatement jsStatement9 = ((JsTry)statement).getTryBlock();
            Intrinsics.checkExpressionValueIsNotNull(jsStatement9, "statement.tryBlock");
            JsStatement result2 = this.perform(jsStatement9, name);
            jsStatement = result2 != null ? statement : (JsStatement)(finallyBlock != null && !finallyBlock.isEmpty() ? finallyBlock : (JsBlock)null);
        } else {
            jsStatement = statement;
        }
        return jsStatement;
    }

    private final List<JsStatement> perform(List<JsStatement> statements, JsName name) {
        JsStatement lastOptimized;
        JsStatement jsStatement;
        JsStatement last;
        JsStatement jsStatement2 = last = CollectionsKt.lastOrNull(statements);
        if (jsStatement2 != null) {
            JsStatement jsStatement3 = jsStatement2;
            JsStatement it = jsStatement3;
            jsStatement = this.perform(it, name);
        } else {
            jsStatement = lastOptimized = null;
        }
        if (Intrinsics.areEqual(lastOptimized, last) ^ true) {
            if (lastOptimized == null) {
                this.hasChanges = true;
                statements.remove(CollectionsKt.getLastIndex(statements));
            } else if (lastOptimized instanceof JsBlock) {
                this.hasChanges = true;
                statements.remove(CollectionsKt.getLastIndex(statements));
                Collection collection = ((JsBlock)lastOptimized).getStatements();
                Intrinsics.checkExpressionValueIsNotNull(collection, "lastOptimized.statements");
                statements.addAll(collection);
            } else if (Intrinsics.areEqual(statements.get(CollectionsKt.getLastIndex(statements)), lastOptimized) ^ true) {
                this.hasChanges = true;
                statements.set(CollectionsKt.getLastIndex(statements), lastOptimized);
            }
        }
        return statements;
    }

    private final void useLabel(JsName name) {
        Map<JsName, Integer> map2 = this.labelUsages;
        Integer n = this.labelUsages.get(name);
        Integer n2 = (n != null ? n : 0) + 1;
        map2.put(name, n2);
    }

    private final void unuseLabel(JsName name) {
        Map<JsName, Integer> map2 = this.labelUsages;
        Integer n = this.labelUsages.get(name);
        if (n == null) {
            Intrinsics.throwNpe();
        }
        Integer n2 = ((Number)n).intValue() - 1;
        map2.put(name, n2);
    }

    public RedundantLabelRemoval(@NotNull JsStatement root) {
        Intrinsics.checkParameterIsNotNull(root, "root");
        this.root = root;
        this.labelUsages = MapsKt.mutableMapOf(new Pair[0]);
    }

    public static final /* synthetic */ void access$useLabel(RedundantLabelRemoval $this, @NotNull JsName name) {
        $this.useLabel(name);
    }

    @Nullable
    public static final /* synthetic */ JsStatement access$perform(RedundantLabelRemoval $this, @NotNull JsStatement statement, @NotNull JsName name) {
        return $this.perform(statement, name);
    }

    public static final /* synthetic */ boolean access$getHasChanges$p(RedundantLabelRemoval $this) {
        return $this.hasChanges;
    }

    public static final /* synthetic */ void access$setHasChanges$p(RedundantLabelRemoval $this, boolean bl) {
        $this.hasChanges = bl;
    }

    @NotNull
    public static final /* synthetic */ Map access$getLabelUsages$p(RedundantLabelRemoval $this) {
        return $this.labelUsages;
    }
}

