/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.Collection;
import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.javax.inject.Inject;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializationComponentsForJava;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmPackagePartSource;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.protobuf.InvalidProtocolBufferException;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import kotlin.reflect.jvm.internal.impl.serialization.PackageData;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ErrorReporter;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBufUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeserializedDescriptorResolver {
    @NotNull
    public DeserializationComponents components;
    private final ErrorReporter errorReporter;
    @NotNull
    private static final Set<KotlinClassHeader.Kind> KOTLIN_CLASS;
    private static final Set<KotlinClassHeader.Kind> KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART;
    public static final Companion Companion;

    @NotNull
    public final DeserializationComponents getComponents() {
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
        }
        return deserializationComponents;
    }

    public final void setComponents(@NotNull DeserializationComponents deserializationComponents) {
        Intrinsics.checkParameterIsNotNull((Object)deserializationComponents, (String)"<set-?>");
        this.components = deserializationComponents;
    }

    @Inject
    public final void setComponents(@NotNull DeserializationComponentsForJava components) {
        Intrinsics.checkParameterIsNotNull((Object)components, (String)"components");
        this.components = components.getComponents();
    }

    @Nullable
    public final ClassDescriptor resolveClass(@NotNull KotlinJvmBinaryClass kotlinClass) {
        ClassData classData;
        Intrinsics.checkParameterIsNotNull((Object)kotlinClass, (String)"kotlinClass");
        String[] stringArray = this.readData$kotlin_core(kotlinClass, Companion.getKOTLIN_CLASS$kotlin_core());
        if (stringArray == null) {
            return null;
        }
        String[] data = stringArray;
        String[] $receiver$iv = kotlinClass.getClassHeader().getStrings();
        if ($receiver$iv == null) {
            AssertionError assertionError;
            AssertionError assertionError2 = assertionError;
            AssertionError assertionError3 = assertionError;
            String string = "String table not found in " + kotlinClass;
            assertionError2((Object)string);
            throw (Throwable)((Object)assertionError3);
        }
        String[] strings = $receiver$iv;
        DeserializedDescriptorResolver $i$a$1$sure = this;
        try {
            classData = JvmProtoBufUtil.readClassDataFrom(data, strings);
        }
        catch (InvalidProtocolBufferException e$iv) {
            throw (Throwable)new IllegalStateException("Could not read data from " + kotlinClass.getLocation(), e$iv);
        }
        ClassData classData2 = classData;
        KotlinJvmBinarySourceElement sourceElement = new KotlinJvmBinarySourceElement(kotlinClass);
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
        }
        return deserializationComponents.getClassDeserializer().deserializeClass(kotlinClass.getClassId(), new ClassDataWithSource(classData2, sourceElement));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MemberScope createKotlinPackagePartScope(@NotNull PackageFragmentDescriptor descriptor2, @NotNull KotlinJvmBinaryClass kotlinClass) {
        void nameResolver;
        void packageProto;
        PackageData packageData;
        NameResolver $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)kotlinClass, (String)"kotlinClass");
        String[] stringArray = this.readData$kotlin_core(kotlinClass, DeserializedDescriptorResolver.Companion.getKOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART());
        if (stringArray == null) {
            return null;
        }
        String[] data = stringArray;
        String[] stringArray2 = kotlinClass.getClassHeader().getStrings();
        void v1 = $receiver$iv;
        if (v1 == null) {
            AssertionError assertionError;
            AssertionError assertionError2 = assertionError;
            AssertionError assertionError3 = assertionError;
            String string = "String table not found in " + kotlinClass;
            assertionError2((Object)string);
            throw (Throwable)((Object)assertionError3);
        }
        String[] strings = (String[])v1;
        DeserializedDescriptorResolver deserializedDescriptorResolver = this;
        try {
            packageData = JvmProtoBufUtil.readPackageDataFrom(data, strings);
        }
        catch (InvalidProtocolBufferException e$iv) {
            throw (Throwable)new IllegalStateException("Could not read data from " + kotlinClass.getLocation(), e$iv);
        }
        PackageData $i$f$sure = packageData;
        $receiver$iv = $i$f$sure.component1();
        ProtoBuf.Package $i$a$1$sure = $i$f$sure.component2();
        $i$f$sure = null;
        JvmPackagePartSource source = new JvmPackagePartSource(kotlinClass);
        SourceElement sourceElement = source;
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
        }
        return new DeserializedPackageMemberScope(descriptor2, (ProtoBuf.Package)packageProto, (NameResolver)nameResolver, sourceElement, deserializationComponents, (Function0<? extends Collection<Name>>)((Function0)createKotlinPackagePartScope.2.INSTANCE));
    }

    @Nullable
    public final String[] readData$kotlin_core(@NotNull KotlinJvmBinaryClass kotlinClass, @NotNull Set<? extends KotlinClassHeader.Kind> expectedKinds) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinClass, (String)"kotlinClass");
        Intrinsics.checkParameterIsNotNull(expectedKinds, (String)"expectedKinds");
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (!header.getMetadataVersion().isCompatible()) {
            this.errorReporter.reportIncompatibleMetadataVersion(kotlinClass.getClassId(), kotlinClass.getLocation(), header.getMetadataVersion());
        } else if (expectedKinds.contains((Object)header.getKind())) {
            return header.getData();
        }
        return null;
    }

    private final <T> T parseProto(KotlinJvmBinaryClass klass, Function0<? extends T> block) {
        try {
            return (T)block.invoke();
        }
        catch (InvalidProtocolBufferException e) {
            throw (Throwable)new IllegalStateException("Could not read data from " + klass.getLocation(), e);
        }
    }

    public DeserializedDescriptorResolver(@NotNull ErrorReporter errorReporter) {
        Intrinsics.checkParameterIsNotNull((Object)errorReporter, (String)"errorReporter");
        this.errorReporter = errorReporter;
    }

    static {
        Companion = new Companion(null);
        KOTLIN_CLASS = SetsKt.setOf((Object)((Object)KotlinClassHeader.Kind.CLASS));
        KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART = SetsKt.setOf((Object[])new KotlinClassHeader.Kind[]{KotlinClassHeader.Kind.FILE_FACADE, KotlinClassHeader.Kind.MULTIFILE_CLASS_PART});
    }

    public static final class Companion {
        @NotNull
        public final Set<KotlinClassHeader.Kind> getKOTLIN_CLASS$kotlin_core() {
            return KOTLIN_CLASS;
        }

        private final Set<KotlinClassHeader.Kind> getKOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART() {
            return KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

