/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.allocation;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.admin.cluster.allocation.ClusterAllocationExplanation;
import org.elasticsearch.action.admin.indices.shards.IndicesShardStoresResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class NodeExplanation
implements Writeable,
ToXContent {
    private final DiscoveryNode node;
    private final Decision nodeDecision;
    private final Float nodeWeight;
    private final IndicesShardStoresResponse.StoreStatus storeStatus;
    private final ClusterAllocationExplanation.FinalDecision finalDecision;
    private final ClusterAllocationExplanation.StoreCopy storeCopy;
    private final String finalExplanation;

    public NodeExplanation(DiscoveryNode node, Decision nodeDecision, Float nodeWeight, @Nullable IndicesShardStoresResponse.StoreStatus storeStatus, ClusterAllocationExplanation.FinalDecision finalDecision, String finalExplanation, ClusterAllocationExplanation.StoreCopy storeCopy) {
        this.node = node;
        this.nodeDecision = nodeDecision;
        this.nodeWeight = nodeWeight;
        this.storeStatus = storeStatus;
        this.finalDecision = finalDecision;
        this.finalExplanation = finalExplanation;
        this.storeCopy = storeCopy;
    }

    public NodeExplanation(StreamInput in) throws IOException {
        this.node = new DiscoveryNode(in);
        this.nodeDecision = Decision.readFrom(in);
        this.nodeWeight = Float.valueOf(in.readFloat());
        this.storeStatus = in.readBoolean() ? IndicesShardStoresResponse.StoreStatus.readStoreStatus(in) : null;
        this.finalDecision = ClusterAllocationExplanation.FinalDecision.readFrom(in);
        this.finalExplanation = in.readString();
        this.storeCopy = ClusterAllocationExplanation.StoreCopy.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.node.writeTo(out);
        Decision.writeTo(this.nodeDecision, out);
        out.writeFloat(this.nodeWeight.floatValue());
        if (this.storeStatus == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.storeStatus.writeTo(out);
        }
        this.finalDecision.writeTo(out);
        out.writeString(this.finalExplanation);
        this.storeCopy.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Exception storeErr;
        builder.startObject(this.node.getId());
        builder.field("node_name", this.node.getName());
        builder.startObject("node_attributes");
        for (Map.Entry<String, String> attrEntry : this.node.getAttributes().entrySet()) {
            builder.field(attrEntry.getKey(), attrEntry.getValue());
        }
        builder.endObject();
        builder.startObject("store");
        builder.field("shard_copy", this.storeCopy.toString());
        if (this.storeStatus != null && (storeErr = this.storeStatus.getStoreException()) != null) {
            builder.field("store_exception", ExceptionsHelper.detailedMessage(storeErr));
        }
        builder.endObject();
        builder.field("final_decision", this.finalDecision.toString());
        builder.field("final_explanation", this.finalExplanation.toString());
        builder.field("weight", this.nodeWeight);
        this.nodeDecision.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public DiscoveryNode getNode() {
        return this.node;
    }

    public Decision getDecision() {
        return this.nodeDecision;
    }

    public Float getWeight() {
        return this.nodeWeight;
    }

    @Nullable
    public IndicesShardStoresResponse.StoreStatus getStoreStatus() {
        return this.storeStatus;
    }

    public ClusterAllocationExplanation.FinalDecision getFinalDecision() {
        return this.finalDecision;
    }

    public String getFinalExplanation() {
        return this.finalExplanation;
    }

    public ClusterAllocationExplanation.StoreCopy getStoreCopy() {
        return this.storeCopy;
    }
}

