/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.restore;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.RestoreInfo;

public class RestoreSnapshotResponse
extends ActionResponse
implements ToXContent {
    @Nullable
    private RestoreInfo restoreInfo;

    RestoreSnapshotResponse(@Nullable RestoreInfo restoreInfo) {
        this.restoreInfo = restoreInfo;
    }

    RestoreSnapshotResponse() {
    }

    public RestoreInfo getRestoreInfo() {
        return this.restoreInfo;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.restoreInfo = RestoreInfo.readOptionalRestoreInfo(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalStreamable(this.restoreInfo);
    }

    public RestStatus status() {
        if (this.restoreInfo == null) {
            return RestStatus.ACCEPTED;
        }
        return this.restoreInfo.status();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.restoreInfo != null) {
            builder.field("snapshot");
            this.restoreInfo.toXContent(builder, params);
        } else {
            builder.field("accepted", true);
        }
        return builder;
    }
}

