/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.AbstractAsyncAction;
import org.elasticsearch.action.search.ParsedScrollId;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollQueryAndFetchAsyncAction;
import org.elasticsearch.action.search.SearchScrollQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSearchScrollAction
extends HandledTransportAction<SearchScrollRequest, SearchResponse> {
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final SearchPhaseController searchPhaseController;

    @Inject
    public TransportSearchScrollAction(Settings settings, BigArrays bigArrays, ThreadPool threadPool, ScriptService scriptService, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/scroll", threadPool, transportService, actionFilters, indexNameExpressionResolver, SearchScrollRequest::new);
        this.clusterService = clusterService;
        this.searchTransportService = new SearchTransportService(settings, transportService);
        this.searchPhaseController = new SearchPhaseController(settings, bigArrays, scriptService, clusterService);
    }

    @Override
    protected void doExecute(SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        try {
            AbstractAsyncAction action;
            ParsedScrollId scrollId = TransportSearchHelper.parseScrollId(request.scrollId());
            switch (scrollId.getType()) {
                case "queryThenFetch": {
                    action = new SearchScrollQueryThenFetchAsyncAction(this.logger, this.clusterService, this.searchTransportService, this.searchPhaseController, request, scrollId, listener);
                    break;
                }
                case "queryAndFetch": {
                    action = new SearchScrollQueryAndFetchAsyncAction(this.logger, this.clusterService, this.searchTransportService, this.searchPhaseController, request, scrollId, listener);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Scroll id type [" + scrollId.getType() + "] unrecognized");
                }
            }
            action.start();
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

