/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import org.apache.lucene.util.BytesRef;

public final class Numbers {
    private Numbers() {
    }

    public static short bytesToShort(byte[] arr) {
        return (short)((arr[0] & 0xFF) << 8 | arr[1] & 0xFF);
    }

    public static short bytesToShort(BytesRef bytes) {
        return (short)((bytes.bytes[bytes.offset] & 0xFF) << 8 | bytes.bytes[bytes.offset + 1] & 0xFF);
    }

    public static int bytesToInt(byte[] arr) {
        return arr[0] << 24 | (arr[1] & 0xFF) << 16 | (arr[2] & 0xFF) << 8 | arr[3] & 0xFF;
    }

    public static int bytesToInt(BytesRef bytes) {
        return bytes.bytes[bytes.offset] << 24 | (bytes.bytes[bytes.offset + 1] & 0xFF) << 16 | (bytes.bytes[bytes.offset + 2] & 0xFF) << 8 | bytes.bytes[bytes.offset + 3] & 0xFF;
    }

    public static long bytesToLong(byte[] arr) {
        int high = arr[0] << 24 | (arr[1] & 0xFF) << 16 | (arr[2] & 0xFF) << 8 | arr[3] & 0xFF;
        int low = arr[4] << 24 | (arr[5] & 0xFF) << 16 | (arr[6] & 0xFF) << 8 | arr[7] & 0xFF;
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }

    public static long bytesToLong(BytesRef bytes) {
        int high = bytes.bytes[bytes.offset + 0] << 24 | (bytes.bytes[bytes.offset + 1] & 0xFF) << 16 | (bytes.bytes[bytes.offset + 2] & 0xFF) << 8 | bytes.bytes[bytes.offset + 3] & 0xFF;
        int low = bytes.bytes[bytes.offset + 4] << 24 | (bytes.bytes[bytes.offset + 5] & 0xFF) << 16 | (bytes.bytes[bytes.offset + 6] & 0xFF) << 8 | bytes.bytes[bytes.offset + 7] & 0xFF;
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }

    public static float bytesToFloat(byte[] arr) {
        return Float.intBitsToFloat(Numbers.bytesToInt(arr));
    }

    public static float bytesToFloat(BytesRef bytes) {
        return Float.intBitsToFloat(Numbers.bytesToInt(bytes));
    }

    public static double bytesToDouble(byte[] arr) {
        return Double.longBitsToDouble(Numbers.bytesToLong(arr));
    }

    public static double bytesToDouble(BytesRef bytes) {
        return Double.longBitsToDouble(Numbers.bytesToLong(bytes));
    }

    public static byte[] intToBytes(int val) {
        byte[] arr = new byte[]{(byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
        return arr;
    }

    public static byte[] shortToBytes(int val) {
        byte[] arr = new byte[]{(byte)(val >>> 8), (byte)val};
        return arr;
    }

    public static byte[] longToBytes(long val) {
        byte[] arr = new byte[]{(byte)(val >>> 56), (byte)(val >>> 48), (byte)(val >>> 40), (byte)(val >>> 32), (byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
        return arr;
    }

    public static byte[] floatToBytes(float val) {
        return Numbers.intToBytes(Float.floatToRawIntBits(val));
    }

    public static byte[] doubleToBytes(double val) {
        return Numbers.longToBytes(Double.doubleToRawLongBits(val));
    }

    public static boolean isValidDouble(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }
}

