/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.intermediate.BorderPainter;
import org.apache.fop.render.pdf.PDFContentGenerator;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.ColorUtil;

public class PDFBorderPainter
extends BorderPainter {
    private static final Log LOG = LogFactory.getLog(PDFBorderPainter.class);
    private PDFContentGenerator generator;

    public PDFBorderPainter(PDFContentGenerator generator) {
        this.generator = generator;
    }

    protected void drawBorderLine(int x1, int y1, int x2, int y2, boolean horz, boolean startOrBefore, int style, Color col) {
        PDFBorderPainter.drawBorderLine(this.generator, (float)x1 / 1000.0f, (float)y1 / 1000.0f, (float)x2 / 1000.0f, (float)y2 / 1000.0f, horz, startOrBefore, style, col);
    }

    public static void drawBorderLine(PDFContentGenerator generator, float x1, float y1, float x2, float y2, boolean horz, boolean startOrBefore, int style, Color col) {
        float w = x2 - x1;
        float h = y2 - y1;
        if (w < 0.0f || h < 0.0f) {
            LOG.error("Negative extent received (w=" + w + ", h=" + h + "). Border won't be painted.");
            return;
        }
        switch (style) {
            case 31: {
                generator.setColor(col, false);
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    generator.add("[" + PDFBorderPainter.format(unit) + "] 0 d ");
                    generator.add(PDFBorderPainter.format(h) + " w\n");
                    float ym = y1 + h / 2.0f;
                    generator.add(PDFBorderPainter.format(x1) + " " + PDFBorderPainter.format(ym) + " m " + PDFBorderPainter.format(x2) + " " + PDFBorderPainter.format(ym) + " l S\n");
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                generator.add("[" + PDFBorderPainter.format(unit) + "] 0 d ");
                generator.add(PDFBorderPainter.format(w) + " w\n");
                float xm = x1 + w / 2.0f;
                generator.add(PDFBorderPainter.format(xm) + " " + PDFBorderPainter.format(y1) + " m " + PDFBorderPainter.format(xm) + " " + PDFBorderPainter.format(y2) + " l S\n");
                break;
            }
            case 36: {
                generator.setColor(col, false);
                generator.add("1 J ");
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    generator.add("[0 " + PDFBorderPainter.format(unit) + "] 0 d ");
                    generator.add(PDFBorderPainter.format(h) + " w\n");
                    float ym = y1 + h / 2.0f;
                    generator.add(PDFBorderPainter.format(x1) + " " + PDFBorderPainter.format(ym) + " m " + PDFBorderPainter.format(x2) + " " + PDFBorderPainter.format(ym) + " l S\n");
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                generator.add("[0 " + PDFBorderPainter.format(unit) + " ] 0 d ");
                generator.add(PDFBorderPainter.format(w) + " w\n");
                float xm = x1 + w / 2.0f;
                generator.add(PDFBorderPainter.format(xm) + " " + PDFBorderPainter.format(y1) + " m " + PDFBorderPainter.format(xm) + " " + PDFBorderPainter.format(y2) + " l S\n");
                break;
            }
            case 37: {
                generator.setColor(col, false);
                generator.add("[] 0 d ");
                if (horz) {
                    float h3 = h / 3.0f;
                    generator.add(PDFBorderPainter.format(h3) + " w\n");
                    float ym1 = y1 + h3 / 2.0f;
                    float ym2 = ym1 + h3 + h3;
                    generator.add(PDFBorderPainter.format(x1) + " " + PDFBorderPainter.format(ym1) + " m " + PDFBorderPainter.format(x2) + " " + PDFBorderPainter.format(ym1) + " l S\n");
                    generator.add(PDFBorderPainter.format(x1) + " " + PDFBorderPainter.format(ym2) + " m " + PDFBorderPainter.format(x2) + " " + PDFBorderPainter.format(ym2) + " l S\n");
                    break;
                }
                float w3 = w / 3.0f;
                generator.add(PDFBorderPainter.format(w3) + " w\n");
                float xm1 = x1 + w3 / 2.0f;
                float xm2 = xm1 + w3 + w3;
                generator.add(PDFBorderPainter.format(xm1) + " " + PDFBorderPainter.format(y1) + " m " + PDFBorderPainter.format(xm1) + " " + PDFBorderPainter.format(y2) + " l S\n");
                generator.add(PDFBorderPainter.format(xm2) + " " + PDFBorderPainter.format(y1) + " m " + PDFBorderPainter.format(xm2) + " " + PDFBorderPainter.format(y2) + " l S\n");
                break;
            }
            case 55: 
            case 119: {
                float colFactor = style == 55 ? 0.4f : -0.4f;
                generator.add("[] 0 d ");
                if (horz) {
                    Color uppercol = ColorUtil.lightenColor(col, -colFactor);
                    Color lowercol = ColorUtil.lightenColor(col, colFactor);
                    float h3 = h / 3.0f;
                    generator.add(PDFBorderPainter.format(h3) + " w\n");
                    float ym1 = y1 + h3 / 2.0f;
                    generator.setColor(uppercol, false);
                    generator.add(PDFBorderPainter.format(x1) + " " + PDFBorderPainter.format(ym1) + " m " + PDFBorderPainter.format(x2) + " " + PDFBorderPainter.format(ym1) + " l S\n");
                    generator.setColor(col, false);
                    generator.add(PDFBorderPainter.format(x1) + " " + PDFBorderPainter.format(ym1 + h3) + " m " + PDFBorderPainter.format(x2) + " " + PDFBorderPainter.format(ym1 + h3) + " l S\n");
                    generator.setColor(lowercol, false);
                    generator.add(PDFBorderPainter.format(x1) + " " + PDFBorderPainter.format(ym1 + h3 + h3) + " m " + PDFBorderPainter.format(x2) + " " + PDFBorderPainter.format(ym1 + h3 + h3) + " l S\n");
                    break;
                }
                Color leftcol = ColorUtil.lightenColor(col, -colFactor);
                Color rightcol = ColorUtil.lightenColor(col, colFactor);
                float w3 = w / 3.0f;
                generator.add(PDFBorderPainter.format(w3) + " w\n");
                float xm1 = x1 + w3 / 2.0f;
                generator.setColor(leftcol, false);
                generator.add(PDFBorderPainter.format(xm1) + " " + PDFBorderPainter.format(y1) + " m " + PDFBorderPainter.format(xm1) + " " + PDFBorderPainter.format(y2) + " l S\n");
                generator.setColor(col, false);
                generator.add(PDFBorderPainter.format(xm1 + w3) + " " + PDFBorderPainter.format(y1) + " m " + PDFBorderPainter.format(xm1 + w3) + " " + PDFBorderPainter.format(y2) + " l S\n");
                generator.setColor(rightcol, false);
                generator.add(PDFBorderPainter.format(xm1 + w3 + w3) + " " + PDFBorderPainter.format(y1) + " m " + PDFBorderPainter.format(xm1 + w3 + w3) + " " + PDFBorderPainter.format(y2) + " l S\n");
                break;
            }
            case 67: 
            case 101: {
                float colFactor = style == 101 ? 0.4f : -0.4f;
                generator.add("[] 0 d ");
                Color c = col;
                if (horz) {
                    c = ColorUtil.lightenColor(c, (float)(startOrBefore ? 1 : -1) * colFactor);
                    generator.add(PDFBorderPainter.format(h) + " w\n");
                    float ym1 = y1 + h / 2.0f;
                    generator.setColor(c, false);
                    generator.add(PDFBorderPainter.format(x1) + " " + PDFBorderPainter.format(ym1) + " m " + PDFBorderPainter.format(x2) + " " + PDFBorderPainter.format(ym1) + " l S\n");
                    break;
                }
                c = ColorUtil.lightenColor(c, (float)(startOrBefore ? 1 : -1) * colFactor);
                generator.add(PDFBorderPainter.format(w) + " w\n");
                float xm1 = x1 + w / 2.0f;
                generator.setColor(c, false);
                generator.add(PDFBorderPainter.format(xm1) + " " + PDFBorderPainter.format(y1) + " m " + PDFBorderPainter.format(xm1) + " " + PDFBorderPainter.format(y2) + " l S\n");
                break;
            }
            case 57: {
                break;
            }
            default: {
                generator.setColor(col, false);
                generator.add("[] 0 d ");
                if (horz) {
                    generator.add(PDFBorderPainter.format(h) + " w\n");
                    float ym = y1 + h / 2.0f;
                    generator.add(PDFBorderPainter.format(x1) + " " + PDFBorderPainter.format(ym) + " m " + PDFBorderPainter.format(x2) + " " + PDFBorderPainter.format(ym) + " l S\n");
                    break;
                }
                generator.add(PDFBorderPainter.format(w) + " w\n");
                float xm = x1 + w / 2.0f;
                generator.add(PDFBorderPainter.format(xm) + " " + PDFBorderPainter.format(y1) + " m " + PDFBorderPainter.format(xm) + " " + PDFBorderPainter.format(y2) + " l S\n");
            }
        }
    }

    public void drawLine(Point start, Point end, int width, Color color, RuleStyle style) {
        if (start.y != end.y) {
            throw new UnsupportedOperationException("Can only deal with horizontal lines right now");
        }
        this.saveGraphicsState();
        int half = width / 2;
        int starty = start.y - half;
        Rectangle boundingRect = new Rectangle(start.x, start.y - half, end.x - start.x, width);
        switch (style.getEnumValue()) {
            case 31: 
            case 37: 
            case 133: {
                this.drawBorderLine(start.x, start.y - half, end.x, end.y + half, true, true, style.getEnumValue(), color);
                break;
            }
            case 36: {
                this.generator.clipRect(boundingRect);
                this.generator.add("1 0 0 1 " + PDFBorderPainter.format(half) + " 0 cm\n");
                this.drawBorderLine(start.x, start.y - half, end.x, end.y + half, true, true, style.getEnumValue(), color);
                break;
            }
            case 55: 
            case 119: {
                this.generator.setColor(ColorUtil.lightenColor(color, 0.6f), true);
                this.generator.add(PDFBorderPainter.format(start.x) + " " + PDFBorderPainter.format(starty) + " m\n");
                this.generator.add(PDFBorderPainter.format(end.x) + " " + PDFBorderPainter.format(starty) + " l\n");
                this.generator.add(PDFBorderPainter.format(end.x) + " " + PDFBorderPainter.format(starty + 2 * half) + " l\n");
                this.generator.add(PDFBorderPainter.format(start.x) + " " + PDFBorderPainter.format(starty + 2 * half) + " l\n");
                this.generator.add("h\n");
                this.generator.add("f\n");
                this.generator.setColor(color, true);
                if (style == RuleStyle.GROOVE) {
                    this.generator.add(PDFBorderPainter.format(start.x) + " " + PDFBorderPainter.format(starty) + " m\n");
                    this.generator.add(PDFBorderPainter.format(end.x) + " " + PDFBorderPainter.format(starty) + " l\n");
                    this.generator.add(PDFBorderPainter.format(end.x) + " " + PDFBorderPainter.format(starty + half) + " l\n");
                    this.generator.add(PDFBorderPainter.format(start.x + half) + " " + PDFBorderPainter.format(starty + half) + " l\n");
                    this.generator.add(PDFBorderPainter.format(start.x) + " " + PDFBorderPainter.format(starty + 2 * half) + " l\n");
                } else {
                    this.generator.add(PDFBorderPainter.format(end.x) + " " + PDFBorderPainter.format(starty) + " m\n");
                    this.generator.add(PDFBorderPainter.format(end.x) + " " + PDFBorderPainter.format(starty + 2 * half) + " l\n");
                    this.generator.add(PDFBorderPainter.format(start.x) + " " + PDFBorderPainter.format(starty + 2 * half) + " l\n");
                    this.generator.add(PDFBorderPainter.format(start.x) + " " + PDFBorderPainter.format(starty + half) + " l\n");
                    this.generator.add(PDFBorderPainter.format(end.x - half) + " " + PDFBorderPainter.format(starty + half) + " l\n");
                }
                this.generator.add("h\n");
                this.generator.add("f\n");
                break;
            }
            default: {
                throw new UnsupportedOperationException("rule style not supported");
            }
        }
        this.restoreGraphicsState();
    }

    static final String format(int coordinate) {
        return PDFBorderPainter.format((float)coordinate / 1000.0f);
    }

    static final String format(float coordinate) {
        return PDFContentGenerator.format(coordinate);
    }

    protected void moveTo(int x, int y) {
        this.generator.add(PDFBorderPainter.format(x) + " " + PDFBorderPainter.format(y) + " m ");
    }

    protected void lineTo(int x, int y) {
        this.generator.add(PDFBorderPainter.format(x) + " " + PDFBorderPainter.format(y) + " l ");
    }

    protected void closePath() {
        this.generator.add("h ");
    }

    protected void clip() {
        this.generator.add("W\nn\n");
    }

    protected void saveGraphicsState() {
        this.generator.add("q\n");
    }

    protected void restoreGraphicsState() {
        this.generator.add("Q\n");
    }
}

