/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    RGB[] rgbs;

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, ColorDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        int n;
        int n2;
        int n3;
        int n4;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        int n5 = 0;
        n5 = OS.GTK_VERSION >= OS.VERSION(3, 4, 0) ? OS.gtk_color_chooser_dialog_new(byArray, this.parent.topHandle()) : OS.gtk_color_selection_dialog_new(byArray);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        int n6 = 0;
        GdkColor gdkColor = new GdkColor();
        GdkRGBA gdkRGBA = new GdkRGBA();
        if (OS.GTK_VERSION <= OS.VERSION(3, 4, 0)) {
            if (this.parent != null) {
                n4 = this.parent.topHandle();
                OS.gtk_window_set_transient_for(n5, n4);
                n3 = OS.gtk_window_get_icon_list(n4);
                if (n3 != 0) {
                    OS.gtk_window_set_icon_list(n5, n3);
                    OS.g_list_free(n3);
                }
            }
            n4 = OS.gtk_window_get_group(0);
            OS.gtk_window_group_add_window(n4, n5);
            OS.gtk_window_set_modal(n5, true);
            n6 = OS.gtk_color_selection_dialog_get_color_selection(n5);
            if (this.rgb != null) {
                gdkColor.red = (short)(this.rgb.red & 0xFF | (this.rgb.red & 0xFF) << 8);
                gdkColor.green = (short)(this.rgb.green & 0xFF | (this.rgb.green & 0xFF) << 8);
                gdkColor.blue = (short)(this.rgb.blue & 0xFF | (this.rgb.blue & 0xFF) << 8);
                OS.gtk_color_selection_set_current_color(n6, gdkColor);
            }
            OS.gtk_color_selection_set_has_palette(n6, true);
        } else {
            if (this.rgb != null) {
                gdkRGBA.red = (double)this.rgb.red / 255.0;
                gdkRGBA.green = (double)this.rgb.green / 255.0;
                gdkRGBA.blue = (double)this.rgb.blue / 255.0;
                gdkRGBA.alpha = 1.0;
            }
            OS.gtk_color_chooser_set_rgba(n5, gdkRGBA);
        }
        if (this.rgbs != null) {
            Object object;
            if (OS.GTK_VERSION >= OS.VERSION(3, 4, 0)) {
                n4 = 9;
                n3 = OS.g_malloc(GdkRGBA.sizeof * this.rgbs.length);
                for (n2 = 0; n2 < this.rgbs.length; ++n2) {
                    object = this.rgbs[n2];
                    if (object == null) continue;
                    gdkRGBA.red = (double)((RGB)object).red / 255.0;
                    gdkRGBA.green = (double)((RGB)object).green / 255.0;
                    gdkRGBA.blue = (double)((RGB)object).blue / 255.0;
                    OS.memmove(n3 + n2 * GdkRGBA.sizeof, gdkRGBA, GdkRGBA.sizeof);
                }
                OS.gtk_color_chooser_add_palette(n5, 0, n4, this.rgbs.length, n3);
                OS.gtk_color_chooser_set_rgba(n5, gdkRGBA);
                if (OS.gtk_color_chooser_get_use_alpha(n5)) {
                    OS.gtk_color_chooser_set_use_alpha(n5, false);
                }
                OS.g_free(n3);
            } else {
                n4 = OS.g_malloc(GdkColor.sizeof * this.rgbs.length);
                for (n3 = 0; n3 < this.rgbs.length; ++n3) {
                    RGB rGB = this.rgbs[n3];
                    if (rGB == null) continue;
                    gdkColor.red = (short)(rGB.red & 0xFF | (rGB.red & 0xFF) << 8);
                    gdkColor.green = (short)(rGB.green & 0xFF | (rGB.green & 0xFF) << 8);
                    gdkColor.blue = (short)(rGB.blue & 0xFF | (rGB.blue & 0xFF) << 8);
                    OS.memmove(n4 + n3 * GdkColor.sizeof, gdkColor, GdkColor.sizeof);
                }
                n3 = OS.gtk_color_selection_palette_to_string(n4, this.rgbs.length);
                n2 = OS.strlen(n3);
                byArray = new byte[n2];
                OS.memmove(byArray, n3, n2);
                object = new String(Converter.mbcsToWcs(null, byArray));
                byArray = Converter.wcsToMbcs(null, (String)object, true);
                OS.g_free(n4);
                n = OS.gtk_settings_get_default();
                if (n != 0) {
                    OS.gtk_settings_set_string_property(n, OS.gtk_color_palette, byArray, Converter.wcsToMbcs(null, "gtk_color_selection_palette_to_string", true));
                }
            }
        }
        display.addIdleProc();
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(n5)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        n3 = 0;
        n2 = 0;
        if ((this.style & 0x4000000) != 0) {
            n3 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            n2 = OS.g_signal_add_emission_hook(n3, 0, display.emissionProc, n5, 0);
        }
        display.sendPreExternalEventDispatchEvent();
        int n7 = OS.gtk_dialog_run(n5);
        OS.gdk_threads_leave();
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n3, n2);
        }
        if (OS.gtk_window_get_modal(n5)) {
            display.setModalDialog(dialog);
        }
        int n8 = n = n7 == -5 ? 1 : 0;
        if (n != 0) {
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            if (OS.GTK_VERSION >= OS.VERSION(3, 4, 0)) {
                OS.gtk_color_chooser_get_rgba(n5, gdkRGBA);
                n9 = (int)(gdkRGBA.red * 255.0);
                n10 = (int)(gdkRGBA.green * 255.0);
                n11 = (int)(gdkRGBA.blue * 255.0);
            } else {
                OS.gtk_color_selection_get_current_color(n6, gdkColor);
                n9 = gdkColor.red >> 8 & 0xFF;
                n10 = gdkColor.green >> 8 & 0xFF;
                n11 = gdkColor.blue >> 8 & 0xFF;
                int n12 = OS.gtk_settings_get_default();
                if (n12 != 0) {
                    int[] nArray = new int[1];
                    OS.g_object_get(n12, OS.gtk_color_palette, nArray, 0);
                    if (nArray[0] != 0) {
                        int n13 = OS.strlen(nArray[0]);
                        byArray = new byte[n13];
                        OS.memmove(byArray, nArray[0], n13);
                        OS.g_free(nArray[0]);
                        String[] stringArray = null;
                        if (n13 > 0) {
                            String string = new String(Converter.mbcsToWcs(null, byArray));
                            stringArray = ColorDialog.splitString(string, ':');
                            n13 = stringArray.length;
                        }
                        this.rgbs = new RGB[n13];
                        for (int i = 0; i < n13; ++i) {
                            String string = stringArray[i];
                            byArray = Converter.wcsToMbcs(null, string, true);
                            OS.gdk_color_parse(byArray, gdkColor);
                            int n14 = gdkColor.red >> 8 & 0xFF;
                            int n15 = gdkColor.green >> 8 & 0xFF;
                            int n16 = gdkColor.blue >> 8 & 0xFF;
                            this.rgbs[i] = new RGB(n14, n15, n16);
                        }
                    }
                }
            }
            this.rgb = new RGB(n9, n10, n11);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(n5);
        if (n == 0) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    public void setRGBs(RGB[] rGBArray) {
        this.rgbs = rGBArray;
    }

    static String[] splitString(String string, char c) {
        String[] stringArray = new String[1];
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            n2 = string.indexOf(c, n);
            if (n2 == -1) {
                stringArray[stringArray.length - 1] = string.substring(n);
                continue;
            }
            stringArray[stringArray.length - 1] = string.substring(n, n2);
            n = n2 + 1;
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        }
        return stringArray;
    }
}

