/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.command;

import com.baselet.control.HandlerElementMap;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.enums.Direction;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.sticking.StickableMap;
import com.baselet.gui.command.Command;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Move
extends Command {
    private static final Logger log = LoggerFactory.getLogger(Move.class);
    private final GridElement entity;
    private final int x;
    private final int y;
    private final double mouseX;
    private final double mouseY;
    private final boolean isShiftKeyDown;
    private final boolean firstDrag;
    private final boolean useSetLocation;
    private final StickableMap stickables;
    private final Collection<Direction> resizeDirection;

    public GridElement getEntity() {
        return this.entity;
    }

    private int getX() {
        int zoomedX = this.x * this.gridSize();
        log.debug("Zoomed x: " + zoomedX);
        return zoomedX;
    }

    private int gridSize() {
        return HandlerElementMap.getHandlerForElement(this.entity).getGridSize();
    }

    private int getY() {
        int zoomedY = this.y * this.gridSize();
        log.debug("Zoomed y: " + zoomedY);
        return zoomedY;
    }

    public StickableMap getStickables() {
        return this.stickables;
    }

    public boolean isShiftKeyDown() {
        return this.isShiftKeyDown;
    }

    private Point getMousePosBeforeDrag() {
        Double zoomedX = this.mouseX * (double)this.gridSize();
        Double zoomedY = this.mouseY * (double)this.gridSize();
        Point p = new Point((int)Math.round(zoomedX), (int)Math.round(zoomedY));
        log.debug("Zoomed point: " + p);
        return p;
    }

    public Move(Collection<Direction> resizeDirection, boolean absoluteMousePos, GridElement e, int x, int y, Point mousePosBeforeDrag, boolean isShiftKeyDown, boolean firstDrag, boolean useSetLocation, StickableMap stickingStickables) {
        this.entity = e;
        int gridSize = HandlerElementMap.getHandlerForElement(e).getGridSize();
        this.x = x / gridSize;
        this.y = y / gridSize;
        this.mouseX = this.calcRelativePos(absoluteMousePos, mousePosBeforeDrag.getX(), this.entity.getRectangle().getX(), gridSize);
        this.mouseY = this.calcRelativePos(absoluteMousePos, mousePosBeforeDrag.getY(), this.entity.getRectangle().getY(), gridSize);
        this.isShiftKeyDown = isShiftKeyDown;
        this.firstDrag = firstDrag;
        this.useSetLocation = useSetLocation;
        this.stickables = stickingStickables;
        this.resizeDirection = resizeDirection;
    }

    public Move(Collection<Direction> resizeDirection, GridElement e, int x, int y, Point mousePosBeforeDrag, boolean isShiftKeyDown, boolean firstDrag, boolean useSetLocation, StickableMap stickingStickables) {
        this(resizeDirection, true, e, x, y, mousePosBeforeDrag, isShiftKeyDown, firstDrag, useSetLocation, stickingStickables);
    }

    private double calcRelativePos(boolean absoluteMousePos, int mousePos, int entityLocation, double gridSize) {
        double xCalcBase = (double)mousePos * 1.0;
        if (absoluteMousePos) {
            xCalcBase -= (double)entityLocation;
        }
        return xCalcBase / gridSize;
    }

    @Override
    public void execute(DiagramHandler handler) {
        super.execute(handler);
        if (this.useSetLocation) {
            this.entity.setRectangleDifference(this.getX(), this.getY(), 0, 0, this.firstDrag, this.stickables, true);
        } else {
            this.entity.drag(this.resizeDirection, this.getX(), this.getY(), this.getMousePosBeforeDrag(), this.isShiftKeyDown, this.firstDrag, this.stickables, true);
        }
    }

    @Override
    public void undo(DiagramHandler handler) {
        super.undo(handler);
        this.entity.undoDrag();
        this.entity.updateModelFromText();
        CurrentDiagram.getInstance().getDiagramHandler().getDrawPanel().updatePanelAndScrollbars();
    }

    @Override
    public void redo(DiagramHandler handler) {
        this.entity.redoDrag();
        this.entity.updateModelFromText();
        CurrentDiagram.getInstance().getDiagramHandler().getDrawPanel().updatePanelAndScrollbars();
    }

    @Override
    public boolean isMergeableTo(Command c) {
        if (!(c instanceof Move)) {
            return false;
        }
        Move m = (Move)c;
        boolean stickablesEquals = this.stickables.equalsMap(m.stickables);
        boolean shiftEquals = this.isShiftKeyDown == m.isShiftKeyDown;
        boolean notBothFirstDrag = !this.firstDrag || !m.firstDrag;
        return this.entity == m.entity && this.useSetLocation == m.useSetLocation && stickablesEquals && shiftEquals && notBothFirstDrag;
    }

    @Override
    public Command mergeTo(Command c) {
        Move m = (Move)c;
        Point mousePosBeforeDrag = this.firstDrag ? this.getMousePosBeforeDrag() : m.getMousePosBeforeDrag();
        Move ret = new Move(m.resizeDirection, false, this.entity, this.getX() + m.getX(), this.getY() + m.getY(), mousePosBeforeDrag, this.isShiftKeyDown, this.firstDrag || m.firstDrag, this.useSetLocation, this.stickables);
        this.entity.mergeUndoDrag();
        return ret;
    }
}

