/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.Sort;
import org.apache.lucene.util.Bits;

public final class SlowCodecReaderWrapper {
    private SlowCodecReaderWrapper() {
    }

    public static CodecReader wrap(final LeafReader reader) throws IOException {
        if (reader instanceof CodecReader) {
            return (CodecReader)reader;
        }
        reader.checkIntegrity();
        return new CodecReader(){

            @Override
            public TermVectorsReader getTermVectorsReader() {
                reader.ensureOpen();
                return SlowCodecReaderWrapper.readerToTermVectorsReader(reader);
            }

            @Override
            public StoredFieldsReader getFieldsReader() {
                reader.ensureOpen();
                return SlowCodecReaderWrapper.readerToStoredFieldsReader(reader);
            }

            @Override
            public NormsProducer getNormsReader() {
                reader.ensureOpen();
                return SlowCodecReaderWrapper.readerToNormsProducer(reader);
            }

            @Override
            public DocValuesProducer getDocValuesReader() {
                reader.ensureOpen();
                return SlowCodecReaderWrapper.readerToDocValuesProducer(reader);
            }

            @Override
            public FieldsProducer getPostingsReader() {
                reader.ensureOpen();
                try {
                    return SlowCodecReaderWrapper.readerToFieldsProducer(reader);
                }
                catch (IOException bogus) {
                    throw new AssertionError((Object)bogus);
                }
            }

            @Override
            public FieldInfos getFieldInfos() {
                return reader.getFieldInfos();
            }

            @Override
            public PointValues getPointValues() {
                return reader.getPointValues();
            }

            @Override
            public PointsReader getPointsReader() {
                return SlowCodecReaderWrapper.pointValuesToReader(reader.getPointValues());
            }

            @Override
            public Bits getLiveDocs() {
                return reader.getLiveDocs();
            }

            @Override
            public int numDocs() {
                return reader.numDocs();
            }

            @Override
            public int maxDoc() {
                return reader.maxDoc();
            }

            @Override
            public void addCoreClosedListener(LeafReader.CoreClosedListener listener) {
                reader.addCoreClosedListener(listener);
            }

            @Override
            public void removeCoreClosedListener(LeafReader.CoreClosedListener listener) {
                reader.removeCoreClosedListener(listener);
            }

            public String toString() {
                return "SlowCodecReaderWrapper(" + reader + ")";
            }

            @Override
            public Sort getIndexSort() {
                return reader.getIndexSort();
            }
        };
    }

    private static PointsReader pointValuesToReader(final PointValues values) {
        if (values == null) {
            return null;
        }
        return new PointsReader(){

            @Override
            public void intersect(String fieldName, PointValues.IntersectVisitor visitor) throws IOException {
                values.intersect(fieldName, visitor);
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public byte[] getMinPackedValue(String fieldName) throws IOException {
                return values.getMinPackedValue(fieldName);
            }

            @Override
            public byte[] getMaxPackedValue(String fieldName) throws IOException {
                return values.getMaxPackedValue(fieldName);
            }

            @Override
            public int getNumDimensions(String fieldName) throws IOException {
                return values.getNumDimensions(fieldName);
            }

            @Override
            public int getBytesPerDimension(String fieldName) throws IOException {
                return values.getBytesPerDimension(fieldName);
            }

            @Override
            public long size(String fieldName) {
                return values.size(fieldName);
            }

            @Override
            public int getDocCount(String fieldName) {
                return values.getDocCount(fieldName);
            }
        };
    }

    private static NormsProducer readerToNormsProducer(final LeafReader reader) {
        return new NormsProducer(){

            @Override
            public NumericDocValues getNorms(FieldInfo field) throws IOException {
                return reader.getNormValues(field.name);
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }
        };
    }

    private static DocValuesProducer readerToDocValuesProducer(final LeafReader reader) {
        return new DocValuesProducer(){

            @Override
            public NumericDocValues getNumeric(FieldInfo field) throws IOException {
                return reader.getNumericDocValues(field.name);
            }

            @Override
            public BinaryDocValues getBinary(FieldInfo field) throws IOException {
                return reader.getBinaryDocValues(field.name);
            }

            @Override
            public SortedDocValues getSorted(FieldInfo field) throws IOException {
                return reader.getSortedDocValues(field.name);
            }

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                return reader.getSortedNumericDocValues(field.name);
            }

            @Override
            public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
                return reader.getSortedSetDocValues(field.name);
            }

            @Override
            public Bits getDocsWithField(FieldInfo field) throws IOException {
                return reader.getDocsWithField(field.name);
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }
        };
    }

    private static StoredFieldsReader readerToStoredFieldsReader(final LeafReader reader) {
        return new StoredFieldsReader(){

            @Override
            public void visitDocument(int docID, StoredFieldVisitor visitor) throws IOException {
                reader.document(docID, visitor);
            }

            @Override
            public StoredFieldsReader clone() {
                return SlowCodecReaderWrapper.readerToStoredFieldsReader(reader);
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }
        };
    }

    private static TermVectorsReader readerToTermVectorsReader(final LeafReader reader) {
        return new TermVectorsReader(){

            @Override
            public Fields get(int docID) throws IOException {
                return reader.getTermVectors(docID);
            }

            @Override
            public TermVectorsReader clone() {
                return SlowCodecReaderWrapper.readerToTermVectorsReader(reader);
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }
        };
    }

    private static FieldsProducer readerToFieldsProducer(LeafReader reader) throws IOException {
        final Fields fields = reader.fields();
        return new FieldsProducer(){

            @Override
            public Iterator<String> iterator() {
                return fields.iterator();
            }

            @Override
            public Terms terms(String field) throws IOException {
                return fields.terms(field);
            }

            @Override
            public int size() {
                return fields.size();
            }

            @Override
            public void checkIntegrity() throws IOException {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }
        };
    }
}

