/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.node;

import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.support.AbstractClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskListener;
import org.elasticsearch.threadpool.ThreadPool;

public class NodeClient
extends AbstractClient {
    private Map<GenericAction, TransportAction> actions;

    public NodeClient(Settings settings, ThreadPool threadPool) {
        super(settings, threadPool);
    }

    public void intialize(Map<GenericAction, TransportAction> actions) {
        this.actions = actions;
    }

    @Override
    public void close() {
    }

    @Override
    public <Request extends ActionRequest<Request>, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void doExecute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        this.executeLocally(action, request, listener);
    }

    public <Request extends ActionRequest<Request>, Response extends ActionResponse> Task executeLocally(GenericAction<Request, Response> action, Request request, ActionListener<Response> listener) {
        return this.transportAction(action).execute(request, listener);
    }

    public <Request extends ActionRequest<Request>, Response extends ActionResponse> Task executeLocally(GenericAction<Request, Response> action, Request request, TaskListener<Response> listener) {
        return this.transportAction(action).execute(request, listener);
    }

    private <Request extends ActionRequest<Request>, Response extends ActionResponse> TransportAction<Request, Response> transportAction(GenericAction<Request, Response> action) {
        if (this.actions == null) {
            throw new IllegalStateException("NodeClient has not been initialized");
        }
        TransportAction transportAction = this.actions.get(action);
        if (transportAction == null) {
            throw new IllegalStateException("failed to find action [" + action + "] to execute");
        }
        return transportAction;
    }
}

