/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;

public class IdsQueryBuilder
extends AbstractQueryBuilder<IdsQueryBuilder> {
    public static final String NAME = "ids";
    private static final ParseField TYPE_FIELD = new ParseField("type", "types", "_type");
    private static final ParseField VALUES_FIELD = new ParseField("values", new String[0]);
    private final Set<String> ids = new HashSet<String>();
    private final String[] types;

    public IdsQueryBuilder() {
        this.types = new String[0];
    }

    public IdsQueryBuilder(String ... types) {
        if (types == null) {
            throw new IllegalArgumentException("[ids] types cannot be null");
        }
        this.types = types;
    }

    public IdsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.types = in.readStringArray();
        Collections.addAll(this.ids, in.readStringArray());
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.types);
        out.writeStringArray(this.ids.toArray(new String[this.ids.size()]));
    }

    public String[] types() {
        return this.types;
    }

    public IdsQueryBuilder addIds(String ... ids) {
        if (ids == null) {
            throw new IllegalArgumentException("[ids] ids cannot be null");
        }
        Collections.addAll(this.ids, ids);
        return this;
    }

    public Set<String> ids() {
        return this.ids;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.array(TYPE_FIELD.getPreferredName(), this.types);
        builder.startArray(VALUES_FIELD.getPreferredName());
        for (String value : this.ids) {
            builder.value(value);
        }
        builder.endArray();
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<IdsQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        ArrayList<String> ids = new ArrayList<String>();
        List<Object> types = new ArrayList();
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        boolean idsProvided = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (parseContext.getParseFieldMatcher().match(currentFieldName, VALUES_FIELD)) {
                    idsProvided = true;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING || token == XContentParser.Token.VALUE_NUMBER) {
                            String id = parser.textOrNull();
                            if (id == null) {
                                throw new ParsingException(parser.getTokenLocation(), "No value specified for term filter", new Object[0]);
                            }
                            ids.add(id);
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "Illegal value for id, expecting a string or number, got: " + (Object)((Object)token), new Object[0]);
                    }
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, TYPE_FIELD)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String value = parser.textOrNull();
                        if (value == null) {
                            throw new ParsingException(parser.getTokenLocation(), "No type specified for term filter", new Object[0]);
                        }
                        types.add(value);
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[ids] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (parseContext.getParseFieldMatcher().match(currentFieldName, TYPE_FIELD)) {
                    types = Collections.singletonList(parser.text());
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.BOOST_FIELD)) {
                    boost = parser.floatValue();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.NAME_FIELD)) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[ids] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[ids] unknown token [" + (Object)((Object)token) + "] after [" + currentFieldName + "]", new Object[0]);
        }
        if (!idsProvided) {
            throw new ParsingException(parser.getTokenLocation(), "[ids] query, no ids values provided", new Object[0]);
        }
        IdsQueryBuilder query = new IdsQueryBuilder(types.toArray(new String[types.size()]));
        query.addIds(ids.toArray(new String[ids.size()]));
        ((IdsQueryBuilder)query.boost(boost)).queryName(queryName);
        return Optional.of(query);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query query;
        if (this.ids.isEmpty()) {
            query = Queries.newMatchNoDocsQuery("Missing ids in \"" + this.getName() + "\" query.");
        } else {
            Collection<String> typesForQuery;
            if (this.types.length == 0) {
                typesForQuery = context.queryTypes();
            } else if (this.types.length == 1 && "_all".equals(this.types[0])) {
                typesForQuery = context.getMapperService().types();
            } else {
                typesForQuery = new HashSet<String>();
                Collections.addAll(typesForQuery, this.types);
            }
            query = new TermsQuery("_uid", Uid.createUidsForTypesAndIds(typesForQuery, this.ids));
        }
        return query;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.ids, Arrays.hashCode(this.types));
    }

    @Override
    protected boolean doEquals(IdsQueryBuilder other) {
        return Objects.equals(this.ids, other.ids) && Arrays.equals(this.types, other.types);
    }
}

