/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.percentiles.AbstractPercentilesParser;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesMethod;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesParser;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.HDRPercentilesAggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestPercentilesAggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class PercentilesAggregationBuilder
extends ValuesSourceAggregationBuilder.LeafOnly<ValuesSource.Numeric, PercentilesAggregationBuilder> {
    public static final String NAME = "percentiles";
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("percentiles");
    private double[] percents = PercentilesParser.DEFAULT_PERCENTS;
    private PercentilesMethod method = PercentilesMethod.TDIGEST;
    private int numberOfSignificantValueDigits = 3;
    private double compression = 100.0;
    private boolean keyed = true;

    public PercentilesAggregationBuilder(String name) {
        super(name, TYPE, ValuesSourceType.NUMERIC, ValueType.NUMERIC);
    }

    public PercentilesAggregationBuilder(StreamInput in) throws IOException {
        super(in, TYPE, ValuesSourceType.NUMERIC, ValueType.NUMERIC);
        this.percents = in.readDoubleArray();
        this.keyed = in.readBoolean();
        this.numberOfSignificantValueDigits = in.readVInt();
        this.compression = in.readDouble();
        this.method = PercentilesMethod.readFromStream(in);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDoubleArray(this.percents);
        out.writeBoolean(this.keyed);
        out.writeVInt(this.numberOfSignificantValueDigits);
        out.writeDouble(this.compression);
        this.method.writeTo(out);
    }

    public PercentilesAggregationBuilder percentiles(double ... percents) {
        if (percents == null) {
            throw new IllegalArgumentException("[percents] must not be null: [" + this.name + "]");
        }
        double[] sortedPercents = Arrays.copyOf(percents, percents.length);
        Arrays.sort(sortedPercents);
        this.percents = sortedPercents;
        return this;
    }

    public double[] percentiles() {
        return this.percents;
    }

    public PercentilesAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    public PercentilesAggregationBuilder numberOfSignificantValueDigits(int numberOfSignificantValueDigits) {
        if (numberOfSignificantValueDigits < 0 || numberOfSignificantValueDigits > 5) {
            throw new IllegalArgumentException("[numberOfSignificantValueDigits] must be between 0 and 5: [" + this.name + "]");
        }
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        return this;
    }

    public int numberOfSignificantValueDigits() {
        return this.numberOfSignificantValueDigits;
    }

    public PercentilesAggregationBuilder compression(double compression) {
        if (compression < 0.0) {
            throw new IllegalArgumentException("[compression] must be greater than or equal to 0. Found [" + compression + "] in [" + this.name + "]");
        }
        this.compression = compression;
        return this;
    }

    public double compression() {
        return this.compression;
    }

    public PercentilesAggregationBuilder method(PercentilesMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("[method] must not be null: [" + this.name + "]");
        }
        this.method = method;
        return this;
    }

    public PercentilesMethod method() {
        return this.method;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.Numeric, ?> innerBuild(AggregationContext context, ValuesSourceConfig<ValuesSource.Numeric> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        switch (this.method) {
            case TDIGEST: {
                return new TDigestPercentilesAggregatorFactory(this.name, this.type, config, this.percents, this.compression, this.keyed, context, parent, subFactoriesBuilder, this.metaData);
            }
            case HDR: {
                return new HDRPercentilesAggregatorFactory(this.name, this.type, config, this.percents, this.numberOfSignificantValueDigits, this.keyed, context, parent, subFactoriesBuilder, this.metaData);
            }
        }
        throw new IllegalStateException("Illegal method [" + this.method.getName() + "]");
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.array(PercentilesParser.PERCENTS_FIELD.getPreferredName(), this.percents);
        builder.field(AbstractPercentilesParser.KEYED_FIELD.getPreferredName(), this.keyed);
        builder.startObject(this.method.getName());
        if (this.method == PercentilesMethod.TDIGEST) {
            builder.field(AbstractPercentilesParser.COMPRESSION_FIELD.getPreferredName(), this.compression);
        } else {
            builder.field(AbstractPercentilesParser.NUMBER_SIGNIFICANT_DIGITS_FIELD.getPreferredName(), this.numberOfSignificantValueDigits);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected boolean innerEquals(Object obj) {
        PercentilesAggregationBuilder other = (PercentilesAggregationBuilder)obj;
        if (!Objects.equals(this.method, other.method)) {
            return false;
        }
        boolean equalSettings = false;
        switch (this.method) {
            case HDR: {
                equalSettings = Objects.equals(this.numberOfSignificantValueDigits, other.numberOfSignificantValueDigits);
                break;
            }
            case TDIGEST: {
                equalSettings = Objects.equals(this.compression, other.compression);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal method [" + this.method.getName() + "]");
            }
        }
        return equalSettings && Objects.deepEquals(this.percents, other.percents) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.method, other.method);
    }

    @Override
    protected int innerHashCode() {
        switch (this.method) {
            case HDR: {
                return Objects.hash(Arrays.hashCode(this.percents), this.keyed, this.numberOfSignificantValueDigits, this.method);
            }
            case TDIGEST: {
                return Objects.hash(Arrays.hashCode(this.percents), this.keyed, this.compression, this.method);
            }
        }
        throw new IllegalStateException("Illegal method [" + this.method.getName() + "]");
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

