/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Random;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.NatCubic;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.TextOutlineRenderer;

public class TextWithWaterLevel
extends TextOutlineRenderer {
    private Color waterColor;
    private Color bgColor;
    private int percentageOfWater;
    private Random sea = new Random();
    private Polygon cachedPolygon;

    public TextWithWaterLevel(String s, Font f) {
        super(f, s);
        this.waterColor = Color.BLUE;
        this.bgColor = Color.white;
    }

    protected Point getFutureSize() {
        BufferedImage bi = new BufferedImage(10, 10, 2);
        FontMetrics fm = bi.createGraphics().getFontMetrics(this.getFont());
        int w = fm.stringWidth(this.getText());
        int h = fm.getHeight();
        return new Point(w, h);
    }

    public BufferedImage getBackground() {
        Point p = this.getFutureSize();
        int w = p.x;
        int h = p.y;
        if (w <= 0 || h <= 0) {
            return null;
        }
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.bgColor);
        g2d.fillRect(0, 0, w, h);
        if (this.cachedPolygon == null) {
            int level = h * this.percentageOfWater / 100;
            int waveHeight = 10;
            int waveLength = 20;
            if (level > waveHeight / 2 + 1) {
                NatCubic line = new NatCubic();
                for (int x = 0; x < w + 2 * waveLength; x += waveLength) {
                    line.addPoint(x, h - level - waveHeight / 2 - this.sea.nextInt(waveHeight));
                }
                this.cachedPolygon = line.calcualteResult();
                this.cachedPolygon.addPoint(w, h);
                this.cachedPolygon.addPoint(0, h);
            }
        }
        g2d.setColor(this.waterColor);
        if (this.cachedPolygon != null) {
            g2d.fillPolygon(this.cachedPolygon);
        }
        return bi;
    }

    public Polygon getCachedPolygon() {
        return this.cachedPolygon;
    }

    public void setCachedPolygon(Polygon cachedPolygon) {
        this.cachedPolygon = cachedPolygon;
    }

    @Override
    public void cutTo(Graphics2D g2, int x, int y) {
        if (this.getImg() == null) {
            this.setImg(this.getBackground());
        }
        if (this.getImg() == null) {
            return;
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(this.getFont());
        g2.setColor(this.getTextOutline());
        g2.drawString(this.getText(), x, y - 2);
        g2.drawString(this.getText(), x, y + 2);
        g2.drawString(this.getText(), x - 2, y);
        g2.drawString(this.getText(), x + 2, y);
        super.cutTo(g2, x, y);
    }

    public Color getWaterColor() {
        return this.waterColor;
    }

    public void setWaterColor(Color waterColor) {
        this.waterColor = waterColor;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public int getPercentageOfWater() {
        return this.percentageOfWater;
    }

    public void setPercentageOfWater(int percentageOfWater) {
        this.percentageOfWater = percentageOfWater;
    }
}

