/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.http.HttpServerAdapter;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpStats;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class HttpServer
extends AbstractLifecycleComponent
implements HttpServerAdapter {
    private final HttpServerTransport transport;
    private final RestController restController;
    private final NodeClient client;
    private final CircuitBreakerService circuitBreakerService;

    @Inject
    public HttpServer(Settings settings, HttpServerTransport transport, RestController restController, NodeClient client, CircuitBreakerService circuitBreakerService) {
        super(settings);
        this.transport = transport;
        this.restController = restController;
        this.client = client;
        this.circuitBreakerService = circuitBreakerService;
        transport.httpServerAdapter(this);
    }

    @Override
    protected void doStart() {
        this.transport.start();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{}", (Object)this.transport.boundAddress());
        }
    }

    @Override
    protected void doStop() {
        this.transport.stop();
    }

    @Override
    protected void doClose() {
        this.transport.close();
    }

    public HttpInfo info() {
        return this.transport.info();
    }

    public HttpStats stats() {
        return this.transport.stats();
    }

    @Override
    public void dispatchRequest(RestRequest request, RestChannel channel, ThreadContext threadContext) {
        if (request.rawPath().equals("/favicon.ico")) {
            this.handleFavicon(request, channel);
            return;
        }
        RestChannel responseChannel = channel;
        try {
            int contentLength = request.content().length();
            if (this.restController.canTripCircuitBreaker(request)) {
                HttpServer.inFlightRequestsBreaker(this.circuitBreakerService).addEstimateBytesAndMaybeBreak(contentLength, "<http_request>");
            } else {
                HttpServer.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking(contentLength);
            }
            responseChannel = new ResourceHandlingHttpChannel(channel, this.circuitBreakerService, contentLength);
            this.restController.dispatchRequest(request, responseChannel, this.client, threadContext);
        }
        catch (Exception e) {
            this.restController.sendErrorResponse(request, responseChannel, e);
        }
    }

    void handleFavicon(RestRequest request, RestChannel channel) {
        if (request.method() == RestRequest.Method.GET) {
            try (InputStream stream = this.getClass().getResourceAsStream("/config/favicon.ico");){
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Streams.copy(stream, (OutputStream)out);
                BytesRestResponse restResponse = new BytesRestResponse(RestStatus.OK, "image/x-icon", out.toByteArray());
                channel.sendResponse(restResponse);
            }
            catch (IOException e) {
                channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", BytesArray.EMPTY));
            }
        } else {
            channel.sendResponse(new BytesRestResponse(RestStatus.FORBIDDEN, "text/plain; charset=UTF-8", BytesArray.EMPTY));
        }
    }

    private static CircuitBreaker inFlightRequestsBreaker(CircuitBreakerService circuitBreakerService) {
        return circuitBreakerService.getBreaker("in_flight_requests");
    }

    private static final class ResourceHandlingHttpChannel
    implements RestChannel {
        private final RestChannel delegate;
        private final CircuitBreakerService circuitBreakerService;
        private final int contentLength;
        private final AtomicBoolean closed = new AtomicBoolean();

        public ResourceHandlingHttpChannel(RestChannel delegate, CircuitBreakerService circuitBreakerService, int contentLength) {
            this.delegate = delegate;
            this.circuitBreakerService = circuitBreakerService;
            this.contentLength = contentLength;
        }

        @Override
        public XContentBuilder newBuilder() throws IOException {
            return this.delegate.newBuilder();
        }

        @Override
        public XContentBuilder newErrorBuilder() throws IOException {
            return this.delegate.newErrorBuilder();
        }

        @Override
        public XContentBuilder newBuilder(@Nullable BytesReference autoDetectSource, boolean useFiltering) throws IOException {
            return this.delegate.newBuilder(autoDetectSource, useFiltering);
        }

        @Override
        public BytesStreamOutput bytesOutput() {
            return this.delegate.bytesOutput();
        }

        @Override
        public RestRequest request() {
            return this.delegate.request();
        }

        @Override
        public boolean detailedErrorsEnabled() {
            return this.delegate.detailedErrorsEnabled();
        }

        @Override
        public void sendResponse(RestResponse response) {
            this.close();
            this.delegate.sendResponse(response);
        }

        private void close() {
            if (!this.closed.compareAndSet(false, true)) {
                throw new IllegalStateException("Channel is already closed");
            }
            HttpServer.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking(-this.contentLength);
        }
    }
}

