/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;

public class SearchShardTarget
implements Writeable,
Comparable<SearchShardTarget> {
    private Text nodeId;
    private Text index;
    private ShardId shardId;

    public SearchShardTarget(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.nodeId = in.readText();
        }
        this.shardId = ShardId.readShardId(in);
        this.index = new Text(this.shardId.getIndexName());
    }

    public SearchShardTarget(String nodeId, ShardId shardId) {
        this.nodeId = nodeId == null ? null : new Text(nodeId);
        this.index = new Text(shardId.getIndexName());
        this.shardId = shardId;
    }

    public SearchShardTarget(String nodeId, Index index, int shardId) {
        this(nodeId, new ShardId(index, shardId));
    }

    @Nullable
    public String nodeId() {
        return this.nodeId.string();
    }

    @Nullable
    public String getNodeId() {
        return this.nodeId();
    }

    public Text nodeIdText() {
        return this.nodeId;
    }

    public String index() {
        return this.index.string();
    }

    public String getIndex() {
        return this.index();
    }

    public Text indexText() {
        return this.index;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    @Override
    public int compareTo(SearchShardTarget o) {
        int i = this.index.string().compareTo(o.index());
        if (i == 0) {
            i = this.shardId.getId() - o.shardId.id();
        }
        return i;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.nodeId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeText(this.nodeId);
        }
        this.shardId.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardTarget that = (SearchShardTarget)o;
        if (!this.shardId.equals(that.shardId)) {
            return false;
        }
        return !(this.nodeId != null ? !this.nodeId.equals(that.nodeId) : that.nodeId != null);
    }

    public int hashCode() {
        int result = this.nodeId != null ? this.nodeId.hashCode() : 0;
        result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
        result = 31 * result + this.shardId.hashCode();
        return result;
    }

    public String toString() {
        if (this.nodeId == null) {
            return "[_na_]" + this.shardId;
        }
        return "[" + this.nodeId + "]" + this.shardId;
    }
}

