/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.jaspell;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

@Deprecated
public class JaspellTernarySearchTrie
implements Accountable {
    private int defaultNumReturnValues = -1;
    private int matchAlmostDiff;
    private TSTNode rootNode;
    private final Locale locale;

    private static int compareCharsAlphabetically(char cCompare2, char cRef) {
        return Character.toLowerCase(cCompare2) - Character.toLowerCase(cRef);
    }

    public JaspellTernarySearchTrie() {
        this(Locale.ROOT);
    }

    public JaspellTernarySearchTrie(Locale locale) {
        this.locale = locale;
    }

    void setRoot(TSTNode newRoot) {
        this.rootNode = newRoot;
    }

    TSTNode getRoot() {
        return this.rootNode;
    }

    public JaspellTernarySearchTrie(Path file) throws IOException {
        this(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaspellTernarySearchTrie(Path file, boolean compression) throws IOException {
        this();
        BufferedReader in = compression ? new BufferedReader(IOUtils.getDecodingReader((InputStream)new GZIPInputStream(Files.newInputStream(file, new OpenOption[0])), (Charset)StandardCharsets.UTF_8)) : Files.newBufferedReader(file, StandardCharsets.UTF_8);
        try {
            String word;
            Float one = new Float(1.0f);
            while ((word = in.readLine()) != null) {
                int pos = word.indexOf("\t");
                Float occur = one;
                if (pos != -1) {
                    occur = Float.valueOf(Float.parseFloat(word.substring(pos + 1).trim()));
                    word = word.substring(0, pos);
                }
                String key = word.toLowerCase(this.locale);
                if (this.rootNode == null) {
                    this.rootNode = new TSTNode(key.charAt(0), null);
                }
                TSTNode node = null;
                if (key.length() <= 0 || this.rootNode == null) continue;
                TSTNode currentNode = this.rootNode;
                int charIndex = 0;
                while (currentNode != null) {
                    int charComp = JaspellTernarySearchTrie.compareCharsAlphabetically(key.charAt(charIndex), currentNode.splitchar);
                    if (charComp == 0) {
                        if (++charIndex == key.length()) {
                            node = currentNode;
                            break;
                        }
                        currentNode = currentNode.relatives[2];
                        continue;
                    }
                    if (charComp < 0) {
                        currentNode = currentNode.relatives[1];
                        continue;
                    }
                    currentNode = currentNode.relatives[3];
                }
                Float occur2 = null;
                if (node != null) {
                    occur2 = (Float)node.data;
                }
                if (occur2 != null) {
                    occur = Float.valueOf(occur.floatValue() + occur2.floatValue());
                }
                currentNode = this.getOrCreateNode(word.trim().toLowerCase(this.locale));
                currentNode.data = occur;
            }
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{in});
    }

    private void deleteNode(TSTNode nodeToDelete) {
        if (nodeToDelete == null) {
            return;
        }
        nodeToDelete.data = null;
        while (nodeToDelete != null) {
            nodeToDelete = this.deleteNodeRecursion(nodeToDelete);
        }
    }

    private TSTNode deleteNodeRecursion(TSTNode currentNode) {
        TSTNode targetNode;
        int movingKid;
        int childType;
        boolean hikidNull;
        if (currentNode == null) {
            return null;
        }
        if (currentNode.relatives[2] != null || currentNode.data != null) {
            return null;
        }
        TSTNode currentParent = currentNode.relatives[0];
        boolean lokidNull = currentNode.relatives[1] == null;
        boolean bl = hikidNull = currentNode.relatives[3] == null;
        if (currentParent.relatives[1] == currentNode) {
            childType = 1;
        } else if (currentParent.relatives[2] == currentNode) {
            childType = 2;
        } else if (currentParent.relatives[3] == currentNode) {
            childType = 3;
        } else {
            this.rootNode = null;
            return null;
        }
        if (lokidNull && hikidNull) {
            currentParent.relatives[childType] = null;
            return currentParent;
        }
        if (lokidNull) {
            currentParent.relatives[childType] = currentNode.relatives[3];
            currentNode.relatives[3].relatives[0] = currentParent;
            return currentParent;
        }
        if (hikidNull) {
            currentParent.relatives[childType] = currentNode.relatives[1];
            currentNode.relatives[1].relatives[0] = currentParent;
            return currentParent;
        }
        int deltaHi = currentNode.relatives[3].splitchar - currentNode.splitchar;
        int deltaLo = currentNode.splitchar - currentNode.relatives[1].splitchar;
        if (deltaHi == deltaLo) {
            if (Math.random() < 0.5) {
                ++deltaHi;
            } else {
                ++deltaLo;
            }
        }
        if (deltaHi > deltaLo) {
            movingKid = 3;
            targetNode = currentNode.relatives[1];
        } else {
            movingKid = 1;
            targetNode = currentNode.relatives[3];
        }
        while (targetNode.relatives[movingKid] != null) {
            targetNode = targetNode.relatives[movingKid];
        }
        targetNode.relatives[movingKid] = currentNode.relatives[movingKid];
        currentParent.relatives[childType] = targetNode;
        targetNode.relatives[0] = currentParent;
        if (!lokidNull) {
            currentNode.relatives[1] = null;
        }
        if (!hikidNull) {
            currentNode.relatives[3] = null;
        }
        return currentParent;
    }

    public Object get(CharSequence key) {
        TSTNode node = this.getNode(key);
        if (node == null) {
            return null;
        }
        return node.data;
    }

    public Float getAndIncrement(String key) {
        String key2 = key.trim().toLowerCase(this.locale);
        TSTNode node = this.getNode(key2);
        if (node == null) {
            return null;
        }
        Float aux = (Float)node.data;
        aux = aux == null ? new Float(1.0f) : new Float(aux.intValue() + 1);
        this.put(key2, aux);
        return aux;
    }

    protected String getKey(TSTNode node) {
        StringBuilder getKeyBuffer = new StringBuilder();
        getKeyBuffer.setLength(0);
        getKeyBuffer.append("" + node.splitchar);
        TSTNode currentNode = node.relatives[0];
        TSTNode lastNode = node;
        while (currentNode != null) {
            if (currentNode.relatives[2] == lastNode) {
                getKeyBuffer.append("" + currentNode.splitchar);
            }
            lastNode = currentNode;
            currentNode = currentNode.relatives[0];
        }
        getKeyBuffer.reverse();
        return getKeyBuffer.toString();
    }

    public TSTNode getNode(CharSequence key) {
        return this.getNode(key, this.rootNode);
    }

    protected TSTNode getNode(CharSequence key, TSTNode startNode) {
        if (key == null || startNode == null || key.length() == 0) {
            return null;
        }
        TSTNode currentNode = startNode;
        int charIndex = 0;
        while (currentNode != null) {
            int charComp = JaspellTernarySearchTrie.compareCharsAlphabetically(key.charAt(charIndex), currentNode.splitchar);
            if (charComp == 0) {
                if (++charIndex == key.length()) {
                    return currentNode;
                }
                currentNode = currentNode.relatives[2];
                continue;
            }
            if (charComp < 0) {
                currentNode = currentNode.relatives[1];
                continue;
            }
            currentNode = currentNode.relatives[3];
        }
        return null;
    }

    protected TSTNode getOrCreateNode(CharSequence key) throws NullPointerException, IllegalArgumentException {
        if (key == null) {
            throw new NullPointerException("attempt to get or create node with null key");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("attempt to get or create node with key of zero length");
        }
        if (this.rootNode == null) {
            this.rootNode = new TSTNode(key.charAt(0), null);
        }
        TSTNode currentNode = this.rootNode;
        int charIndex = 0;
        while (true) {
            int charComp;
            if ((charComp = JaspellTernarySearchTrie.compareCharsAlphabetically(key.charAt(charIndex), currentNode.splitchar)) == 0) {
                if (++charIndex == key.length()) {
                    return currentNode;
                }
                if (currentNode.relatives[2] == null) {
                    currentNode.relatives[2] = new TSTNode(key.charAt(charIndex), currentNode);
                }
                currentNode = currentNode.relatives[2];
                continue;
            }
            if (charComp < 0) {
                if (currentNode.relatives[1] == null) {
                    currentNode.relatives[1] = new TSTNode(key.charAt(charIndex), currentNode);
                }
                currentNode = currentNode.relatives[1];
                continue;
            }
            if (currentNode.relatives[3] == null) {
                currentNode.relatives[3] = new TSTNode(key.charAt(charIndex), currentNode);
            }
            currentNode = currentNode.relatives[3];
        }
    }

    public List<String> matchAlmost(String key) {
        return this.matchAlmost(key, this.defaultNumReturnValues);
    }

    public List<String> matchAlmost(CharSequence key, int numReturnValues) {
        return this.matchAlmostRecursion(this.rootNode, 0, this.matchAlmostDiff, key, numReturnValues < 0 ? -1 : numReturnValues, new Vector<String>(), false);
    }

    private List<String> matchAlmostRecursion(TSTNode currentNode, int charIndex, int d, CharSequence matchAlmostKey, int matchAlmostNumReturnValues, List<String> matchAlmostResult2, boolean upTo) {
        boolean cond;
        int nextD;
        if (currentNode == null || matchAlmostNumReturnValues != -1 && matchAlmostResult2.size() >= matchAlmostNumReturnValues || d < 0 || charIndex >= matchAlmostKey.length()) {
            return matchAlmostResult2;
        }
        int charComp = JaspellTernarySearchTrie.compareCharsAlphabetically(matchAlmostKey.charAt(charIndex), currentNode.splitchar);
        List<String> matchAlmostResult = matchAlmostResult2;
        if (d > 0 || charComp < 0) {
            matchAlmostResult = this.matchAlmostRecursion(currentNode.relatives[1], charIndex, d, matchAlmostKey, matchAlmostNumReturnValues, matchAlmostResult, upTo);
        }
        int n = nextD = charComp == 0 ? d : d - 1;
        boolean bl = upTo ? nextD >= 0 : (cond = nextD == 0);
        if (matchAlmostKey.length() == charIndex + 1 && cond && currentNode.data != null) {
            matchAlmostResult.add(this.getKey(currentNode));
        }
        matchAlmostResult = this.matchAlmostRecursion(currentNode.relatives[2], charIndex + 1, nextD, matchAlmostKey, matchAlmostNumReturnValues, matchAlmostResult, upTo);
        if (d > 0 || charComp > 0) {
            matchAlmostResult = this.matchAlmostRecursion(currentNode.relatives[3], charIndex, d, matchAlmostKey, matchAlmostNumReturnValues, matchAlmostResult, upTo);
        }
        return matchAlmostResult;
    }

    public List<String> matchPrefix(String prefix) {
        return this.matchPrefix(prefix, this.defaultNumReturnValues);
    }

    public List<String> matchPrefix(CharSequence prefix, int numReturnValues) {
        Vector<String> sortKeysResult = new Vector<String>();
        TSTNode startNode = this.getNode(prefix);
        if (startNode == null) {
            return sortKeysResult;
        }
        if (startNode.data != null) {
            sortKeysResult.addElement(this.getKey(startNode));
        }
        return this.sortKeysRecursion(startNode.relatives[2], numReturnValues < 0 ? -1 : numReturnValues, sortKeysResult);
    }

    public int numDataNodes() {
        return this.numDataNodes(this.rootNode);
    }

    protected int numDataNodes(TSTNode startingNode) {
        return this.recursiveNodeCalculator(startingNode, true, 0);
    }

    public int numNodes() {
        return this.numNodes(this.rootNode);
    }

    protected int numNodes(TSTNode startingNode) {
        return this.recursiveNodeCalculator(startingNode, false, 0);
    }

    public void put(CharSequence key, Object value) {
        this.getOrCreateNode((CharSequence)key).data = value;
    }

    private int recursiveNodeCalculator(TSTNode currentNode, boolean checkData, int numNodes2) {
        if (currentNode == null) {
            return numNodes2;
        }
        int numNodes = this.recursiveNodeCalculator(currentNode.relatives[1], checkData, numNodes2);
        numNodes = this.recursiveNodeCalculator(currentNode.relatives[2], checkData, numNodes);
        numNodes = this.recursiveNodeCalculator(currentNode.relatives[3], checkData, numNodes);
        if (checkData) {
            if (currentNode.data != null) {
                ++numNodes;
            }
        } else {
            ++numNodes;
        }
        return numNodes;
    }

    public void remove(String key) {
        this.deleteNode(this.getNode(key.trim().toLowerCase(this.locale)));
    }

    public void setMatchAlmostDiff(int diff) {
        this.matchAlmostDiff = diff < 0 ? 0 : (diff > 3 ? 3 : diff);
    }

    public void setNumReturnValues(int num) {
        this.defaultNumReturnValues = num < 0 ? -1 : num;
    }

    protected List<String> sortKeys(TSTNode startNode, int numReturnValues) {
        return this.sortKeysRecursion(startNode, numReturnValues < 0 ? -1 : numReturnValues, new Vector<String>());
    }

    private List<String> sortKeysRecursion(TSTNode currentNode, int sortKeysNumReturnValues, List<String> sortKeysResult2) {
        if (currentNode == null) {
            return sortKeysResult2;
        }
        List<String> sortKeysResult = this.sortKeysRecursion(currentNode.relatives[1], sortKeysNumReturnValues, sortKeysResult2);
        if (sortKeysNumReturnValues != -1 && sortKeysResult.size() >= sortKeysNumReturnValues) {
            return sortKeysResult;
        }
        if (currentNode.data != null) {
            sortKeysResult.add(this.getKey(currentNode));
        }
        sortKeysResult = this.sortKeysRecursion(currentNode.relatives[2], sortKeysNumReturnValues, sortKeysResult);
        return this.sortKeysRecursion(currentNode.relatives[3], sortKeysNumReturnValues, sortKeysResult);
    }

    public long ramBytesUsed() {
        long mem = RamUsageEstimator.shallowSizeOf((Object)this);
        TSTNode root = this.getRoot();
        if (root != null) {
            mem += root.ramBytesUsed();
        }
        return mem;
    }

    protected final class TSTNode
    implements Accountable {
        protected static final int PARENT = 0;
        protected static final int LOKID = 1;
        protected static final int EQKID = 2;
        protected static final int HIKID = 3;
        protected Object data;
        protected final TSTNode[] relatives = new TSTNode[4];
        protected char splitchar;

        protected TSTNode(char splitchar, TSTNode parent) {
            this.splitchar = splitchar;
            this.relatives[0] = parent;
        }

        public long ramBytesUsed() {
            long mem = RamUsageEstimator.shallowSizeOf((Object)this) + RamUsageEstimator.shallowSizeOf((Object[])this.relatives);
            for (int i = 1; i < 4; ++i) {
                TSTNode node = this.relatives[i];
                if (node == null) continue;
                mem += node.ramBytesUsed();
            }
            return mem;
        }
    }
}

