/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AStoreable;

final class PSubField
extends AStoreable {
    private final Definition.Field field;

    public PSubField(Location location, Definition.Field field) {
        super(location);
        this.field = Objects.requireNonNull(field);
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(Locals locals) {
        if (this.write && Modifier.isFinal(this.field.modifiers)) {
            throw this.createError(new IllegalArgumentException("Cannot write to read-only field [" + this.field.name + "] for type [" + this.field.type.name + "]."));
        }
        this.actual = this.field.type;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        if (Modifier.isStatic(this.field.modifiers)) {
            writer.getStatic(this.field.owner.type, this.field.javaName, this.field.type.type);
        } else {
            writer.getField(this.field.owner.type, this.field.javaName, this.field.type.type);
        }
    }

    @Override
    int accessElementCount() {
        return 1;
    }

    @Override
    boolean isDefOptimized() {
        return false;
    }

    @Override
    void updateActual(Definition.Type actual) {
        throw new IllegalArgumentException("Illegal tree structure.");
    }

    @Override
    void setup(MethodWriter writer, Globals globals) {
    }

    @Override
    void load(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        if (Modifier.isStatic(this.field.modifiers)) {
            writer.getStatic(this.field.owner.type, this.field.javaName, this.field.type.type);
        } else {
            writer.getField(this.field.owner.type, this.field.javaName, this.field.type.type);
        }
    }

    @Override
    void store(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        if (Modifier.isStatic(this.field.modifiers)) {
            writer.putStatic(this.field.owner.type, this.field.javaName, this.field.type.type);
        } else {
            writer.putField(this.field.owner.type, this.field.javaName, this.field.type.type);
        }
    }
}

