/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class SplitProcessor
extends AbstractProcessor {
    public static final String TYPE = "split";
    private final String field;
    private final String separator;

    SplitProcessor(String tag, String field, String separator) {
        super(tag);
        this.field = field;
        this.separator = separator;
    }

    String getField() {
        return this.field;
    }

    String getSeparator() {
        return this.separator;
    }

    public void execute(IngestDocument document) {
        String oldVal = (String)document.getFieldValue(this.field, String.class);
        if (oldVal == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot split.");
        }
        String[] strings = oldVal.split(this.separator);
        ArrayList splitList = new ArrayList(strings.length);
        Collections.addAll(splitList, strings);
        document.setFieldValue(this.field, splitList);
    }

    public String getType() {
        return TYPE;
    }

    public static class Factory
    implements Processor.Factory {
        public SplitProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)SplitProcessor.TYPE, (String)processorTag, config, (String)"field");
            return new SplitProcessor(processorTag, field, ConfigurationUtils.readStringProperty((String)SplitProcessor.TYPE, (String)processorTag, config, (String)"separator"));
        }
    }
}

