/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl.fonts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.render.pcl.fonts.PCLByteWriterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCLCharacterDefinition {
    private int charCode;
    private int charDefinitionSize;
    private byte[] glyfData;
    private boolean hasContinuation;
    private PCLCharacterFormat charFormat;
    private PCLCharacterClass charClass;
    private PCLByteWriterUtil pclByteWriter;
    private List<PCLCharacterDefinition> composites;
    private boolean isComposite;

    public PCLCharacterDefinition(int charCode, PCLCharacterFormat charFormat, PCLCharacterClass charClass, byte[] glyfData, PCLByteWriterUtil pclByteWriter, boolean isComposite) {
        this.charCode = charCode;
        this.charFormat = charFormat;
        this.charClass = charClass;
        this.glyfData = glyfData;
        this.pclByteWriter = pclByteWriter;
        this.isComposite = isComposite;
        this.charDefinitionSize = glyfData.length + 4 + 2 + 2;
        this.hasContinuation = this.charDefinitionSize > Short.MAX_VALUE;
        this.composites = new ArrayList<PCLCharacterDefinition>();
    }

    public byte[] getCharacterCommand() throws IOException {
        return this.pclByteWriter.writeCommand(String.format("*c%dE", this.isComposite ? 65535 : this.charCode));
    }

    public byte[] getCharacterDefinitionCommand() throws IOException {
        return this.pclByteWriter.writeCommand(String.format("(s%dW", 10 + this.glyfData.length));
    }

    public byte[] getData() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (!this.hasContinuation) {
            this.writeCharacterDescriptorHeader(0, baos);
            baos.write(this.glyfData);
        } else {
            int continuations = this.glyfData.length / Short.MAX_VALUE;
            for (int i = 0; i < continuations; ++i) {
                this.writeCharacterDescriptorHeader(i == 0 ? 0 : 1, baos);
                int continuationStart = i * Short.MAX_VALUE;
                int continuationLength = continuationStart - this.glyfData.length < Short.MAX_VALUE ? continuationStart - this.glyfData.length : Short.MAX_VALUE;
                baos.write(this.glyfData, continuationStart, continuationLength);
            }
        }
        baos.write(0);
        byte[] charBytes = baos.toByteArray();
        long sum = 0L;
        for (int i = 4; i < charBytes.length; ++i) {
            sum += (long)charBytes[i];
        }
        int remainder = (int)(sum % 256L);
        baos.write(256 - remainder);
        return baos.toByteArray();
    }

    private void writeCharacterDescriptorHeader(int continuation, ByteArrayOutputStream baos) throws IOException {
        baos.write(this.pclByteWriter.unsignedByte(this.charFormat.getValue()));
        baos.write(continuation);
        baos.write(this.pclByteWriter.unsignedByte(2));
        baos.write(this.pclByteWriter.unsignedByte(this.charClass.getValue()));
        baos.write(this.pclByteWriter.unsignedInt(this.glyfData.length + 4));
        baos.write(this.pclByteWriter.unsignedInt(this.charCode));
    }

    public void addCompositeGlyph(PCLCharacterDefinition composite) {
        this.composites.add(composite);
    }

    public List<PCLCharacterDefinition> getCompositeGlyphs() {
        return this.composites;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PCLCharacterClass {
        Bitmap(1),
        CompressedBitmap(2),
        Contour_Intellifont(3),
        Compound_Contour_Intellifont(4),
        TrueType(15);

        private int value;

        private PCLCharacterClass(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PCLCharacterFormat {
        LaserJet_Raster(4),
        Intellifont(10),
        TrueType(15);

        private int value;

        private PCLCharacterFormat(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

