#
# Author:: Matheus Francisco Barra Mina (<mfbmina@gmail.com>)
# © Copyright IBM Corporation 2015.
#
# LICENSE: MIT (http://opensource.org/licenses/MIT)
#
module Fog
  module Compute
    class Softlayer
      class Mock
        # Gets all Virtual Guest upgrade item prices
        # @param [Integer] id
        # @return [Excon::Response]
        def get_virtual_guest_upgrade_item_prices(id)
          response = Excon::Response.new
          found = self.get_vms.body.map{|server| server['id']}.include?(id.to_s)
          unless found
            response.status = 404
            response.body = {
                "error" => "Unable to find object with id of '#{id}'.",
                "code" => "SoftLayer_Exception_ObjectNotFound"
            }
          else
            response.status = 200
            response.body = get_upgrade_item_prices
          end
          response
        end
      end

      class Real
        def get_virtual_guest_upgrade_item_prices(id)
          request(:virtual_guest, "#{id}/getUpgradeItemPrices", :body => true, :http_method => :POST)
        end
      end
    end
  end
end

module Fog
  module Compute
    class Softlayer
      class Mock
        def get_upgrade_item_prices
          [
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".021",
                  "id"=>1640,
                  "itemId"=>857,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"15",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_core",
                          "id"=>80,
                          "name"=>"Computing Instance",
                          "quantityLimit"=>20}
                  ],
                  "item"=>{
                      "capacity"=>"1",
                      "description"=>"1 x 2.0 GHz Core",
                      "id"=>857,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_CORE_1",
                      "softwareDescriptionId"=>nil,
                      "units"=>"CORE",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>9,
                              "itemAttributeTypeId"=>3,
                              "itemId"=>857,
                              "value"=>"79",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>18,
                              "itemAttributeTypeId"=>4,
                              "itemId"=>857,
                              "value"=>"0.10",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>60,
                              "itemAttributeTypeId"=>16,
                              "itemId"=>857,
                              "value"=>"59",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>59,
                              "itemAttributeTypeId"=>17,
                              "itemId"=>857,
                              "value"=>"0.10",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL",
                                  "name"=>"CCI Hourly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>83,
                              "itemAttributeTypeId"=>20,
                              "itemId"=>857,
                              "value"=>"50",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_25",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>81,
                              "itemAttributeTypeId"=>21,
                              "itemId"=>857,
                              "value"=>"0.10",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_25",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>84,
                              "itemAttributeTypeId"=>22,
                              "itemId"=>857,
                              "value"=>"50",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>82,
                              "itemAttributeTypeId"=>23,
                              "itemId"=>857,
                              "value"=>"0.10",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>358,
                              "itemAttributeTypeId"=>51,
                              "itemId"=>857,
                              "value"=>"4",
                              "attributeType"=>{
                                  "keyName"=>"TOTAL_PHYSICAL_CORE_COUNT",
                                  "name"=>"Item Total Physical Core Count"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".041",
                  "id"=>1641,
                  "itemId"=>858,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"30",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_core",
                          "id"=>80,
                          "name"=>"Computing Instance",
                          "quantityLimit"=>20}
                  ],
                  "item"=>{
                      "capacity"=>"2",
                      "description"=>"2 x 2.0 GHz Cores",
                      "id"=>858,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_CORES_2",
                      "softwareDescriptionId"=>nil,
                      "units"=>"CORE",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>10,
                              "itemAttributeTypeId"=>3,
                              "itemId"=>858,
                              "value"=>"139",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>19,
                              "itemAttributeTypeId"=>4,
                              "itemId"=>858,
                              "value"=>"0.25",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>61,
                              "itemAttributeTypeId"=>16,
                              "itemId"=>858,
                              "value"=>"119",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>62,
                              "itemAttributeTypeId"=>17,
                              "itemId"=>858,
                              "value"=>"0.20",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL",
                                  "name"=>"CCI Hourly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>95,
                              "itemAttributeTypeId"=>20,
                              "itemId"=>858,
                              "value"=>"119",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_25",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>97,
                              "itemAttributeTypeId"=>21,
                              "itemId"=>858,
                              "value"=>"0.20",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_25",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>96,
                              "itemAttributeTypeId"=>22,
                              "itemId"=>858,
                              "value"=>"109",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>98,
                              "itemAttributeTypeId"=>23,
                              "itemId"=>858,
                              "value"=>"0.18",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>377,
                              "itemAttributeTypeId"=>51,
                              "itemId"=>858,
                              "value"=>"4",
                              "attributeType"=>{
                                  "keyName"=>"TOTAL_PHYSICAL_CORE_COUNT",
                                  "name"=>"Item Total Physical Core Count"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>true,
                  "hourlyRecurringFee"=>".082",
                  "id"=>1642,
                  "itemId"=>859,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"60",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_core",
                          "id"=>80,
                          "name"=>"Computing Instance",
                          "quantityLimit"=>20}
                  ],
                  "item"=>{
                      "capacity"=>"4",
                      "description"=>"4 x 2.0 GHz Cores",
                      "id"=>859,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_CORES_4",
                      "softwareDescriptionId"=>nil,
                      "units"=>"CORE",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>11,
                              "itemAttributeTypeId"=>3,
                              "itemId"=>859,
                              "value"=>"179",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>20,
                              "itemAttributeTypeId"=>4,
                              "itemId"=>859,
                              "value"=>"0.35",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>63,
                              "itemAttributeTypeId"=>16,
                              "itemId"=>859,
                              "value"=>"159",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>64,
                              "itemAttributeTypeId"=>17,
                              "itemId"=>859,
                              "value"=>"0.30",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL",
                                  "name"=>"CCI Hourly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>99,
                              "itemAttributeTypeId"=>20,
                              "itemId"=>859,
                              "value"=>"159",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_25",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>101,
                              "itemAttributeTypeId"=>21,
                              "itemId"=>859,
                              "value"=>"0.30",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_25",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>100,
                              "itemAttributeTypeId"=>22,
                              "itemId"=>859,
                              "value"=>"149",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>102,
                              "itemAttributeTypeId"=>23,
                              "itemId"=>859,
                              "value"=>"0.28",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>374,
                              "itemAttributeTypeId"=>51,
                              "itemId"=>859,
                              "value"=>"4",
                              "attributeType"=>{
                                  "keyName"=>"TOTAL_PHYSICAL_CORE_COUNT",
                                  "name"=>"Item Total Physical Core Count"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".164",
                  "id"=>1643,
                  "itemId"=>860,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"120",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_core",
                          "id"=>80,
                          "name"=>"Computing Instance",
                          "quantityLimit"=>20}
                  ],
                  "item"=>{
                      "capacity"=>"8",
                      "description"=>"8 x 2.0 GHz Cores",
                      "id"=>860,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_CORES_8",
                      "softwareDescriptionId"=>nil,
                      "units"=>"CORE",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>12,
                              "itemAttributeTypeId"=>3,
                              "itemId"=>860,
                              "value"=>"279",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>21,
                              "itemAttributeTypeId"=>4,
                              "itemId"=>860,
                              "value"=>"0.50",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>65,
                              "itemAttributeTypeId"=>16,
                              "itemId"=>860,
                              "value"=>"259",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>66,
                              "itemAttributeTypeId"=>17,
                              "itemId"=>860,
                              "value"=>"0.45",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL",
                                  "name"=>"CCI Hourly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>103,
                              "itemAttributeTypeId"=>20,
                              "itemId"=>860,
                              "value"=>"259",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_25",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>105,
                              "itemAttributeTypeId"=>21,
                              "itemId"=>860,
                              "value"=>"0.45",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_25",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>104,
                              "itemAttributeTypeId"=>22,
                              "itemId"=>860,
                              "value"=>"249",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>106,
                              "itemAttributeTypeId"=>23,
                              "itemId"=>860,
                              "value"=>"0.43",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>371,
                              "itemAttributeTypeId"=>51,
                              "itemId"=>860,
                              "value"=>"8",
                              "attributeType"=>{
                                  "keyName"=>"TOTAL_PHYSICAL_CORE_COUNT",
                                  "name"=>"Item Total Physical Core Count"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".247",
                  "id"=>2231,
                  "itemId"=>1198,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"180",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_core",
                          "id"=>80,
                          "name"=>"Computing Instance",
                          "quantityLimit"=>20}
                  ],
                  "item"=>{
                      "capacity"=>"12",
                      "description"=>"12 x 2.0 GHz Cores",
                      "id"=>1198,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_CORES_12",
                      "softwareDescriptionId"=>nil,
                      "units"=>"CORE",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>361,
                              "itemAttributeTypeId"=>51,
                              "itemId"=>1198,
                              "value"=>"12",
                              "attributeType"=>{
                                  "keyName"=>"TOTAL_PHYSICAL_CORE_COUNT",
                                  "name"=>"Item Total Physical Core Count"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".329",
                  "id"=>2235,
                  "itemId"=>1194,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"240",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_core",
                          "id"=>80,
                          "name"=>"Computing Instance",
                          "quantityLimit"=>20}
                  ],
                  "item"=>{
                      "capacity"=>"16",
                      "description"=>"16 x 2.0 GHz Cores",
                      "id"=>1194,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_CORES_16",
                      "softwareDescriptionId"=>nil,
                      "units"=>"CORE",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>356,
                              "itemAttributeTypeId"=>51,
                              "itemId"=>1194,
                              "value"=>"16",
                              "attributeType"=>{
                                  "keyName"=>"TOTAL_PHYSICAL_CORE_COUNT",
                                  "name"=>"Item Total Physical Core Count"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".2",
                  "id"=>1962,
                  "itemId"=>1045,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"139",
                  "setupFee"=>"0",
                  "sort"=>10,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_core",
                          "id"=>80,
                          "name"=>"Computing Instance",
                          "quantityLimit"=>20}
                  ],
                  "item"=>{
                      "capacity"=>"1",
                      "description"=>"Private 1 x 2.0 GHz Core",
                      "id"=>1045,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_PRIVATE_CORE_1",
                      "softwareDescriptionId"=>nil,
                      "units"=>"PRIVATE_CORE",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>1382,
                              "itemAttributeTypeId"=>3,
                              "itemId"=>1045,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>1384,
                              "itemAttributeTypeId"=>4,
                              "itemId"=>1045,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>1386,
                              "itemAttributeTypeId"=>16,
                              "itemId"=>1045,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>1388,
                              "itemAttributeTypeId"=>17,
                              "itemId"=>1045,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL",
                                  "name"=>"CCI Hourly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>367,
                              "itemAttributeTypeId"=>51,
                              "itemId"=>1045,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"TOTAL_PHYSICAL_CORE_COUNT",
                                  "name"=>"Item Total Physical Core Count"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".223",
                  "id"=>1963,
                  "itemId"=>1046,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"155",
                  "setupFee"=>"0",
                  "sort"=>10,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_core",
                          "id"=>80,
                          "name"=>"Computing Instance",
                          "quantityLimit"=>20}
                  ],
                  "item"=>{
                      "capacity"=>"2",
                      "description"=>"Private 2 x 2.0 GHz Cores",
                      "id"=>1046,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_PRIVATE_CORES_2",
                      "softwareDescriptionId"=>nil,
                      "units"=>"PRIVATE_CORE",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>1390,
                              "itemAttributeTypeId"=>3,
                              "itemId"=>1046,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>1392,
                              "itemAttributeTypeId"=>4,
                              "itemId"=>1046,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>133,
                              "itemAttributeTypeId"=>16,
                              "itemId"=>1046,
                              "value"=>"179",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>134,
                              "itemAttributeTypeId"=>17,
                              "itemId"=>1046,
                              "value"=>"0.45",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL",
                                  "name"=>"CCI Hourly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>353,
                              "itemAttributeTypeId"=>51,
                              "itemId"=>1046,
                              "value"=>"2",
                              "attributeType"=>{
                                  "keyName"=>"TOTAL_PHYSICAL_CORE_COUNT",
                                  "name"=>"Item Total Physical Core Count"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".243",
                  "id"=>1964,
                  "itemId"=>1047,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"169",
                  "setupFee"=>"0",
                  "sort"=>10,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_core",
                          "id"=>80,
                          "name"=>"Computing Instance",
                          "quantityLimit"=>20}
                  ],
                  "item"=>{
                      "capacity"=>"4",
                      "description"=>"Private 4 x 2.0 GHz Cores",
                      "id"=>1047,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_PRIVATE_CORES_4",
                      "softwareDescriptionId"=>nil,
                      "units"=>"PRIVATE_CORE",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>1038,
                              "itemAttributeTypeId"=>3,
                              "itemId"=>1047,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>1037,
                              "itemAttributeTypeId"=>4,
                              "itemId"=>1047,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>136,
                              "itemAttributeTypeId"=>16,
                              "itemId"=>1047,
                              "value"=>"279",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>135,
                              "itemAttributeTypeId"=>17,
                              "itemId"=>1047,
                              "value"=>"0.70",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL",
                                  "name"=>"CCI Hourly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>379,
                              "itemAttributeTypeId"=>51,
                              "itemId"=>1047,
                              "value"=>"4",
                              "attributeType"=>{
                                  "keyName"=>"TOTAL_PHYSICAL_CORE_COUNT",
                                  "name"=>"Item Total Physical Core Count"
                              }
                          },
                          {
                              "id"=>720,
                              "itemAttributeTypeId"=>86,
                              "itemId"=>1047,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_32GB",
                                  "name"=>"CCI Hourly Bundled Item Price (High Mem)"
                              }
                          },
                          {
                              "id"=>721,
                              "itemAttributeTypeId"=>87,
                              "itemId"=>1047,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_32GB",
                                  "name"=>"CCI Monthly Bundled Item Price (High Mem)"
                              }
                          },
                          {
                              "id"=>722,
                              "itemAttributeTypeId"=>88,
                              "itemId"=>1047,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_16GB",
                                  "name"=>"CCI Hourly Bundled Item Price (High Mem)"
                              }
                          },
                          {
                              "id"=>723,
                              "itemAttributeTypeId"=>89,
                              "itemId"=>1047,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_16GB",
                                  "name"=>"CCI Monthly Bundled Item Price (High Mem)"
                              }
                          },
                          {
                              "id"=>724,
                              "itemAttributeTypeId"=>90,
                              "itemId"=>1047,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_8GB",
                                  "name"=>"CCI Hourly Bundled Item Price (High Mem)"
                              }
                          },
                          {
                              "id"=>725,
                              "itemAttributeTypeId"=>91,
                              "itemId"=>1047,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_8GB",
                                  "name"=>"CCI Monthly Bundled Item Price (High Mem)"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".301",
                  "id"=>1965,
                  "itemId"=>1048,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"209",
                  "setupFee"=>"0",
                  "sort"=>10,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_core",
                          "id"=>80,
                          "name"=>"Computing Instance",
                          "quantityLimit"=>20}
                  ],
                  "item"=>{
                      "capacity"=>"8",
                      "description"=>"Private 8 x 2.0 GHz Cores",
                      "id"=>1048,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_PRIVATE_CORES_8",
                      "softwareDescriptionId"=>nil,
                      "units"=>"PRIVATE_CORE",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>1394,
                              "itemAttributeTypeId"=>3,
                              "itemId"=>1048,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>1396,
                              "itemAttributeTypeId"=>4,
                              "itemId"=>1048,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>138,
                              "itemAttributeTypeId"=>16,
                              "itemId"=>1048,
                              "value"=>"379",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>137,
                              "itemAttributeTypeId"=>17,
                              "itemId"=>1048,
                              "value"=>"0.95",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL",
                                  "name"=>"CCI Hourly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>363,
                              "itemAttributeTypeId"=>51,
                              "itemId"=>1048,
                              "value"=>"8",
                              "attributeType"=>{
                                  "keyName"=>"TOTAL_PHYSICAL_CORE_COUNT",
                                  "name"=>"Item Total Physical Core Count"
                              }
                          },
                          {
                              "id"=>726,
                              "itemAttributeTypeId"=>86,
                              "itemId"=>1048,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_32GB",
                                  "name"=>"CCI Hourly Bundled Item Price (High Mem)"
                              }
                          },
                          {
                              "id"=>727,
                              "itemAttributeTypeId"=>87,
                              "itemId"=>1048,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_32GB",
                                  "name"=>"CCI Monthly Bundled Item Price (High Mem)"
                              }
                          },
                          {
                              "id"=>728,
                              "itemAttributeTypeId"=>88,
                              "itemId"=>1048,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_16GB",
                                  "name"=>"CCI Hourly Bundled Item Price (High Mem)"
                              }
                          },
                          {
                              "id"=>729,
                              "itemAttributeTypeId"=>89,
                              "itemId"=>1048,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_16GB",
                                  "name"=>"CCI Monthly Bundled Item Price (High Mem)"
                              }
                          },
                          {
                              "id"=>730,
                              "itemAttributeTypeId"=>90,
                              "itemId"=>1048,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_8GB",
                                  "name"=>"CCI Hourly Bundled Item Price (High Mem)"
                              }
                          },
                          {
                              "id"=>731,
                              "itemAttributeTypeId"=>91,
                              "itemId"=>1048,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_8GB",
                                  "name"=>"CCI Monthly Bundled Item Price (High Mem)"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".019",
                  "id"=>1644,
                  "itemId"=>861,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"12.6",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"ram",
                          "id"=>3,
                          "name"=>"RAM",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"1",
                      "description"=>"1 GB",
                      "id"=>861,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"RAM_1_GB",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>13,
                              "itemAttributeTypeId"=>3,
                              "itemId"=>861,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>22,
                              "itemAttributeTypeId"=>4,
                              "itemId"=>861,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>68,
                              "itemAttributeTypeId"=>16,
                              "itemId"=>861,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>67,
                              "itemAttributeTypeId"=>17,
                              "itemId"=>861,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL",
                                  "name"=>"CCI Hourly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>109,
                              "itemAttributeTypeId"=>20,
                              "itemId"=>861,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_25",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>107,
                              "itemAttributeTypeId"=>21,
                              "itemId"=>861,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_25",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>110,
                              "itemAttributeTypeId"=>22,
                              "itemId"=>861,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>108,
                              "itemAttributeTypeId"=>23,
                              "itemId"=>861,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>true,
                  "hourlyRecurringFee"=>".038",
                  "id"=>1645,
                  "itemId"=>862,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"25.2",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"ram",
                          "id"=>3,
                          "name"=>"RAM",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"2",
                      "description"=>"2 GB",
                      "id"=>862,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"RAM_2_GB",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>14,
                              "itemAttributeTypeId"=>3,
                              "itemId"=>862,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>23,
                              "itemAttributeTypeId"=>4,
                              "itemId"=>862,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>70,
                              "itemAttributeTypeId"=>16,
                              "itemId"=>862,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>69,
                              "itemAttributeTypeId"=>17,
                              "itemId"=>862,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL",
                                  "name"=>"CCI Hourly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>113,
                              "itemAttributeTypeId"=>20,
                              "itemId"=>862,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_25",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>111,
                              "itemAttributeTypeId"=>21,
                              "itemId"=>862,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_25",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>114,
                              "itemAttributeTypeId"=>22,
                              "itemId"=>862,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>112,
                              "itemAttributeTypeId"=>23,
                              "itemId"=>862,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".077",
                  "id"=>1646,
                  "itemId"=>863,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"50.4",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"ram",
                          "id"=>3,
                          "name"=>"RAM",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"4",
                      "description"=>"4 GB",
                      "id"=>863,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"RAM_4_GB",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>15,
                              "itemAttributeTypeId"=>3,
                              "itemId"=>863,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>24,
                              "itemAttributeTypeId"=>4,
                              "itemId"=>863,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>72,
                              "itemAttributeTypeId"=>16,
                              "itemId"=>863,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>71,
                              "itemAttributeTypeId"=>17,
                              "itemId"=>863,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL",
                                  "name"=>"CCI Hourly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>117,
                              "itemAttributeTypeId"=>20,
                              "itemId"=>863,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_25",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>115,
                              "itemAttributeTypeId"=>21,
                              "itemId"=>863,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_25",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>116,
                              "itemAttributeTypeId"=>22,
                              "itemId"=>863,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>118,
                              "itemAttributeTypeId"=>23,
                              "itemId"=>863,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".11",
                  "id"=>2238,
                  "itemId"=>1204,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"72",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"ram",
                          "id"=>3,
                          "name"=>"RAM",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"6",
                      "description"=>"6 GB",
                      "id"=>1204,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"RAM_6_GB",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".142",
                  "id"=>1647,
                  "itemId"=>864,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"93.6",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"ram",
                          "id"=>3,
                          "name"=>"RAM",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"8",
                      "description"=>"8 GB",
                      "id"=>864,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"RAM_8_GB",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>16,
                              "itemAttributeTypeId"=>3,
                              "itemId"=>864,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>25,
                              "itemAttributeTypeId"=>4,
                              "itemId"=>864,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>74,
                              "itemAttributeTypeId"=>16,
                              "itemId"=>864,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>73,
                              "itemAttributeTypeId"=>17,
                              "itemId"=>864,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL",
                                  "name"=>"CCI Hourly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>121,
                              "itemAttributeTypeId"=>20,
                              "itemId"=>864,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_25",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>119,
                              "itemAttributeTypeId"=>21,
                              "itemId"=>864,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_25",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>122,
                              "itemAttributeTypeId"=>22,
                              "itemId"=>864,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>120,
                              "itemAttributeTypeId"=>23,
                              "itemId"=>864,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".197",
                  "id"=>2243,
                  "itemId"=>1209,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"129.6",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"ram",
                          "id"=>3,
                          "name"=>"RAM",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"12",
                      "description"=>"12 GB",
                      "id"=>1209,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"RAM_12_GB",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".252",
                  "id"=>1927,
                  "itemId"=>1017,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"165.6",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"ram",
                          "id"=>3,
                          "name"=>"RAM",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"16",
                      "description"=>"16 GB RAM",
                      "id"=>1017,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"RAM_16_GB",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>688,
                              "itemAttributeTypeId"=>3,
                              "itemId"=>1017,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>687,
                              "itemAttributeTypeId"=>4,
                              "itemId"=>1017,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>690,
                              "itemAttributeTypeId"=>16,
                              "itemId"=>1017,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>689,
                              "itemAttributeTypeId"=>17,
                              "itemId"=>1017,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL",
                                  "name"=>"CCI Hourly Bundled Item Price (with local disk)"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".427",
                  "id"=>21275,
                  "itemId"=>1155,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"280.8",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"ram",
                          "id"=>3,
                          "name"=>"RAM",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"32",
                      "description"=>"32 GB",
                      "id"=>1155,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"RAM_32_GB",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>692,
                              "itemAttributeTypeId"=>3,
                              "itemId"=>1155,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>691,
                              "itemAttributeTypeId"=>4,
                              "itemId"=>1155,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>694,
                              "itemAttributeTypeId"=>16,
                              "itemId"=>1155,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>693,
                              "itemAttributeTypeId"=>17,
                              "itemId"=>1155,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL",
                                  "name"=>"CCI Hourly Bundled Item Price (with local disk)"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".559",
                  "id"=>22422,
                  "itemId"=>4468,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"367.2",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"ram",
                          "id"=>3,
                          "name"=>"RAM",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"48",
                      "description"=>"48 GB",
                      "id"=>4468,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"RAM_48_GB",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".69",
                  "id"=>37042,
                  "itemId"=>1154,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"453.6",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "usageRate"=>"0",
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"ram",
                          "id"=>3,
                          "name"=>"RAM",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"64",
                      "description"=>"64 GB",
                      "id"=>1154,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"RAM_64_GB",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".006",
                  "id"=>2255,
                  "itemId"=>1213,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"4.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"10",
                      "description"=>"10 GB (SAN)",
                      "id"=>1213,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_10_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>198,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1213,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".008",
                  "id"=>2256,
                  "itemId"=>1214,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"5.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"20",
                      "description"=>"20 GB (SAN)",
                      "id"=>1214,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_20_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>199,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1214,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".009",
                  "id"=>21861,
                  "itemId"=>4386,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"6.5",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"25",
                      "description"=>"25 GB (SAN)",
                      "id"=>4386,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_25_GB_SAN_4",
                      "longDescription"=>"For CCI Secondary Disk",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>1067,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>4386,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".01",
                  "id"=>2257,
                  "itemId"=>1216,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"6.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"30",
                      "description"=>"30 GB (SAN)",
                      "id"=>1216,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_30_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>200,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1216,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".011",
                  "id"=>2258,
                  "itemId"=>1217,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"8",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"40",
                      "description"=>"40 GB (SAN)",
                      "id"=>1217,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_40_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>201,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1217,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".012",
                  "id"=>2259,
                  "itemId"=>1218,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"9.14",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"50",
                      "description"=>"50 GB (SAN)",
                      "id"=>1218,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_50_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>202,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1218,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".013",
                  "id"=>2260,
                  "itemId"=>1219,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"9.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"75",
                      "description"=>"75 GB (SAN)",
                      "id"=>1219,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_75_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>203,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1219,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".014",
                  "id"=>2277,
                  "itemId"=>922,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"10.29",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"100",
                      "description"=>"100 GB (SAN)",
                      "id"=>922,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_100_GB_SAN_3",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>196,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>922,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".015",
                  "id"=>2261,
                  "itemId"=>1220,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"10.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"125",
                      "description"=>"125 GB (SAN)",
                      "id"=>1220,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_125_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>204,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1220,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".016",
                  "id"=>2262,
                  "itemId"=>1221,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"11.43",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"150",
                      "description"=>"150 GB (SAN)",
                      "id"=>1221,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_150_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>205,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1221,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".017",
                  "id"=>2263,
                  "itemId"=>1222,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"12",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"175",
                      "description"=>"175 GB (SAN)",
                      "id"=>1222,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_175_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>206,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1222,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".018",
                  "id"=>2264,
                  "itemId"=>1223,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"12.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"200",
                      "description"=>"200 GB (SAN)",
                      "id"=>1223,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_200_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>207,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1223,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".02",
                  "id"=>2272,
                  "itemId"=>866,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"14.29",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"250",
                      "description"=>"250 GB (SAN)",
                      "id"=>866,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_250_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>190,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>866,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".025",
                  "id"=>2265,
                  "itemId"=>1225,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"18.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"300",
                      "description"=>"300 GB (SAN)",
                      "id"=>1225,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_300_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>208,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1225,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".031",
                  "id"=>2266,
                  "itemId"=>1226,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"22.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"350",
                      "description"=>"350 GB (SAN)",
                      "id"=>1226,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_350_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>209,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1226,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".035",
                  "id"=>2267,
                  "itemId"=>1227,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"25.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"400",
                      "description"=>"400 GB (SAN)",
                      "id"=>1227,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_400_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>210,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1227,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".039",
                  "id"=>2270,
                  "itemId"=>916,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"28.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"500",
                      "description"=>"500 GB (SAN)",
                      "id"=>916,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_500_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>192,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>916,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".059",
                  "id"=>2278,
                  "itemId"=>1229,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"42.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"750",
                      "description"=>"750 GB (SAN)",
                      "id"=>1229,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_750_GB_SAN_2",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>211,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1229,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".078",
                  "id"=>2279,
                  "itemId"=>1230,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"57.14",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"1000",
                      "description"=>"1.00 TB (SAN)",
                      "id"=>1230,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_1000_GB_SAN_2",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>212,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1230,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".117",
                  "id"=>2280,
                  "itemId"=>1231,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"85.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"1500",
                      "description"=>"1.50 TB (SAN)",
                      "id"=>1231,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_1500_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>213,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1231,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".157",
                  "id"=>2281,
                  "itemId"=>1232,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"114.29",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"2000",
                      "description"=>"2.00 TB (SAN)",
                      "id"=>1232,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_2000_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>214,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1232,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".002",
                  "id"=>21857,
                  "itemId"=>4385,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"1",
                  "setupFee"=>"0",
                  "sort"=>10,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"25",
                      "description"=>"25 GB (LOCAL)",
                      "id"=>4385,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_25_GB_LOCAL_3",
                      "longDescription"=>"For CCI Secondary Disk",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>1066,
                              "itemAttributeTypeId"=>13,
                              "itemId"=>4385,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"LOCAL_DISK",
                                  "name"=>"Local disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".005",
                  "id"=>13916,
                  "itemId"=>3899,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"4",
                  "setupFee"=>"0",
                  "sort"=>10,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"100",
                      "description"=>"100 GB (LOCAL)",
                      "id"=>3899,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_100_GB_LOCAL_3",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>77,
                              "itemAttributeTypeId"=>13,
                              "itemId"=>3899,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"LOCAL_DISK",
                                  "name"=>"Local disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".008",
                  "id"=>14011,
                  "itemId"=>3953,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"6",
                  "setupFee"=>"0",
                  "sort"=>10,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"150",
                      "description"=>"150 GB (LOCAL)",
                      "id"=>3953,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_150_GB_LOCAL",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>147,
                              "itemAttributeTypeId"=>13,
                              "itemId"=>3953,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"LOCAL_DISK",
                                  "name"=>"Local disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".011",
                  "id"=>13897,
                  "itemId"=>3889,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"8",
                  "setupFee"=>"0",
                  "sort"=>10,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"200",
                      "description"=>"200 GB (LOCAL)",
                      "id"=>3889,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_200_GB_LOCAL",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>52,
                              "itemAttributeTypeId"=>13,
                              "itemId"=>3889,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"LOCAL_DISK",
                                  "name"=>"Local disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".016",
                  "id"=>13898,
                  "itemId"=>3890,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"12",
                  "setupFee"=>"0",
                  "sort"=>10,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk1",
                          "id"=>82,
                          "name"=>"Second Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"300",
                      "description"=>"300 GB (LOCAL)",
                      "id"=>3890,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_300_GB_LOCAL",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>53,
                              "itemAttributeTypeId"=>13,
                              "itemId"=>3890,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"LOCAL_DISK",
                                  "name"=>"Local disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".006",
                  "id"=>2255,
                  "itemId"=>1213,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"4.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"10",
                      "description"=>"10 GB (SAN)",
                      "id"=>1213,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_10_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>198,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1213,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".008",
                  "id"=>2256,
                  "itemId"=>1214,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"5.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"20",
                      "description"=>"20 GB (SAN)",
                      "id"=>1214,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_20_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>199,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1214,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".009",
                  "id"=>21861,
                  "itemId"=>4386,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"6.5",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"25",
                      "description"=>"25 GB (SAN)",
                      "id"=>4386,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_25_GB_SAN_4",
                      "longDescription"=>"For CCI Secondary Disk",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>1067,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>4386,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".01",
                  "id"=>2257,
                  "itemId"=>1216,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"6.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"30",
                      "description"=>"30 GB (SAN)",
                      "id"=>1216,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_30_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>200,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1216,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".011",
                  "id"=>2258,
                  "itemId"=>1217,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"8",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"40",
                      "description"=>"40 GB (SAN)",
                      "id"=>1217,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_40_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>201,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1217,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".012",
                  "id"=>2259,
                  "itemId"=>1218,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"9.14",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"50",
                      "description"=>"50 GB (SAN)",
                      "id"=>1218,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_50_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>202,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1218,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".013",
                  "id"=>2260,
                  "itemId"=>1219,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"9.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"75",
                      "description"=>"75 GB (SAN)",
                      "id"=>1219,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_75_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>203,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1219,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".014",
                  "id"=>2277,
                  "itemId"=>922,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"10.29",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"100",
                      "description"=>"100 GB (SAN)",
                      "id"=>922,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_100_GB_SAN_3",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>196,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>922,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".015",
                  "id"=>2261,
                  "itemId"=>1220,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"10.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"125",
                      "description"=>"125 GB (SAN)",
                      "id"=>1220,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_125_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>204,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1220,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".016",
                  "id"=>2262,
                  "itemId"=>1221,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"11.43",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"150",
                      "description"=>"150 GB (SAN)",
                      "id"=>1221,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_150_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>205,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1221,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".017",
                  "id"=>2263,
                  "itemId"=>1222,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"12",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"175",
                      "description"=>"175 GB (SAN)",
                      "id"=>1222,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_175_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>206,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1222,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".018",
                  "id"=>2264,
                  "itemId"=>1223,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"12.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"200",
                      "description"=>"200 GB (SAN)",
                      "id"=>1223,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_200_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>207,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1223,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".02",
                  "id"=>2272,
                  "itemId"=>866,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"14.29",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"250",
                      "description"=>"250 GB (SAN)",
                      "id"=>866,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_250_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>190,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>866,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".025",
                  "id"=>2265,
                  "itemId"=>1225,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"18.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"300",
                      "description"=>"300 GB (SAN)",
                      "id"=>1225,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_300_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>208,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1225,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".031",
                  "id"=>2266,
                  "itemId"=>1226,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"22.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"350",
                      "description"=>"350 GB (SAN)",
                      "id"=>1226,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_350_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>209,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1226,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".035",
                  "id"=>2267,
                  "itemId"=>1227,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"25.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"400",
                      "description"=>"400 GB (SAN)",
                      "id"=>1227,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_400_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>210,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1227,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".039",
                  "id"=>2270,
                  "itemId"=>916,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"28.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"500",
                      "description"=>"500 GB (SAN)",
                      "id"=>916,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_500_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>192,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>916,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".059",
                  "id"=>2278,
                  "itemId"=>1229,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"42.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"750",
                      "description"=>"750 GB (SAN)",
                      "id"=>1229,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_750_GB_SAN_2",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>211,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1229,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".078",
                  "id"=>2279,
                  "itemId"=>1230,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"57.14",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"1000",
                      "description"=>"1.00 TB (SAN)",
                      "id"=>1230,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_1000_GB_SAN_2",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>212,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1230,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".117",
                  "id"=>2280,
                  "itemId"=>1231,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"85.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"1500",
                      "description"=>"1.50 TB (SAN)",
                      "id"=>1231,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_1500_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>213,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1231,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".157",
                  "id"=>2281,
                  "itemId"=>1232,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"114.29",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk2",
                          "id"=>92,
                          "name"=>"Third Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"2000",
                      "description"=>"2.00 TB (SAN)",
                      "id"=>1232,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_2000_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>214,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1232,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".006",
                  "id"=>2255,
                  "itemId"=>1213,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"4.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"10",
                      "description"=>"10 GB (SAN)",
                      "id"=>1213,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_10_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>198,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1213,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".008",
                  "id"=>2256,
                  "itemId"=>1214,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"5.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"20",
                      "description"=>"20 GB (SAN)",
                      "id"=>1214,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_20_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>199,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1214,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".009",
                  "id"=>21861,
                  "itemId"=>4386,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"6.5",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"25",
                      "description"=>"25 GB (SAN)",
                      "id"=>4386,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_25_GB_SAN_4",
                      "longDescription"=>"For CCI Secondary Disk",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>1067,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>4386,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".01",
                  "id"=>2257,
                  "itemId"=>1216,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"6.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"30",
                      "description"=>"30 GB (SAN)",
                      "id"=>1216,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_30_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>200,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1216,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".011",
                  "id"=>2258,
                  "itemId"=>1217,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"8",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"40",
                      "description"=>"40 GB (SAN)",
                      "id"=>1217,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_40_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>201,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1217,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".012",
                  "id"=>2259,
                  "itemId"=>1218,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"9.14",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"50",
                      "description"=>"50 GB (SAN)",
                      "id"=>1218,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_50_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>202,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1218,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".013",
                  "id"=>2260,
                  "itemId"=>1219,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"9.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"75",
                      "description"=>"75 GB (SAN)",
                      "id"=>1219,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_75_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>203,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1219,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".014",
                  "id"=>2277,
                  "itemId"=>922,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"10.29",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"100",
                      "description"=>"100 GB (SAN)",
                      "id"=>922,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_100_GB_SAN_3",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>196,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>922,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".015",
                  "id"=>2261,
                  "itemId"=>1220,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"10.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"125",
                      "description"=>"125 GB (SAN)",
                      "id"=>1220,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_125_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>204,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1220,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".016",
                  "id"=>2262,
                  "itemId"=>1221,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"11.43",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"150",
                      "description"=>"150 GB (SAN)",
                      "id"=>1221,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_150_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>205,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1221,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".017",
                  "id"=>2263,
                  "itemId"=>1222,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"12",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"175",
                      "description"=>"175 GB (SAN)",
                      "id"=>1222,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_175_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>206,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1222,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".018",
                  "id"=>2264,
                  "itemId"=>1223,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"12.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"200",
                      "description"=>"200 GB (SAN)",
                      "id"=>1223,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_200_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>207,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1223,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".02",
                  "id"=>2272,
                  "itemId"=>866,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"14.29",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"250",
                      "description"=>"250 GB (SAN)",
                      "id"=>866,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_250_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>190,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>866,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".025",
                  "id"=>2265,
                  "itemId"=>1225,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"18.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"300",
                      "description"=>"300 GB (SAN)",
                      "id"=>1225,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_300_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>208,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1225,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".031",
                  "id"=>2266,
                  "itemId"=>1226,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"22.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"350",
                      "description"=>"350 GB (SAN)",
                      "id"=>1226,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_350_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>209,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1226,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".035",
                  "id"=>2267,
                  "itemId"=>1227,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"25.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"400",
                      "description"=>"400 GB (SAN)",
                      "id"=>1227,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_400_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>210,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1227,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".039",
                  "id"=>2270,
                  "itemId"=>916,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"28.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"500",
                      "description"=>"500 GB (SAN)",
                      "id"=>916,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_500_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>192,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>916,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".059",
                  "id"=>2278,
                  "itemId"=>1229,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"42.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"750",
                      "description"=>"750 GB (SAN)",
                      "id"=>1229,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_750_GB_SAN_2",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>211,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1229,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".078",
                  "id"=>2279,
                  "itemId"=>1230,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"57.14",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"1000",
                      "description"=>"1.00 TB (SAN)",
                      "id"=>1230,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_1000_GB_SAN_2",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>212,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1230,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".117",
                  "id"=>2280,
                  "itemId"=>1231,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"85.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"1500",
                      "description"=>"1.50 TB (SAN)",
                      "id"=>1231,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_1500_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>213,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1231,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".157",
                  "id"=>2281,
                  "itemId"=>1232,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"114.29",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk3",
                          "id"=>93,
                          "name"=>"Fourth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"2000",
                      "description"=>"2.00 TB (SAN)",
                      "id"=>1232,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_2000_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>214,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1232,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".006",
                  "id"=>2255,
                  "itemId"=>1213,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"4.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"10",
                      "description"=>"10 GB (SAN)",
                      "id"=>1213,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_10_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>198,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1213,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".008",
                  "id"=>2256,
                  "itemId"=>1214,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"5.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"20",
                      "description"=>"20 GB (SAN)",
                      "id"=>1214,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_20_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>199,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1214,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".009",
                  "id"=>21861,
                  "itemId"=>4386,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"6.5",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"25",
                      "description"=>"25 GB (SAN)",
                      "id"=>4386,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_25_GB_SAN_4",
                      "longDescription"=>"For CCI Secondary Disk",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>1067,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>4386,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".01",
                  "id"=>2257,
                  "itemId"=>1216,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"6.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"30",
                      "description"=>"30 GB (SAN)",
                      "id"=>1216,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_30_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>200,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1216,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".011",
                  "id"=>2258,
                  "itemId"=>1217,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"8",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"40",
                      "description"=>"40 GB (SAN)",
                      "id"=>1217,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_40_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>201,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1217,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".012",
                  "id"=>2259,
                  "itemId"=>1218,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"9.14",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"50",
                      "description"=>"50 GB (SAN)",
                      "id"=>1218,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_50_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>202,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1218,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".013",
                  "id"=>2260,
                  "itemId"=>1219,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"9.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"75",
                      "description"=>"75 GB (SAN)",
                      "id"=>1219,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_75_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>203,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1219,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".014",
                  "id"=>2277,
                  "itemId"=>922,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"10.29",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"100",
                      "description"=>"100 GB (SAN)",
                      "id"=>922,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_100_GB_SAN_3",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>196,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>922,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".015",
                  "id"=>2261,
                  "itemId"=>1220,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"10.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"125",
                      "description"=>"125 GB (SAN)",
                      "id"=>1220,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_125_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>204,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1220,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".016",
                  "id"=>2262,
                  "itemId"=>1221,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"11.43",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"150",
                      "description"=>"150 GB (SAN)",
                      "id"=>1221,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_150_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>205,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1221,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".017",
                  "id"=>2263,
                  "itemId"=>1222,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"12",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"175",
                      "description"=>"175 GB (SAN)",
                      "id"=>1222,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_175_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>206,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1222,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".018",
                  "id"=>2264,
                  "itemId"=>1223,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"12.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"200",
                      "description"=>"200 GB (SAN)",
                      "id"=>1223,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_200_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>207,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1223,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".02",
                  "id"=>2272,
                  "itemId"=>866,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"14.29",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"250",
                      "description"=>"250 GB (SAN)",
                      "id"=>866,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_250_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>190,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>866,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".025",
                  "id"=>2265,
                  "itemId"=>1225,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"18.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"300",
                      "description"=>"300 GB (SAN)",
                      "id"=>1225,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_300_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>208,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1225,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".031",
                  "id"=>2266,
                  "itemId"=>1226,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"22.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"350",
                      "description"=>"350 GB (SAN)",
                      "id"=>1226,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_350_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>209,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1226,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".035",
                  "id"=>2267,
                  "itemId"=>1227,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"25.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"400",
                      "description"=>"400 GB (SAN)",
                      "id"=>1227,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_400_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>210,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1227,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".039",
                  "id"=>2270,
                  "itemId"=>916,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"28.57",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"500",
                      "description"=>"500 GB (SAN)",
                      "id"=>916,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_500_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>192,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>916,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".059",
                  "id"=>2278,
                  "itemId"=>1229,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"42.86",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"750",
                      "description"=>"750 GB (SAN)",
                      "id"=>1229,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_750_GB_SAN_2",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>211,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1229,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".078",
                  "id"=>2279,
                  "itemId"=>1230,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"57.14",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"1000",
                      "description"=>"1.00 TB (SAN)",
                      "id"=>1230,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_1000_GB_SAN_2",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>212,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1230,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".117",
                  "id"=>2280,
                  "itemId"=>1231,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"85.71",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"1500",
                      "description"=>"1.50 TB (SAN)",
                      "id"=>1231,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_1500_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>213,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1231,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>".157",
                  "id"=>2281,
                  "itemId"=>1232,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"114.29",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk4",
                          "id"=>116,
                          "name"=>"Fifth Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"2000",
                      "description"=>"2.00 TB (SAN)",
                      "id"=>1232,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_2000_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>214,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1232,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>true,
                  "id"=>248,
                  "itemId"=>173,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"0",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"bandwidth",
                          "id"=>10,
                          "name"=>"Public Bandwidth",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"5000",
                      "description"=>"5000 GB Bandwidth",
                      "id"=>173,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"BANDWIDTH_5000_GB",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>249,
                      "attributes"=>[]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "id"=>129,
                  "itemId"=>100,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"50",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"bandwidth",
                          "id"=>10,
                          "name"=>"Public Bandwidth",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"6000",
                      "description"=>"6000 GB Bandwidth",
                      "id"=>100,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"BANDWIDTH_6000_GB",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>249,
                      "attributes"=>[],
                      "requirements"=>[]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "id"=>130,
                  "itemId"=>101,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"150",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"bandwidth",
                          "id"=>10,
                          "name"=>"Public Bandwidth",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"8000",
                      "description"=>"8000 GB Bandwidth",
                      "id"=>101,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"BANDWIDTH_8000_GB",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>249,
                      "attributes"=>[],
                      "requirements"=>[]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "id"=>131,
                  "itemId"=>102,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"250",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"bandwidth",
                          "id"=>10,
                          "name"=>"Public Bandwidth",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"10000",
                      "description"=>"10000 GB Bandwidth",
                      "id"=>102,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"BANDWIDTH_10000_GB",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>249,
                      "attributes"=>[],
                      "requirements"=>[]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "id"=>125,
                  "itemId"=>97,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"2000",
                  "setupFee"=>"0",
                  "sort"=>5,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"bandwidth",
                          "id"=>10,
                          "name"=>"Public Bandwidth",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "description"=>"Unlimited Bandwidth (100 Mbps Uplink)",
                      "id"=>97,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"BANDWIDTH_UNLIMITED_100_MBPS_UPLINK",
                      "softwareDescriptionId"=>nil,
                      "upgradeItemId"=>nil,
                      "attributes"=>[],
                      "requirements"=>[
                          {
                              "id"=>4,
                              "itemId"=>97,
                              "requiredItemId"=>187,
                              "item"=>{
                                  "capacity"=>"100",
                                  "description"=>"100 Mbps Public & Private Network Uplinks",
                                  "id"=>187,
                                  "itemTaxCategoryId"=>166,
                                  "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS",
                                  "softwareDescriptionId"=>nil,
                                  "units"=>"Mbps",
                                  "upgradeItemId"=>188,
                                  "attributes"=>[]
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>true,
                  "hourlyRecurringFee"=>"0",
                  "id"=>273,
                  "itemId"=>187,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"0",
                  "setupFee"=>"0",
                  "sort"=>2,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"port_speed",
                          "id"=>26,
                          "name"=>"Uplink Port Speeds",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"100",
                      "description"=>"100 Mbps Public & Private Network Uplinks",
                      "id"=>187,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"100_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS",
                      "softwareDescriptionId"=>nil,
                      "units"=>"Mbps",
                      "upgradeItemId"=>188,
                      "attributes"=>[]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>".04",
                  "id"=>274,
                  "itemId"=>188,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"20",
                  "setupFee"=>"0",
                  "sort"=>3,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"port_speed",
                          "id"=>26,
                          "name"=>"Uplink Port Speeds",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"1000",
                      "description"=>"1 Gbps Public & Private Network Uplinks",
                      "id"=>188,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"1_GBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS",
                      "softwareDescriptionId"=>nil,
                      "units"=>"Mbps",
                      "upgradeItemId"=>nil,
                      "attributes"=>[]
                  }
              },
              {
                  "currentPriceFlag"=>nil,
                  "hourlyRecurringFee"=>"0",
                  "id"=>272,
                  "itemId"=>186,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"0",
                  "setupFee"=>"0",
                  "sort"=>5,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"port_speed",
                          "id"=>26,
                          "name"=>"Uplink Port Speeds",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"10",
                      "description"=>"10 Mbps Public & Private Network Uplinks",
                      "id"=>186,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"10_MBPS_PUBLIC_PRIVATE_NETWORK_UPLINKS",
                      "softwareDescriptionId"=>nil,
                      "units"=>"Mbps",
                      "upgradeItemId"=>187,
                      "attributes"=>[]
                  }
              },
              {
                  "currentPriceFlag"=>true,
                  "hourlyRecurringFee"=>"0",
                  "id"=>2202,
                  "itemId"=>1178,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"0",
                  "setupFee"=>"0",
                  "sort"=>0,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk0",
                          "id"=>81,
                          "name"=>"First Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"25",
                      "description"=>"25 GB (SAN)",
                      "id"=>1178,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_25_GB_SAN",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>131,
                              "itemAttributeTypeId"=>14,
                              "itemId"=>1178,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_FIRST_DISK",
                                  "name"=>"First Disk for CCI Bundled Configurations"
                              }
                          },
                          {
                              "id"=>127,
                              "itemAttributeTypeId"=>20,
                              "itemId"=>1178,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_25",
                                  "name"=>"CCI Monthly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>126,
                              "itemAttributeTypeId"=>21,
                              "itemId"=>1178,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_25",
                                  "name"=>"CCI Hourly Bundled Item Price"
                              }
                          },
                          {
                              "id"=>197,
                              "itemAttributeTypeId"=>50,
                              "itemId"=>1178,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"SAN_DISK",
                                  "name"=>"SAN Disk"
                              }
                          }
                      ]
                  }
              },
              {
                  "currentPriceFlag"=>false,
                  "hourlyRecurringFee"=>"0",
                  "id"=>13899,
                  "itemId"=>3891,
                  "laborFee"=>"0",
                  "onSaleFlag"=>nil,
                  "oneTimeFee"=>"0",
                  "quantity"=>nil,
                  "recurringFee"=>"0",
                  "setupFee"=>"0",
                  "sort"=>10,
                  "accountRestrictions"=>[],
                  "categories"=>[
                      {
                          "categoryCode"=>"guest_disk0",
                          "id"=>81,
                          "name"=>"First Disk",
                          "quantityLimit"=>0}
                  ],
                  "item"=>{
                      "capacity"=>"25",
                      "description"=>"25 GB (LOCAL)",
                      "id"=>3891,
                      "itemTaxCategoryId"=>166,
                      "keyName"=>"GUEST_DISK_25_GB_LOCAL",
                      "softwareDescriptionId"=>nil,
                      "units"=>"GB",
                      "upgradeItemId"=>nil,
                      "attributes"=>[
                          {
                              "id"=>54,
                              "itemAttributeTypeId"=>13,
                              "itemId"=>3891,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"LOCAL_DISK",
                                  "name"=>"Local disk"
                              }
                          },
                          {
                              "id"=>132,
                              "itemAttributeTypeId"=>14,
                              "itemId"=>3891,
                              "value"=>"1",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_FIRST_DISK",
                                  "name"=>"First Disk for CCI Bundled Configurations"
                              }
                          },
                          {
                              "id"=>129,
                              "itemAttributeTypeId"=>22,
                              "itemId"=>3891,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_MONTHLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          },
                          {
                              "id"=>128,
                              "itemAttributeTypeId"=>23,
                              "itemId"=>3891,
                              "value"=>"0",
                              "attributeType"=>{
                                  "keyName"=>"CCI_BUNDLED_ITEM_PRICE_HOURLY_LOCAL_25",
                                  "name"=>"CCI Monthly Bundled Item Price (with local disk)"
                              }
                          }
                      ]
                  }
              }
          ]
        end
      end
    end
  end
end