/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.report;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.internal.tasks.testing.junit.report.AllTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.CompositeTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.TestResult;

public class PackageTestResults
extends CompositeTestResults {
    private static final String DEFAULT_PACKAGE = "default-package";
    private final String name;
    private final Map<String, ClassTestResults> classes = new TreeMap<String, ClassTestResults>();

    public PackageTestResults(String name, AllTestResults model) {
        super(model);
        this.name = name.length() == 0 ? DEFAULT_PACKAGE : name;
    }

    @Override
    public String getTitle() {
        return this.name.equals(DEFAULT_PACKAGE) ? "Default package" : "Package " + this.name;
    }

    @Override
    public String getBaseUrl() {
        return "packages/" + this.name + ".html";
    }

    public String getName() {
        return this.name;
    }

    public Collection<ClassTestResults> getClasses() {
        return this.classes.values();
    }

    public TestResult addTest(long classId, String className, String testName, long duration) {
        ClassTestResults classResults = this.addClass(classId, className);
        return this.addTest(classResults.addTest(testName, duration));
    }

    public ClassTestResults addClass(long classId, String className) {
        ClassTestResults classResults = this.classes.get(className);
        if (classResults == null) {
            classResults = new ClassTestResults(classId, className, this);
            this.classes.put(className, classResults);
        }
        return classResults;
    }
}

