/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.cache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.internal.tasks.cache.TaskCacheKey;
import org.gradle.api.internal.tasks.cache.TaskOutputCache;
import org.gradle.api.internal.tasks.cache.TaskOutputReader;
import org.gradle.api.internal.tasks.cache.TaskOutputWriter;
import org.gradle.internal.io.StreamByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapBasedTaskOutputCache
implements TaskOutputCache {
    private final String description;
    private final ConcurrentMap<String, byte[]> delegate;

    public MapBasedTaskOutputCache(String description, ConcurrentMap<String, byte[]> delegate) {
        this.description = description;
        this.delegate = delegate;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean load(TaskCacheKey key, TaskOutputReader reader) throws IOException {
        byte[] bytes = (byte[])this.delegate.get(key.getHashCode());
        if (bytes == null) {
            return false;
        }
        reader.readFrom(new ByteArrayInputStream(bytes));
        return true;
    }

    @Override
    public void store(TaskCacheKey key, TaskOutputWriter output) throws IOException {
        StreamByteBuffer buffer = new StreamByteBuffer();
        output.writeTo(buffer.getOutputStream());
        this.delegate.put(key.getHashCode(), buffer.readAsByteArray());
    }
}

