/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.cache.TaskCacheKey;
import org.gradle.api.internal.tasks.cache.TaskOutputCache;
import org.gradle.api.internal.tasks.cache.TaskOutputPacker;
import org.gradle.api.internal.tasks.cache.TaskOutputReader;
import org.gradle.api.internal.tasks.cache.TaskOutputWriter;
import org.gradle.api.internal.tasks.cache.config.TaskCachingInternal;
import org.gradle.api.internal.tasks.execution.TaskOutputsGenerationListener;
import org.gradle.util.Clock;
import org.gradle.util.SingleMessageLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipCachedTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipCachedTaskExecuter.class);
    private final TaskCachingInternal taskCaching;
    private final StartParameter startParameter;
    private final TaskOutputPacker packer;
    private final TaskExecuter delegate;
    private TaskOutputCache cache;
    private final TaskOutputsGenerationListener taskOutputsGenerationListener;

    public SkipCachedTaskExecuter(TaskCachingInternal taskCaching, TaskOutputPacker packer, StartParameter startParameter, TaskOutputsGenerationListener taskOutputsGenerationListener, TaskExecuter delegate) {
        this.taskCaching = taskCaching;
        this.startParameter = startParameter;
        this.packer = packer;
        this.taskOutputsGenerationListener = taskOutputsGenerationListener;
        this.delegate = delegate;
        SingleMessageLogger.incubatingFeatureUsed((String)"Task output caching");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        TaskCacheKey cacheKey;
        TaskOutputsInternal taskOutputs;
        block19: {
            boolean cacheEnabled;
            final Clock clock = new Clock();
            taskOutputs = task.getOutputs();
            try {
                cacheEnabled = taskOutputs.isCacheEnabled();
            }
            catch (Exception t) {
                throw new GradleException(String.format("Could not evaluate TaskOutputs.cacheIf for %s.", task), (Throwable)t);
            }
            LOGGER.debug("Determining if {} is cached already", (Object)task);
            cacheKey = null;
            boolean cacheable = false;
            try {
                if (cacheEnabled) {
                    if (taskOutputs.hasDeclaredOutputs()) {
                        if (taskOutputs.isCacheAllowed()) {
                            cacheable = true;
                            TaskArtifactState taskState = context.getTaskArtifactState();
                            try {
                                cacheKey = taskState.calculateCacheKey();
                                LOGGER.info("Cache key for {} is {}", (Object)task, (Object)cacheKey);
                            }
                            catch (Exception e) {
                                throw new GradleException(String.format("Could not build cache key for %s.", task), (Throwable)e);
                            }
                            if (cacheKey != null) {
                                if (taskState.isAllowedToUseCachedResults()) {
                                    try {
                                        boolean found = this.getCache().load(cacheKey, new TaskOutputReader(){

                                            public void readFrom(InputStream input) throws IOException {
                                                SkipCachedTaskExecuter.this.packer.unpack(taskOutputs, input);
                                                LOGGER.info("Unpacked output for {} from cache (took {}).", (Object)task, (Object)clock.getTime());
                                            }
                                        });
                                        if (found) {
                                            state.setOutcome(TaskExecutionOutcome.FROM_CACHE);
                                            this.taskOutputsGenerationListener.beforeTaskOutputsGenerated();
                                            return;
                                        }
                                        break block19;
                                    }
                                    catch (Exception e) {
                                        LOGGER.warn("Could not load cached output for {} with cache key {}", new Object[]{task, cacheKey, e});
                                    }
                                    break block19;
                                }
                                LOGGER.info("Not loading {} from cache because loading from cache is disabled", (Object)task);
                                break block19;
                            }
                            LOGGER.info("Not caching {} because no valid cache key was generated", (Object)task);
                            break block19;
                        }
                        LOGGER.info("Not caching {} because it declares multiple output files for a single output property via `@OutputFiles`, `@OutputDirectories` or `TaskOutputs.files()`", (Object)task);
                        break block19;
                    }
                    LOGGER.info("Not caching {} as task has declared no outputs", (Object)task);
                    break block19;
                }
                LOGGER.debug("Not caching {} as task output is not cacheable.", (Object)task);
            }
            finally {
                state.setCacheable(cacheable);
            }
        }
        this.delegate.execute(task, state, context);
        if (cacheKey != null && state.getFailure() == null) {
            try {
                this.getCache().store(cacheKey, new TaskOutputWriter(){

                    public void writeTo(OutputStream output) throws IOException {
                        SkipCachedTaskExecuter.this.packer.pack(taskOutputs, output);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.warn("Could not cache results for {} for cache key {}", new Object[]{task, cacheKey, e});
            }
        }
    }

    private TaskOutputCache getCache() {
        if (this.cache == null) {
            this.cache = this.taskCaching.getCacheFactory().createCache(this.startParameter);
            LOGGER.info("Using {}", (Object)this.cache.getDescription());
        }
        return this.cache;
    }
}

