/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.ThreeState;
import org.jetbrains.kotlin.com.intellij.util.xmlb.BasePrimitiveBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.BeanBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Binding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import org.jetbrains.kotlin.org.jdom.Element;

public final class SkipDefaultsSerializationFilter
extends SkipDefaultValuesSerializationFilters {
    boolean equal(@NotNull Binding binding, @NotNull Object bean) {
        if (binding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binding", "org/jetbrains/kotlin/com/intellij/util/xmlb/SkipDefaultsSerializationFilter", "equal"));
        }
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "org/jetbrains/kotlin/com/intellij/util/xmlb/SkipDefaultsSerializationFilter", "equal"));
        }
        MutableAccessor accessor = binding.getAccessor();
        return this.equal(binding, accessor.read(bean), accessor.read(this.getDefaultBean(bean)));
    }

    boolean equal(@Nullable Binding binding, @Nullable Object currentValue, @Nullable Object defaultValue) {
        Binding referencedBinding;
        if (defaultValue instanceof Element && currentValue instanceof Element) {
            return JDOMUtil.areElementsEqual((Element)currentValue, (Element)defaultValue);
        }
        if (currentValue == defaultValue) {
            return true;
        }
        if (currentValue == null || defaultValue == null) {
            return false;
        }
        if (binding instanceof BasePrimitiveBinding && (referencedBinding = ((BasePrimitiveBinding)binding).myBinding) instanceof BeanBinding) {
            BeanBinding classBinding = (BeanBinding)referencedBinding;
            ThreeState compareByFields = classBinding.compareByFields;
            if (compareByFields == ThreeState.UNSURE) {
                classBinding.compareByFields = compareByFields = ReflectionUtil.getDeclaredMethod(classBinding.myBeanClass, "equals", Object.class) == null ? ThreeState.YES : ThreeState.NO;
            }
            if (compareByFields == ThreeState.YES) {
                return classBinding.equalByFields(currentValue, defaultValue, this);
            }
        }
        return Comparing.equal(currentValue, defaultValue);
    }
}

