/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.io.URLUtil;

public class KotlinVfsUtil {
    @NotNull
    public static String convertFromUrl(@NotNull URL url) throws MalformedURLException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/utils/KotlinVfsUtil", "convertFromUrl"));
        }
        String protocol = url.getProtocol();
        String path = url.getPath();
        if ("jar".equals(protocol)) {
            if (StringUtil.startsWithConcatenationOf(path, "file", ":")) {
                URL subURL = new URL(path);
                path = subURL.getPath();
            } else {
                throw new MalformedURLException("Can't parse url: " + url.toExternalForm());
            }
        }
        if (SystemInfo.isWindows || SystemInfo.isOS2) {
            while (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1, path.length());
            }
        }
        path = URLUtil.unescapePercentSequences(path);
        String string = protocol + "://" + path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/KotlinVfsUtil", "convertFromUrl"));
        }
        return string;
    }

    private KotlinVfsUtil() {
    }
}

