/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.tasks.api.internal;

import java.util.Set;
import java.util.regex.Pattern;
import org.gradle.jvm.tasks.api.internal.ApiMemberSelector;
import org.gradle.jvm.tasks.api.internal.MethodStubbingApiMemberAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ApiClassExtractor {
    private static final Pattern LOCAL_CLASS_PATTERN = Pattern.compile(".+\\$[0-9]+(?:[\\p{Alnum}_$]+)?$");
    private final Set<String> exportedPackages;
    private final boolean apiIncludesPackagePrivateMembers;

    public ApiClassExtractor(Set<String> exportedPackages) {
        this.exportedPackages = exportedPackages.isEmpty() ? null : exportedPackages;
        this.apiIncludesPackagePrivateMembers = exportedPackages.isEmpty();
    }

    public boolean shouldExtractApiClassFrom(ClassReader originalClassReader) {
        if (!ApiMemberSelector.isCandidateApiMember(originalClassReader.getAccess(), this.apiIncludesPackagePrivateMembers)) {
            return false;
        }
        String originalClassName = originalClassReader.getClassName();
        if (ApiClassExtractor.isLocalClass(originalClassName)) {
            return false;
        }
        return this.exportedPackages == null || this.exportedPackages.contains(ApiClassExtractor.packageNameOf(originalClassName));
    }

    public byte[] extractApiClassFrom(ClassReader originalClassReader) {
        ClassWriter apiClassWriter = new ClassWriter(1);
        originalClassReader.accept((ClassVisitor)new ApiMemberSelector(new MethodStubbingApiMemberAdapter(apiClassWriter), this.apiIncludesPackagePrivateMembers), 6);
        return apiClassWriter.toByteArray();
    }

    private static String packageNameOf(String internalClassName) {
        int packageSeparatorIndex = internalClassName.lastIndexOf(47);
        return packageSeparatorIndex > 0 ? internalClassName.substring(0, packageSeparatorIndex).replace('/', '.') : "";
    }

    private static boolean isLocalClass(String className) {
        return LOCAL_CLASS_PATTERN.matcher(className).matches();
    }
}

