/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.inet;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InetAddresses {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<InetAddress> loopback = new ArrayList<InetAddress>();
    private List<InetAddress> remote = new ArrayList<InetAddress>();
    private List<NetworkInterface> multicastInterfaces = new ArrayList<NetworkInterface>();

    InetAddresses() throws SocketException {
        this.analyzeNetworkInterfaces();
        if (this.multicastInterfaces.isEmpty()) {
            this.useMulticastFallback();
        }
    }

    private void analyzeNetworkInterfaces() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            this.analyzeNetworkInterface(interfaces.nextElement());
        }
    }

    private void analyzeNetworkInterface(NetworkInterface networkInterface) {
        this.logger.debug("Adding IP addresses for network interface {}", (Object)networkInterface.getDisplayName());
        try {
            boolean isLoopbackInterface = networkInterface.isLoopback();
            this.logger.debug("Is this a loopback interface? {}", (Object)isLoopbackInterface);
            boolean isMulticast = networkInterface.supportsMulticast();
            this.logger.debug("Is this a multicast interface? {}", (Object)isMulticast);
            boolean isRemote = false;
            Enumeration<InetAddress> candidates = networkInterface.getInetAddresses();
            while (candidates.hasMoreElements()) {
                InetAddress candidate = candidates.nextElement();
                if (isLoopbackInterface) {
                    if (candidate.isLoopbackAddress()) {
                        this.logger.debug("Adding loopback address {}", (Object)candidate);
                        this.loopback.add(candidate);
                        continue;
                    }
                    this.logger.debug("Ignoring remote address on loopback interface {}", (Object)candidate);
                    continue;
                }
                if (candidate.isLoopbackAddress()) {
                    this.logger.debug("Ignoring loopback address on remote interface {}", (Object)candidate);
                    continue;
                }
                this.logger.debug("Adding remote address {}", (Object)candidate);
                this.remote.add(candidate);
                isRemote = true;
            }
            if (isMulticast) {
                if (isRemote) {
                    this.logger.debug("Adding remote multicast interface {}", (Object)networkInterface.getDisplayName());
                    this.multicastInterfaces.add(0, networkInterface);
                } else {
                    this.logger.debug("Adding loopback multicast interface {}", (Object)networkInterface.getDisplayName());
                    this.multicastInterfaces.add(networkInterface);
                }
            }
        }
        catch (SocketException e) {
            this.logger.warn("Error while querying interface {} for IP addresses", (Object)networkInterface, (Object)e);
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("Could not determine the IP addresses for network interface %s", networkInterface.getName()), e);
        }
    }

    private void useMulticastFallback() throws SocketException {
        this.logger.debug("No multicast interfaces, using fallbacks");
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            this.multicastInterfaces.add(networkInterfaces.nextElement());
        }
    }

    public List<InetAddress> getLoopback() {
        return this.loopback;
    }

    public List<InetAddress> getRemote() {
        return this.remote;
    }

    public List<NetworkInterface> getMulticastInterfaces() {
        return this.multicastInterfaces;
    }
}

