/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.ArrayDeque;
import java.util.Iterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.SubtypePathNode;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckingProcedureCallbacks;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KotlinType findCorrespondingSupertype(@NotNull KotlinType subtype, @NotNull KotlinType supertype, @NotNull TypeCheckingProcedureCallbacks typeCheckingProcedureCallbacks) {
        Intrinsics.checkParameterIsNotNull((Object)subtype, (String)"subtype");
        Intrinsics.checkParameterIsNotNull((Object)supertype, (String)"supertype");
        Intrinsics.checkParameterIsNotNull((Object)typeCheckingProcedureCallbacks, (String)"typeCheckingProcedureCallbacks");
        ArrayDeque<SubtypePathNode> queue = new ArrayDeque<SubtypePathNode>();
        queue.add(new SubtypePathNode(subtype, null));
        TypeConstructor supertypeConstructor = supertype.getConstructor();
        while (!queue.isEmpty()) {
            SubtypePathNode lastPathNode = (SubtypePathNode)queue.poll();
            KotlinType currentSubtype = lastPathNode.getType();
            TypeConstructor constructor = currentSubtype.getConstructor();
            if (typeCheckingProcedureCallbacks.assertEqualTypeConstructors(constructor, supertypeConstructor)) {
                KotlinType substituted = currentSubtype;
                boolean isAnyMarkedNullable = currentSubtype.isMarkedNullable();
                for (SubtypePathNode currentPathNode = lastPathNode.getPrevious(); currentPathNode != null; currentPathNode = currentPathNode.getPrevious()) {
                    boolean bl;
                    KotlinType currentType;
                    block8: {
                        void $receiver$iv;
                        currentType = currentPathNode.getType();
                        Iterable iterable = currentType.getArguments();
                        for (Object element$iv : $receiver$iv) {
                            TypeProjection it = (TypeProjection)element$iv;
                            if (!(Intrinsics.areEqual((Object)((Object)it.getProjectionKind()), (Object)((Object)Variance.INVARIANT)) ^ true)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                    if (bl) {
                        substituted = UtilsKt.approximate(CapturedTypeConstructorKt.wrapWithCapturingSubstitution$default(TypeConstructorSubstitution.Companion.create(currentType), false, 1, null).buildSubstitutor().safeSubstitute(substituted, Variance.INVARIANT));
                    } else {
                        Intrinsics.checkExpressionValueIsNotNull((Object)TypeConstructorSubstitution.Companion.create(currentType).buildSubstitutor().safeSubstitute(substituted, Variance.INVARIANT), (String)"TypeConstructorSubstitut\u2026uted, Variance.INVARIANT)");
                    }
                    isAnyMarkedNullable = isAnyMarkedNullable || currentType.isMarkedNullable();
                }
                if (!typeCheckingProcedureCallbacks.assertEqualTypeConstructors(substituted.getConstructor(), supertypeConstructor)) {
                    throw (Throwable)((Object)new AssertionError((Object)("Type constructors should be equals!" + ("substitutedSuperType: " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(substituted) + ", ") + ("foundSupertype: " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(currentSubtype) + ", ") + ("supertype: " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(supertype)))));
                }
                return TypeUtils.makeNullableAsSpecified(substituted, isAnyMarkedNullable);
            }
            Iterator<KotlinType> iterator2 = constructor.getSupertypes().iterator();
            while (iterator2.hasNext()) {
                KotlinType immediateSupertype;
                KotlinType kotlinType = immediateSupertype = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"immediateSupertype");
                queue.add(new SubtypePathNode(kotlinType, lastPathNode));
            }
        }
        return null;
    }

    private static final KotlinType approximate(@NotNull KotlinType $receiver) {
        return CapturedTypeApproximationKt.approximateCapturedTypes($receiver).getUpper();
    }
}

