/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc.version;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.nativeplatform.toolchain.internal.gcc.version.CompilerMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.gcc.version.GccVersionDeterminer;
import org.gradle.nativeplatform.toolchain.internal.gcc.version.GccVersionResult;
import org.gradle.process.internal.ExecActionFactory;

public class CompilerMetaDataProviderFactory {
    private final CachingCompilerMetaDataProvider gcc;
    private final CachingCompilerMetaDataProvider clang;

    public CompilerMetaDataProviderFactory(ExecActionFactory execActionFactory) {
        this.gcc = new CachingCompilerMetaDataProvider(GccVersionDeterminer.forGcc(execActionFactory));
        this.clang = new CachingCompilerMetaDataProvider(GccVersionDeterminer.forClang(execActionFactory));
    }

    public CompilerMetaDataProvider gcc() {
        return this.gcc;
    }

    public CompilerMetaDataProvider clang() {
        return this.clang;
    }

    private static class Key {
        final File gccBinary;
        final List<String> args;

        private Key(File gccBinary, List<String> args) {
            this.gccBinary = gccBinary;
            this.args = args;
        }

        public boolean equals(Object obj) {
            Key other = (Key)obj;
            return other.gccBinary.equals(this.gccBinary) && other.args.equals(this.args);
        }

        public int hashCode() {
            return this.gccBinary.hashCode() ^ this.args.hashCode();
        }
    }

    private static class CachingCompilerMetaDataProvider
    implements CompilerMetaDataProvider {
        private final CompilerMetaDataProvider delegate;
        private final Map<Key, GccVersionResult> resultMap = new HashMap<Key, GccVersionResult>();

        private CachingCompilerMetaDataProvider(CompilerMetaDataProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public GccVersionResult getGccMetaData(File gccBinary, List<String> additionalArgs) {
            Key key = new Key(gccBinary, additionalArgs);
            GccVersionResult result = this.resultMap.get(key);
            if (result == null) {
                result = this.delegate.getGccMetaData(gccBinary, additionalArgs);
                this.resultMap.put(key, result);
            }
            return result;
        }
    }
}

