/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.api.Transformer;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.HasCompatibilityMapping;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.parameters.BuildCancellationTokenAdapter;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalCancellableConnection;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.model.internal.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancellableModelBuilderBackedModelProducer
extends HasCompatibilityMapping
implements ModelProducer {
    protected final ProtocolToModelAdapter adapter;
    protected final VersionDetails versionDetails;
    protected final ModelMapping modelMapping;
    private final InternalCancellableConnection builder;
    protected final Transformer<RuntimeException, RuntimeException> exceptionTransformer;

    public CancellableModelBuilderBackedModelProducer(ProtocolToModelAdapter adapter, VersionDetails versionDetails, ModelMapping modelMapping, InternalCancellableConnection builder, Transformer<RuntimeException, RuntimeException> exceptionTransformer) {
        super(versionDetails);
        this.adapter = adapter;
        this.versionDetails = versionDetails;
        this.modelMapping = modelMapping;
        this.builder = builder;
        this.exceptionTransformer = exceptionTransformer;
    }

    @Override
    public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
        BuildResult<?> result;
        if (!this.versionDetails.maySupportModel(type)) {
            throw Exceptions.unsupportedModel(type, this.versionDetails.getVersion());
        }
        ModelIdentifier modelIdentifier = this.modelMapping.getModelIdentifierFromModelType(type);
        try {
            result = this.builder.getModel(modelIdentifier, new BuildCancellationTokenAdapter(operationParameters.getCancellationToken()), operationParameters);
        }
        catch (InternalUnsupportedModelException e) {
            throw Exceptions.unknownModel(type, e);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)this.exceptionTransformer.transform((Object)e);
        }
        return this.applyCompatibilityMapping(this.adapter.builder(type), operationParameters).build(result.getModel());
    }
}

