/*! grafana - v3.1.0 - 2016-07-18
 * Copyright (c) 2016 Torkel Ödegaard; Licensed Apache-2.0 */

System.register(["test/lib/common","app/core/table_model","../renderer"],function(a){var b,c,d;return{setters:[function(a){b=a},function(a){c=a},function(a){d=a}],execute:function(){b.describe("when rendering table",function(){b.describe("given 2 columns",function(){var a=new c["default"];a.columns=[{text:"Time"},{text:"Value"},{text:"Colored"},{text:"Undefined"},{text:"String"},{text:"United",unit:"bps"},{text:"Sanitized"}];var e={pageSize:10,styles:[{pattern:"Time",type:"date",format:"LLL"},{pattern:"Value",type:"number",unit:"ms",decimals:3},{pattern:"Colored",type:"number",unit:"none",decimals:1,colorMode:"value",thresholds:[50,80],colors:["green","orange","red"]},{pattern:"String",type:"string"},{pattern:"United",type:"number",unit:"ms",decimals:2},{pattern:"Sanitized",type:"string",sanitize:!0}]},f=function(a){return"sanitized"},g=new d.TableRenderer(e,a,"utc",f);b.it("time column should be formated",function(){var a=g.renderCell(0,1388556366666);b.expect(a).to.be("<td>2014-01-01T06:06:06+00:00</td>")}),b.it("number column with unit specified should ignore style unit",function(){var a=g.renderCell(5,1230);b.expect(a).to.be("<td>1.23 kbps</td>")}),b.it("number column should be formated",function(){var a=g.renderCell(1,1230);b.expect(a).to.be("<td>1.230 s</td>")}),b.it("number style should ignore string values",function(){var a=g.renderCell(1,"asd");b.expect(a).to.be("<td>asd</td>")}),b.it("colored cell should have style",function(){var a=g.renderCell(2,40);b.expect(a).to.be('<td style="color:green">40.0</td>')}),b.it("colored cell should have style",function(){var a=g.renderCell(2,55);b.expect(a).to.be('<td style="color:orange">55.0</td>')}),b.it("colored cell should have style",function(){var a=g.renderCell(2,85);b.expect(a).to.be('<td style="color:red">85.0</td>')}),b.it("unformated undefined should be rendered as string",function(){var a=g.renderCell(3,"value");b.expect(a).to.be("<td>value</td>")}),b.it("string style with escape html should return escaped html",function(){var a=g.renderCell(4,"&breaking <br /> the <br /> row");b.expect(a).to.be("<td>&amp;breaking &lt;br /&gt; the &lt;br /&gt; row</td>")}),b.it("undefined formater should return escaped html",function(){var a=g.renderCell(3,"&breaking <br /> the <br /> row");b.expect(a).to.be("<td>&amp;breaking &lt;br /&gt; the &lt;br /&gt; row</td>")}),b.it("undefined value should render as -",function(){var a=g.renderCell(3,void 0);b.expect(a).to.be("<td></td>")}),b.it("sanitized value should render as",function(){var a=g.renderCell(6,'text <a href="http://google.com">link</a>');b.expect(a).to.be("<td>sanitized</td>")})})})}}});