/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openscience.jmol.app.nbo.NBODialogConfig;
import org.openscience.jmol.app.nbo.NBODialogRun;

abstract class NBODialogView
extends NBODialogRun {
    protected static final String[] basSet = new String[]{"AO", "PNAO", "NAO", "PNHO", "NHO", "PNBO", "NBO", "PNLMO", "NLMO", "MO"};
    protected int keywordNumber = 6;
    protected JLabel vLab;
    protected JLabel pLab;
    protected JButton goBtn2;
    protected JButton btnShow;
    protected JButton btnView3D;
    protected JRadioButton btnProf;
    protected boolean oneD = true;
    protected boolean inLobes = true;
    protected JComboBox<String> list;
    protected JComboBox<String> basis;
    protected Hashtable<String, String[]> lists;
    protected int viewState;
    protected boolean positiveSign;
    protected Box orbBox;
    protected Box profBox;
    protected Box dispBox;
    protected JPanel selectPanel;
    protected final JTextField[] vectorFields = new JTextField[8];
    protected final String[] vectorFieldIDs;
    protected final JTextField[] planeFields;
    protected final String[] planeFieldIDs;
    protected final JTextField[] camFields;
    String[] camFieldIDs;
    protected final JTextField[] contourFields;
    protected final String[] contourFieldIDs;
    protected DefaultListModel<String> model;
    protected JList<String> dList;
    protected int numStor;
    protected static final int VIEW_STATE_MAIN = 0;
    protected static final int VIEW_STATE_PLANE = 1;
    protected static final int VIEW_STATE_VECTOR = 2;
    protected static final int VIEW_STATE_CAMERA = 3;
    protected int iLast;
    protected int iLastD;
    private int viewVectorPt;
    private int viewPlanePt;

    private String getVectorParams() {
        String s = "";
        for (int i = 0; i < this.vectorFields.length; ++i) {
            s = s + "GLOBAL VECTOR_" + this.planeFieldIDs[i] + " " + this.vectorFields[i].getText() + sep;
        }
        return s;
    }

    private String getPlaneParams() {
        String s = "";
        for (int i = 0; i < this.planeFields.length; ++i) {
            s = s + "GLOBAL PLANE_" + this.planeFieldIDs[i] + " " + this.planeFields[i].getText() + sep;
        }
        return s;
    }

    private String getCameraParams() {
        String s = "";
        for (int i = 0; i < this.camFields.length; ++i) {
            s = s + "GLOBAL CAMERA_" + this.camFieldIDs[i] + " " + this.camFields[i].getText() + sep;
        }
        s = s + "GLOBAL CAMERA_6 " + (this.inLobes ? 0 : 1) + sep;
        return s;
    }

    private String getContourParams() {
        String s = "";
        for (int i = 0; i < this.contourFields.length; ++i) {
            s = s + "GLOBAL CONTOUR_" + this.contourFieldIDs[i] + " " + this.contourFields[i].getText() + sep;
        }
        return s;
    }

    protected NBODialogView(JFrame f) {
        super(f);
        int i;
        String[] vecVal = new String[]{"1", "2", "0.5", "-2.0", "2.0", "-1.0", "1.0", "100"};
        for (i = 0; i < this.vectorFields.length; ++i) {
            this.vectorFields[i] = new JTextField(vecVal[i]);
        }
        this.vectorFieldIDs = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};
        this.planeFields = new JTextField[12];
        String[] plVal = new String[]{"1", "2", "3", "0.5", "0.0", "0.0", "0.0", "-3.0", "3.0", "-3.0", "3.0", "25"};
        for (i = 0; i < this.planeFields.length; ++i) {
            this.planeFields[i] = new JTextField(plVal[i]);
        }
        this.planeFieldIDs = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l"};
        this.camFields = new JTextField[52];
        String[] camVal = new String[]{"6.43", "0.0", "0.0", "50.0", "2.0", "2.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.5", "1.0", "1.0", "1.0", "0.8", "0.0", "0.0", "1.0", "0.8", "0.4", "0.0", "1.0", "1.0", "0.5", "0.5", "0.5", "0.0", "0.7", "1.0", "0.22", "0.40", "0.10", "0.05", "0.0316", "0.0001", "0.4000"};
        for (i = 0; i < this.camFields.length; ++i) {
            this.camFields[i] = new JTextField(camVal[i]);
        }
        this.camFieldIDs = new String[]{"1a", "1b", "1c", "1d", "1e", "1f", "1g", "2a", "2b", "2c", "2d", "2e", "2f", "2g", "2h", "2i", "2j", "2k", "2l", "2m", "2n", "2o", "2p", "2q", "2r", "2s", "2t", "3a", "3b", "3c", "3d", "3e", "3f", "3g", "3h", "3i", "3j", "3k", "3l", "3m", "3n", "3o", "3p", "3q", "3r", "4a", "4b", "4c", "4d", "5a", "5b", "5c"};
        this.contourFields = new JTextField[7];
        String[] contVal = new String[]{"0.03", "0.05", "4", "0.05", "0.05", "0.10", "0.10"};
        for (i = 0; i < this.contourFields.length; ++i) {
            this.contourFields[i] = new JTextField(contVal[i]);
        }
        this.contourFieldIDs = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};
        this.numStor = 0;
        this.iLast = -1;
        this.iLastD = -1;
        this.viewVectorPt = 0;
        this.viewPlanePt = 0;
    }

    protected void buildView(Container p) {
        this.viewState = 0;
        p.removeAll();
        p.setLayout(new BorderLayout());
        p.add((Component)this.topPanel, "First");
        JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)this.modelOut(), "Center");
        JPanel jp2 = new JPanel(new BorderLayout());
        jp2.add(this.profileBox(), "Center");
        JLabel lab = new JLabel("Settings");
        lab.setOpaque(true);
        lab.setBackground(Color.black);
        lab.setForeground(Color.white);
        lab.setFont(this.nboFont);
        jp2.add((Component)lab, "North");
        jp.add((Component)jp2, "North");
        JSplitPane sp = new JSplitPane(1, this.select(), jp);
        sp.setDividerLocation(350);
        p.add((Component)sp, "Center");
        p.add((Component)this.statusPanel, "Last");
        this.tfExt.setText("31");
        this.tfExt.setEditable(false);
        if (this.isJmolNBO) {
            this.basis.setSelectedIndex(5);
        }
    }

    protected JPanel select() {
        this.selectPanel = new JPanel();
        this.selectPanel.setLayout(new BoxLayout(this.selectPanel, 1));
        this.selectPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        Box box = Box.createHorizontalBox();
        JLabel title = new JLabel(" Select Job ");
        title.setAlignmentX(0.0f);
        title.setBackground(titleColor);
        title.setForeground(Color.white);
        title.setFont(titleFont);
        title.setOpaque(true);
        Box box2 = Box.createVerticalBox();
        box2.add(title);
        box.setAlignmentX(0.0f);
        box2.setAlignmentX(0.0f);
        box2.add(box);
        box.add(this.folderBox());
        box.setBorder(BorderFactory.createLineBorder(Color.black));
        box.setMaximumSize(new Dimension(355, 65));
        this.selectPanel.add(box2);
        this.orbBox = Box.createVerticalBox();
        this.orbBox.setAlignmentX(0.0f);
        title = new JLabel(" Select Orbital ");
        title.setAlignmentX(0.0f);
        title.setBackground(titleColor);
        title.setForeground(Color.white);
        title.setFont(titleFont);
        title.setOpaque(true);
        this.orbBox.add(title);
        Box b2 = Box.createVerticalBox();
        b2.setAlignmentX(0.0f);
        this.orbBox.add(b2);
        Box b = Box.createHorizontalBox();
        final DefaultComboBoxModel listModel = new DefaultComboBoxModel();
        this.basis = new JComboBox<String>(basSet);
        this.basis.setMaximumSize(new Dimension(70, 25));
        this.basis.setUI(new NBODialogConfig.StyledComboBoxUI(180, -1));
        b.add(this.basis);
        this.basis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.basisSel(listModel);
            }
        });
        this.list = new JComboBox(listModel);
        this.list.setFont(this.nboFont);
        this.list.setMaximumSize(new Dimension(270, 25));
        this.list.setAlignmentX(0.5f);
        this.list.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = NBODialogView.this.list.getSelectedIndex();
                if (i < 1) {
                    NBODialogView.this.nboService.runScriptQueued("nbo delete; mo delete");
                    return;
                }
                NBODialogView.this.profBox.setVisible(true);
                NBODialogView.this.showOrbJmol(NBODialogView.this.basis.getSelectedItem().toString(), NBODialogView.this.list.getSelectedIndex());
                if (NBODialogView.this.nboView) {
                    NBODialogView.this.nboService.runScriptQueued("nbo color yellow [134,254,253]; nbo fill nomesh translucent 0.3");
                }
            }
        });
        this.list.setUI(new NBODialogConfig.StyledComboBoxUI(125, -1));
        b.add(this.list);
        b.setAlignmentX(0.0f);
        b2.add(b);
        b = Box.createHorizontalBox();
        b.add(new JLabel("Basis"));
        b.add(Box.createRigidArea(new Dimension(50, 0)));
        b.add(new JLabel("Orbital"));
        b.setAlignmentX(0.0f);
        b2.add(b);
        b2.setBorder(BorderFactory.createLineBorder(Color.black));
        this.selectPanel.add(this.orbBox);
        this.orbBox.setMaximumSize(new Dimension(355, 65));
        this.orbBox.setVisible(this.isJmolNBO);
        int j = this.iLast;
        this.iLast = -1;
        if (j > 0 && j < this.list.getComponentCount()) {
            j = 0;
        }
        this.profBox = Box.createVerticalBox();
        this.profBox.setAlignmentX(0.0f);
        title = new JLabel(" Select Image Type ");
        title.setAlignmentX(0.0f);
        title.setBackground(titleColor);
        title.setForeground(Color.white);
        title.setFont(titleFont);
        title.setOpaque(true);
        this.profBox.add(title);
        b = Box.createHorizontalBox();
        b.setAlignmentX(0.0f);
        this.profBox.add(b);
        b.add(Box.createRigidArea(new Dimension(75, 0)));
        JButton btn = new JButton("2D Contour");
        b.add(btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.oneD = false;
                NBODialogView.this.viewState = 1;
                NBODialogView.this.goViewClicked();
            }
        });
        btn = new JButton("1D Profile");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.oneD = true;
                NBODialogView.this.viewState = 2;
                NBODialogView.this.goViewClicked();
            }
        });
        b.add(btn);
        b.add(Box.createRigidArea(new Dimension(75, 0)));
        this.profBox.setVisible(false);
        this.selectPanel.add(this.profBox);
        this.dispBox();
        return this.selectPanel;
    }

    protected void dispBox() {
        if (this.dispBox != null) {
            this.selectPanel.remove(this.dispBox);
        }
        this.dispBox = Box.createVerticalBox();
        JLabel title = new JLabel(" Select Image Type ");
        title.setAlignmentX(0.0f);
        title.setBackground(titleColor);
        title.setForeground(Color.white);
        title.setFont(titleFont);
        title.setOpaque(true);
        this.dispBox.add(title);
        this.dispBox.setAlignmentX(0.0f);
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        this.dispBox.setVisible(this.numStor > 0);
        Box box2 = Box.createVerticalBox();
        this.btnShow = new JButton("1D/2D");
        this.btnShow.setFont(this.nboFont);
        this.btnShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        box2.add(this.btnShow);
        this.btnView3D = new JButton("3D");
        this.btnView3D.setFont(this.nboFont);
        this.btnView3D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.view3D();
            }
        });
        box2.add(this.btnView3D);
        JScrollPane sp = new JScrollPane();
        this.model = new DefaultListModel();
        for (int i = 1; i < 10; ++i) {
            this.model.addElement("" + i + ")");
        }
        this.dList = new JList<String>(this.model);
        this.dList.setFont(this.nboFont);
        this.dList.setSelectionMode(2);
        this.dList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int i = NBODialogView.this.dList.getSelectedIndex();
                System.out.println("-----------------------" + NBODialogView.this.iLastD + " " + i);
                if (i == -1) {
                    return;
                }
                NBODialogView.this.showOrbJmol(NBODialogView.this.dList);
                if (NBODialogView.this.nboView) {
                    NBODialogView.this.nboService.runScriptQueued("nbo color yellow [181,229,255]; nbo fill nomesh translucent 0.3");
                }
            }
        });
        sp.getViewport().add(this.dList);
        this.dList.setBackground(new Color(245, 245, 220));
        sp.setHorizontalScrollBarPolicy(32);
        sp.setPreferredSize(new Dimension(200, 280));
        box.add(sp);
        box.setMaximumSize(new Dimension(350, 230));
        box.add(box2);
        box.setBorder(BorderFactory.createLineBorder(Color.black));
        this.dispBox.add(box);
        this.selectPanel.add(this.dispBox);
        this.selectPanel.repaint();
        this.selectPanel.revalidate();
    }

    private Component profileBox() {
        JPanel p = new JPanel(new GridLayout(4, 2));
        JButton btnVec = new JButton("Axis");
        JButton btnPla = new JButton("Plane");
        this.vLab = new JLabel("1, 2");
        p.add(btnVec);
        btnVec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.vector();
            }
        });
        p.add(this.vLab).setFont(this.nboFont);
        p.add(btnPla);
        btnPla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.plane();
            }
        });
        this.pLab = new JLabel("1, 2, 3");
        p.add(this.pLab).setFont(this.nboFont);
        JButton btnSign = new JButton("Sign");
        p.add(btnSign);
        final JLabel sLab = new JLabel(" +");
        this.positiveSign = true;
        btnSign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (sLab.getText().trim().equals("+")) {
                    NBODialogView.this.positiveSign = true;
                    sLab.setText(" -");
                } else {
                    sLab.setText(" +");
                    NBODialogView.this.positiveSign = false;
                }
            }
        });
        p.add(sLab).setFont(new Font("Monospaced", 1, 20));
        JButton btnStip = new JButton("Lines");
        p.add(btnStip);
        btnStip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.stip();
            }
        });
        JButton btnCam = new JButton("Camera");
        p.add(btnCam);
        btnCam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.cam1();
            }
        });
        return p;
    }

    protected void plane() {
        this.viewPlanePt = 0;
        final JDialog plane = new JDialog(this, "Definition of Plane:", false);
        plane.setLayout(new BorderLayout());
        plane.setMinimumSize(new Dimension(300, 300));
        this.centerDialog(plane);
        JPanel labs = new JPanel(new GridLayout(7, 1, 5, 0));
        labs.add(new JLabel("Enter or select three atoms:"));
        labs.add(new JLabel("Enter fraction to locate origin:"));
        labs.add(new JLabel("Enter two rotation angles:"));
        labs.add(new JLabel("Enter shift of plane along normal:"));
        labs.add(new JLabel("Enter min and max X values:"));
        labs.add(new JLabel("Enter min and max Y values:"));
        labs.add(new JLabel("Enter number of steps NX:"));
        plane.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(7, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        bo.add(this.planeFields[0]);
        bo.add(this.planeFields[1]);
        bo.add(this.planeFields[2]);
        in.add(bo);
        in.add(this.planeFields[3]);
        bo = Box.createHorizontalBox();
        bo.add(this.planeFields[4]);
        bo.add(this.planeFields[5]);
        in.add(bo);
        in.add(this.planeFields[6]);
        bo = Box.createHorizontalBox();
        bo.add(this.planeFields[7]);
        bo.add(this.planeFields[8]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.planeFields[9]);
        bo.add(this.planeFields[10]);
        in.add(bo);
        in.add(this.planeFields[11]);
        plane.add((Component)in, "Center");
        JButton b = new JButton("OK");
        plane.add((Component)b, "South");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.pLab.setText(NBODialogView.this.planeFields[0].getText() + ", " + NBODialogView.this.planeFields[1].getText() + ", " + NBODialogView.this.planeFields[2].getText());
                plane.dispose();
                NBODialogView.this.viewState = 0;
            }
        });
        plane.setVisible(true);
    }

    protected void vector() {
        this.viewVectorPt = 0;
        final JDialog vect = new JDialog(this, "Definition of Vector:", false);
        vect.setLayout(new BorderLayout());
        vect.setMinimumSize(new Dimension(300, 250));
        this.centerDialog(vect);
        JPanel labs = new JPanel(new GridLayout(5, 1, 5, 0));
        labs.add(new JLabel("Enter or select two atom numbers:"));
        labs.add(new JLabel("Enter fraction to locate origin:"));
        labs.add(new JLabel("Enter min and max X values:"));
        labs.add(new JLabel("Enter min and max function values:"));
        labs.add(new JLabel("Enter number of steps NX:"));
        vect.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(5, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        bo.add(this.vectorFields[0]);
        bo.add(this.vectorFields[1]);
        in.add(bo);
        in.add(this.vectorFields[2]);
        bo = Box.createHorizontalBox();
        bo.add(this.vectorFields[3]);
        bo.add(this.vectorFields[4]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.vectorFields[5]);
        bo.add(this.vectorFields[6]);
        in.add(bo);
        in.add(this.vectorFields[7]);
        vect.add((Component)in, "Center");
        JButton b = new JButton("OK");
        vect.add((Component)b, "South");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.vLab.setText(NBODialogView.this.vectorFields[0].getText() + ", " + NBODialogView.this.vectorFields[1].getText());
                vect.dispose();
                NBODialogView.this.viewState = 0;
            }
        });
        vect.setVisible(true);
    }

    protected void cam1() {
        this.viewState = 3;
        final JDialog cam1 = new JDialog(this, "Camera and Light-Source:", false);
        cam1.setLayout(new BorderLayout());
        cam1.setMinimumSize(new Dimension(350, 200));
        cam1.setVisible(true);
        this.centerDialog(cam1);
        JPanel labs = new JPanel(new GridLayout(4, 1, 5, 0));
        labs.add(new JLabel("Camera distance from screen center:"));
        labs.add(new JLabel("Two rotation angles (about X, Y):"));
        labs.add(new JLabel("Camera view angle:"));
        labs.add(new JLabel("Lighting (RL, UD, BF w.r.t. camera):"));
        cam1.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(4, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        in.add(this.camFields[0]);
        bo.add(this.camFields[1]);
        bo.add(this.camFields[2]);
        in.add(this.camFields[3]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[4]);
        bo.add(this.camFields[5]);
        bo.add(this.camFields[6]);
        in.add(bo);
        cam1.add((Component)in, "Center");
        JButton b = new JButton("OK");
        cam1.add((Component)b, "South");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cam1.dispose();
                NBODialogView.this.cam2();
            }
        });
    }

    protected void cam2() {
        final JDialog cam2 = new JDialog(this, "Surface Optical Parameters:", false);
        cam2.setLayout(new BorderLayout());
        cam2.setMinimumSize(new Dimension(350, 200));
        cam2.setVisible(true);
        this.centerDialog(cam2);
        cam2.setResizable(false);
        JPanel labs = new JPanel(new GridLayout(4, 1, 5, 0));
        labs.add(new JLabel("atoms:"));
        labs.add(new JLabel("bonds:"));
        labs.add(new JLabel("H-bonds:"));
        labs.add(new JLabel("orbitals:"));
        cam2.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(4, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        bo.add(this.camFields[7]);
        bo.add(this.camFields[8]);
        bo.add(this.camFields[9]);
        bo.add(this.camFields[10]);
        bo.add(this.camFields[11]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[12]);
        bo.add(this.camFields[13]);
        bo.add(this.camFields[14]);
        bo.add(this.camFields[15]);
        bo.add(this.camFields[16]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[17]);
        bo.add(this.camFields[18]);
        bo.add(this.camFields[19]);
        bo.add(this.camFields[20]);
        bo.add(this.camFields[21]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[22]);
        bo.add(this.camFields[23]);
        bo.add(this.camFields[24]);
        bo.add(this.camFields[25]);
        bo.add(this.camFields[26]);
        in.add(bo);
        cam2.add((Component)in, "Center");
        cam2.add((Component)new JLabel("                    amb              diff            spec          pow          transp"), "North");
        JButton b = new JButton("OK");
        cam2.add((Component)b, "South");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cam2.dispose();
                NBODialogView.this.cam3();
            }
        });
    }

    protected void cam3() {
        final JDialog cam3 = new JDialog(this, "Color (Blue/Green/Red) Parameters:", false);
        cam3.setLayout(new BorderLayout());
        cam3.setMinimumSize(new Dimension(350, 200));
        cam3.setVisible(true);
        this.centerDialog(cam3);
        cam3.setResizable(false);
        JPanel labs = new JPanel(new GridLayout(6, 1, 5, 0));
        labs.add(new JLabel("light source color:"));
        labs.add(new JLabel("background color:"));
        labs.add(new JLabel("orbital (+ phase) color:"));
        labs.add(new JLabel("orbital (- phase) color:"));
        labs.add(new JLabel("bond color"));
        labs.add(new JLabel("H-Bond color"));
        cam3.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(6, 1, 5, 0));
        Box bo = Box.createHorizontalBox();
        bo.add(this.camFields[27]);
        bo.add(this.camFields[28]);
        bo.add(this.camFields[29]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[30]);
        bo.add(this.camFields[31]);
        bo.add(this.camFields[32]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[33]);
        bo.add(this.camFields[34]);
        bo.add(this.camFields[35]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[36]);
        bo.add(this.camFields[37]);
        bo.add(this.camFields[38]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[39]);
        bo.add(this.camFields[40]);
        bo.add(this.camFields[41]);
        in.add(bo);
        bo = Box.createHorizontalBox();
        bo.add(this.camFields[42]);
        bo.add(this.camFields[43]);
        bo.add(this.camFields[44]);
        in.add(bo);
        cam3.add((Component)in, "Center");
        cam3.add((Component)new JLabel("                                                 Blue               Green             Red"), "North");
        JButton b = new JButton("OK");
        cam3.add((Component)b, "South");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cam3.dispose();
                NBODialogView.this.cam4();
            }
        });
    }

    protected void cam4() {
        final JDialog cam4 = new JDialog(this, "Atomic and Bond Radii:", false);
        cam4.setLayout(new BorderLayout());
        cam4.setMinimumSize(new Dimension(250, 200));
        cam4.setVisible(true);
        this.centerDialog(cam4);
        JPanel labs = new JPanel(new GridLayout(4, 1, 5, 0));
        labs.add(new JLabel("Atomic radius for H:"));
        labs.add(new JLabel("Atomic radius for C:"));
        labs.add(new JLabel("Bond radius:"));
        labs.add(new JLabel("H-bond radius:"));
        cam4.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(4, 1, 5, 0));
        in.add(this.camFields[45]);
        in.add(this.camFields[46]);
        in.add(this.camFields[47]);
        in.add(this.camFields[48]);
        cam4.add((Component)in, "Center");
        JButton b = new JButton("OK");
        cam4.add((Component)b, "South");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cam4.dispose();
                NBODialogView.this.cam5();
            }
        });
    }

    protected void cam5() {
        final JDialog cam5 = new JDialog(this, "Contour Parameters:", false);
        cam5.setLayout(new BorderLayout());
        cam5.setMinimumSize(new Dimension(250, 150));
        cam5.setVisible(true);
        this.centerDialog(cam5);
        JPanel labs = new JPanel(new GridLayout(3, 1, 5, 0));
        labs.add(new JLabel("Contour value:"));
        labs.add(new JLabel("Contour tolerance:"));
        labs.add(new JLabel("Stepsize:"));
        cam5.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(3, 1, 5, 0));
        in.add(this.camFields[49]);
        in.add(this.camFields[50]);
        in.add(this.camFields[51]);
        cam5.add((Component)in, "Center");
        JButton b = new JButton("OK");
        cam5.add((Component)b, "South");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cam5.dispose();
                NBODialogView.this.cam6();
            }
        });
    }

    protected void cam6() {
        final JDialog cam6 = new JDialog(this, "Inner Lobes:", false);
        cam6.setLayout(new BorderLayout());
        cam6.setMinimumSize(new Dimension(320, 100));
        cam6.setVisible(true);
        this.centerDialog(cam6);
        Box bo = Box.createHorizontalBox();
        bo.add(new JLabel("  Inner lobes of orbitals included? "));
        JButton b = new JButton("YES");
        bo.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.inLobes = true;
                cam6.dispose();
                NBODialogView.this.viewState = 0;
            }
        });
        b = new JButton("NO");
        bo.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogView.this.inLobes = false;
                cam6.dispose();
                NBODialogView.this.viewState = 0;
            }
        });
        cam6.add((Component)bo, "Center");
    }

    protected void stip() {
        final JDialog stip = new JDialog(this, "Specification of contour lines:", false);
        stip.setLayout(new BorderLayout());
        stip.setMinimumSize(new Dimension(300, 300));
        stip.setVisible(true);
        this.centerDialog(stip);
        JPanel labs = new JPanel(new GridLayout(8, 1, 0, 0));
        labs.add(new JLabel("Enter first contour line:"));
        labs.add(new JLabel("Enter contour step size:"));
        labs.add(new JLabel("Enter number of contours:"));
        labs.add(new JLabel("Enter length of dash (cm):"));
        labs.add(new JLabel("Enter length of space (cm):"));
        labs.add(new JLabel("  Specification of orbital diagram lines"));
        labs.add(new JLabel("Enter length of dash (cm):"));
        labs.add(new JLabel("Enter length of space (cm):"));
        stip.add((Component)labs, "West");
        JPanel in = new JPanel(new GridLayout(8, 1, 0, 0));
        in.add(this.contourFields[0]);
        in.add(this.contourFields[1]);
        in.add(this.contourFields[2]);
        in.add(this.contourFields[3]);
        in.add(this.contourFields[4]);
        in.add(Box.createRigidArea(new Dimension(0, 0)));
        in.add(this.contourFields[5]);
        in.add(this.contourFields[6]);
        stip.add((Component)in, "Center");
        JButton b = new JButton("OK");
        stip.add((Component)b, "South");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stip.dispose();
            }
        });
    }

    protected void showOrbJmol(JList<String> list) {
        String item = list.getSelectedValue();
        if (item.split(" ").length < 2) {
            return;
        }
        int pt = item.indexOf("-");
        String type = item.split(" ")[1];
        if (type.equals("NAO")) {
            type = "PNAO";
        }
        this.nboService.runScriptQueued("MO delete; NBO delete; NBO TYPE " + type + "; NBO " + item.substring(pt + 1, item.indexOf("]")));
    }

    protected void showOrbJmol(String type, int i) {
        System.out.println("----" + type);
        if (type.trim().equals("NAO")) {
            type = "PNAO";
        }
        System.out.println("----" + type);
        this.nboService.runScriptQueued("MO delete; NBO delete; NBO TYPE " + type + "; NBO " + i);
        if (this.nboView) {
            this.nboService.runScriptQueued("nbo color yellow [134,254,253]; nbo fill nomesh translucent 0.3");
        }
    }

    protected synchronized void basisSel(final DefaultComboBoxModel<String> listModel) {
        this.keywordNumber = this.basis.getSelectedIndex() + 1;
        this.reqInfo = "";
        String keyword = this.basis.getSelectedItem().toString();
        final SB sb = new SB();
        if (this.lists.get("o " + keyword) != null) {
            this.setOrbitalList(this.lists.get("o " + keyword), listModel);
            return;
        }
        if (keyword.equals("MO")) {
            for (int i = 1; i <= listModel.getSize(); ++i) {
                sb.append((i + ".  MO " + i + "                 ").substring(0, 20));
            }
            this.nboService.queueJob("view", "getting orbital list", new Runnable(){

                @Override
                public void run() {
                    NBODialogView.this.processOrbitalList(sb.toString(), listModel);
                }
            });
        } else {
            this.appendToFile("GLOBAL C_PATH " + this.inputFile.getParent() + sep, sb);
            this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sb);
            this.appendToFile("GLOBAL I_BAS_1 " + this.keywordNumber + sep, sb);
            this.appendToFile("CMD LABEL", sb);
            this.nboService.queueJob("view", "getting orbital list", new Runnable(){

                @Override
                public void run() {
                    NBODialogView.this.nboService.rawCmdNew("v", sb, true, 33);
                    NBODialogView.this.processOrbitalList(NBODialogView.this.reqInfo, listModel);
                }
            });
        }
    }

    @Override
    protected void nboResetV() {
        this.resetRunFile();
        this.dList = null;
        for (int i = 1; i <= this.numStor; ++i) {
            String dir = new File(this.workingPath).getParent();
            File f = new File(dir + "/" + this.jobStem + i + ".bmp");
            File f2 = new File(dir + "/" + this.jobStem + i + ".ps");
            System.out.println("----" + f2.toString());
            f.delete();
            f2.delete();
        }
        this.lists = new Hashtable();
        this.numStor = 0;
        this.iLastD = -1;
        this.iLast = -1;
    }

    protected void goViewClicked() {
        final SB sb = new SB();
        final int index = this.list.getSelectedIndex() + 1;
        this.appendToFile("GLOBAL C_PATH " + this.inputFile.getParent() + sep, sb);
        this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sb);
        this.appendToFile("GLOBAL I_BAS_1 " + (this.basis.getSelectedIndex() + 1) + sep, sb);
        if (this.positiveSign) {
            this.appendToFile("GLOBAL SIGN +1 " + sep, sb);
        } else {
            this.appendToFile("GLOBAL SIGN -1 " + sep, sb);
        }
        int ind = this.list.getSelectedIndex();
        if (this.oneD) {
            this.appendToFile(this.getVectorParams(), sb);
            this.appendToFile("CMD PROFILE " + ind, sb);
            this.appendOutputWithCaret("Profile " + ind, 'i');
        } else {
            this.appendToFile(this.getPlaneParams(), sb);
            this.appendToFile("CMD CONTOUR " + ind, sb);
            this.appendOutputWithCaret("Contour " + ind, 'i');
        }
        final boolean oneD = this.oneD;
        String s = this.list.getSelectedItem().toString();
        final String val = s.substring(s.indexOf(".") + 1).replaceAll(" ", "");
        final String orb = this.basis.getSelectedItem().toString().replaceAll(" ", "");
        this.nboService.queueJob("view", "getting " + (oneD ? "profile" : "contour"), new Runnable(){

            @Override
            public void run() {
                NBODialogView.this.dispBox.setVisible(true);
                NBODialogView.this.nboService.rawCmdNew("v", sb, false, 88);
                String s = NBODialogView.this.numStor % 9 + 1 + ")*[" + (oneD ? "P-" : "C-") + index + "] " + orb + " " + val + "  {" + (NBODialogView.this.positiveSign ? "+" : "-") + ": " + (oneD ? NBODialogView.this.vLab.getText() : NBODialogView.this.pLab.getText()) + "}";
                if (NBODialogView.this.numStor % 9 == 0) {
                    NBODialogView.this.model.add(8, NBODialogView.this.model.remove(8).replace("*", ""));
                } else {
                    NBODialogView.this.model.add(NBODialogView.this.numStor % 9 - 1, NBODialogView.this.model.remove(NBODialogView.this.numStor % 9 - 1).replace("*", ""));
                }
                NBODialogView.this.model.remove(NBODialogView.this.numStor % 9);
                NBODialogView.this.model.add(NBODialogView.this.numStor % 9, s);
                NBODialogView.this.dList.setSelectedIndex(NBODialogView.this.numStor % 9);
                ++NBODialogView.this.numStor;
            }
        });
    }

    protected void showView1D2D() {
        final SB sb = new SB();
        this.appendToFile("GLOBAL C_PATH " + this.inputFile.getParent() + sep, sb);
        this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sb);
        this.appendToFile("CMD SHOW " + (this.dList.getSelectedIndex() + 1) + sep, sb);
        final String fname = this.inputFile.getParent() + "\\" + this.jobStem + ".ps";
        this.nboService.queueJob("view", "creating PostScript file...", new Runnable(){

            @Override
            public void run() {
                File f = new File(fname);
                if (f.exists()) {
                    f.delete();
                }
                NBODialogView.this.nboService.rawCmdNew("v", sb, false, 88);
                while (!f.exists() && !NBODialogView.this.nboService.jobCanceled) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                NBODialogView.this.vwr.alert("file " + fname + " has been created");
            }
        });
    }

    protected void view3D() {
        final SB sb = new SB();
        int num = this.numStor % 9 <= this.dList.getSelectedIndex() ? (this.numStor / 9 - 1) * 9 + this.dList.getSelectedIndex() + 1 : this.numStor / 9 * 9 + this.dList.getSelectedIndex() + 1;
        this.appendToFile("GLOBAL C_PATH " + this.inputFile.getParent() + sep, sb);
        this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sb);
        this.appendToFile(this.getCameraParams(), sb);
        this.appendToFile("CMD VIEW ", sb);
        int[] indices = this.dList.getSelectedIndices();
        final SB title = new SB();
        for (int x : indices) {
            this.appendToFile(Integer.toString(x + 1) + " ", sb);
            title.append(PT.split(this.dList.getModel().getElementAt(x), "]")[1] + " ");
        }
        final String fname = this.inputFile.getParent() + "\\" + this.jobStem + ".bmp";
        this.nboService.queueJob("view", "Raytracing, please be patient...", new Runnable(){

            @Override
            public void run() {
                String err = null;
                File f = new File(fname);
                String id = "id " + PT.esc(title.toString().trim());
                f.delete();
                NBODialogView.this.nboService.rawCmdNew("v", sb, false, 88);
                while (!f.exists() && !NBODialogView.this.nboService.jobCanceled) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    String script = "image " + id + " close;image " + id + " " + PT.esc(f.toString().replace('\\', '/'));
                    NBODialogView.this.nboService.runScriptQueued(script);
                    NBODialogView.this.statusLab.setText(err);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void processOrbitalList(String list, DefaultComboBoxModel<String> listModel) {
        System.out.println("processing list " + list);
        try {
            String[] st = new String[list.length() / 20];
            int i = 0;
            while ((i + 1) * 20 <= list.length()) {
                st[i] = list.substring(i * 20, (i + 1) * 20);
                ++i;
            }
            this.lists.put("o " + this.basis.getSelectedItem().toString(), st);
            this.setOrbitalList(st, listModel);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void setOrbitalList(String[] s, DefaultComboBoxModel<String> listModel) {
        int select = this.list.getSelectedIndex();
        listModel.removeAllElements();
        for (String x : s) {
            listModel.addElement(x);
        }
        if (select != -1) {
            this.list.setSelectedIndex(select);
        } else {
            this.list.setSelectedIndex(0);
        }
    }

    protected void notifyCallbackV(String atomno) {
        switch (this.viewState) {
            case 2: {
                this.vectorFields[this.viewVectorPt++].setText(atomno);
                this.vLab.setText(this.vectorFields[0].getText() + ", " + this.vectorFields[1].getText());
                this.showSelected(this.vLab.getText().split(", "));
                this.viewVectorPt %= 2;
                break;
            }
            case 1: {
                this.planeFields[this.viewPlanePt++].setText(atomno);
                this.pLab.setText(this.planeFields[0].getText() + ", " + this.planeFields[1].getText() + ", " + this.planeFields[2].getText());
                this.showSelected(this.pLab.getText().split(", "));
                this.viewPlanePt %= 3;
            }
        }
    }

    protected void rawInputV(String cmd) {
        if (!this.checkJmolNBO()) {
            return;
        }
        if (cmd.startsWith("BAS")) {
            try {
                this.basis.setSelectedItem(cmd.split(" ")[1]);
                this.appendOutputWithCaret("Basis changed:  " + cmd.split(" ")[1], 'i');
            }
            catch (Exception e) {
                this.appendOutputWithCaret("NBO View can't do that", 'b');
            }
        } else if (cmd.startsWith("CON")) {
            try {
                int i = Integer.parseInt(cmd.split(" ")[1]);
                this.list.setSelectedIndex(i - 1);
                this.oneD = false;
                this.goViewClicked();
            }
            catch (Exception e) {
                this.appendOutputWithCaret("NBO View can't do that", 'b');
            }
        } else if (cmd.startsWith("PR")) {
            try {
                int i = Integer.parseInt(cmd.split(" ")[1]);
                this.list.setSelectedIndex(i - 1);
                this.oneD = true;
                this.goViewClicked();
            }
            catch (Exception e) {
                this.appendOutputWithCaret("NBO View can't do that", 'b');
            }
        } else if (cmd.startsWith("VIEW")) {
            try {
                int i = Integer.parseInt(cmd.split(" ")[1]);
                this.dList.setSelectedIndex(i - 1);
                this.view3D();
            }
            catch (Exception e) {
                this.appendOutputWithCaret("NBO View can't do that", 'b');
            }
        }
    }
}

