/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractSelectAction;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.conflict.IConflictListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.conflict.pair.ConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.dialogs.ConflictResolutionDialog;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public final class ConflictDialog
extends ToggleDialog
implements MainLayerManager.ActiveLayerChangeListener,
IConflictListener,
SelectionChangedListener {
    private static final ColorProperty CONFLICT_COLOR = new ColorProperty(I18n.marktr("conflict"), Color.GRAY);
    private static final ColorProperty BACKGROUND_COLOR = new ColorProperty(I18n.marktr("background"), Color.BLACK);
    private transient ConflictCollection conflicts;
    private transient ConflictListModel model;
    private JList<OsmPrimitive> lstConflicts;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final transient PopupMenuHandler popupMenuHandler = new PopupMenuHandler(this.popupMenu);
    private final ResolveAction actResolve = new ResolveAction();
    private final SelectAction actSelect = new SelectAction();

    public ConflictDialog() {
        super(I18n.tr("Conflict", new Object[0]), "conflict", I18n.tr("Resolve conflicts.", new Object[0]), Shortcut.registerShortcut("subwindow:conflict", I18n.tr("Toggle: {0}", I18n.tr("Conflict", new Object[0])), 67, 5007), 100);
        this.build();
        this.refreshView();
    }

    public static Color getColor() {
        return CONFLICT_COLOR.get();
    }

    private void build() {
        this.model = new ConflictListModel();
        this.lstConflicts = new JList<OsmPrimitive>(this.model);
        this.lstConflicts.setSelectionMode(2);
        this.lstConflicts.setCellRenderer(new OsmPrimitivRenderer());
        this.lstConflicts.addMouseListener(new MouseEventHandler());
        this.addListSelectionListener(listSelectionEvent -> Main.map.mapView.repaint());
        SideButton sideButton = new SideButton(this.actResolve);
        this.addListSelectionListener(this.actResolve);
        SideButton sideButton2 = new SideButton(this.actSelect);
        this.addListSelectionListener(this.actSelect);
        this.createLayout(this.lstConflicts, true, Arrays.asList(sideButton, sideButton2));
        this.popupMenuHandler.addAction(Main.main.menu.autoScaleActions.get("conflict"));
        ResolveToMyVersionAction resolveToMyVersionAction = new ResolveToMyVersionAction();
        ResolveToTheirVersionAction resolveToTheirVersionAction = new ResolveToTheirVersionAction();
        this.addListSelectionListener(resolveToMyVersionAction);
        this.addListSelectionListener(resolveToTheirVersionAction);
        final JMenuItem jMenuItem = this.popupMenuHandler.addAction(resolveToMyVersionAction);
        final JMenuItem jMenuItem2 = this.popupMenuHandler.addAction(resolveToTheirVersionAction);
        this.popupMenuHandler.addListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                jMenuItem.setVisible(ExpertToggleAction.isExpert());
                jMenuItem2.setVisible(ExpertToggleAction.isExpert());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    @Override
    public void showNotify() {
        DataSet.addSelectionListener(this);
        Main.getLayerManager().addAndFireActiveLayerChangeListener(this);
        this.refreshView();
    }

    @Override
    public void hideNotify() {
        Main.getLayerManager().removeActiveLayerChangeListener(this);
        DataSet.removeSelectionListener(this);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.lstConflicts.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.lstConflicts.getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    public PopupMenuHandler getPopupMenuHandler() {
        return this.popupMenuHandler;
    }

    private void resolve() {
        if (this.conflicts == null || this.model.getSize() == 0) {
            return;
        }
        int n = this.lstConflicts.getSelectedIndex();
        if (n < 0) {
            n = 0;
        }
        Conflict<?> conflict = this.conflicts.get(n);
        ConflictResolutionDialog conflictResolutionDialog = new ConflictResolutionDialog(Main.parent);
        conflictResolutionDialog.getConflictResolver().populate(conflict);
        conflictResolutionDialog.showDialog();
        this.lstConflicts.setSelectedIndex(n);
        Main.map.mapView.repaint();
    }

    public void refreshView() {
        OsmDataLayer osmDataLayer = Main.getLayerManager().getEditLayer();
        this.conflicts = osmDataLayer == null ? new ConflictCollection() : osmDataLayer.getConflicts();
        GuiHelper.runInEDT(() -> {
            this.model.fireContentChanged();
            this.updateTitle();
        });
    }

    private void updateTitle() {
        int n = this.conflicts.size();
        if (n > 0) {
            this.setTitle(I18n.trn("Conflict: {0} unresolved", "Conflicts: {0} unresolved", n, n) + " (" + I18n.tr("Rel.:{0} / Ways:{1} / Nodes:{2}", this.conflicts.getRelationConflicts().size(), this.conflicts.getWayConflicts().size(), this.conflicts.getNodeConflicts().size()) + ')');
        } else {
            this.setTitle(I18n.tr("Conflict", new Object[0]));
        }
    }

    public void paintConflicts(Graphics graphics, NavigatableComponent navigatableComponent) {
        Color color = ConflictDialog.getColor();
        if (color.equals(BACKGROUND_COLOR.get())) {
            return;
        }
        graphics.setColor(color);
        ConflictPainter conflictPainter = new ConflictPainter(navigatableComponent, graphics);
        for (OsmPrimitive osmPrimitive : this.lstConflicts.getSelectedValuesList()) {
            if (this.conflicts == null || !this.conflicts.hasConflictForMy(osmPrimitive)) continue;
            ((OsmPrimitive)this.conflicts.getConflictForMy(osmPrimitive).getTheir()).accept(conflictPainter);
        }
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent activeLayerChangeEvent) {
        OsmDataLayer osmDataLayer;
        OsmDataLayer osmDataLayer2 = activeLayerChangeEvent.getPreviousEditLayer();
        if (osmDataLayer2 != null) {
            osmDataLayer2.getConflicts().removeConflictListener(this);
        }
        if ((osmDataLayer = activeLayerChangeEvent.getSource().getEditLayer()) != null) {
            osmDataLayer.getConflicts().addConflictListener(this);
        }
        this.refreshView();
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }

    public Conflict<? extends OsmPrimitive> getSelectedConflict() {
        if (this.conflicts == null || this.model.getSize() == 0) {
            return null;
        }
        int n = this.lstConflicts.getSelectedIndex();
        return n >= 0 ? this.conflicts.get(n) : null;
    }

    private boolean isConflictSelected() {
        ListSelectionModel listSelectionModel = this.lstConflicts.getSelectionModel();
        return listSelectionModel.getMinSelectionIndex() >= 0 && listSelectionModel.getMaxSelectionIndex() >= listSelectionModel.getMinSelectionIndex();
    }

    @Override
    public void onConflictsAdded(ConflictCollection conflictCollection) {
        this.refreshView();
    }

    @Override
    public void onConflictsRemoved(ConflictCollection conflictCollection) {
        Main.info("1 conflict has been resolved.");
        this.refreshView();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.lstConflicts.clearSelection();
        for (OsmPrimitive osmPrimitive : collection) {
            int n;
            if (this.conflicts == null || !this.conflicts.hasConflictForMy(osmPrimitive) || (n = this.model.indexOf(osmPrimitive)) < 0) continue;
            this.lstConflicts.addSelectionInterval(n, n);
        }
    }

    @Override
    public String helpTopic() {
        return HelpUtil.ht("/Dialog/ConflictList");
    }

    public void warnNumNewConflicts(int n) {
        if (n == 0) {
            return;
        }
        String string = I18n.trn("There was {0} conflict detected.", "There were {0} conflicts detected.", n, n);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>").append(string).append("</html>");
        if (n > 0) {
            HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("OK", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to close this dialog and continue editing", new Object[0]), null)};
            GuiHelper.runInEDT(() -> {
                HelpAwareOptionPane.showOptionDialog(Main.parent, stringBuilder.toString(), I18n.tr("Conflicts detected", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/Concepts/Conflict#WarningAboutDetectedConflicts"));
                this.unfurlDialog();
                Main.map.repaint();
            });
        }
    }

    public static class ConflictPainter
    extends AbstractVisitor {
        private final Set<Relation> visited = new HashSet<Relation>();
        private final NavigatableComponent nc;
        private final Graphics g;

        ConflictPainter(NavigatableComponent navigatableComponent, Graphics graphics) {
            this.nc = navigatableComponent;
            this.g = graphics;
        }

        @Override
        public void visit(Node node) {
            Point point = this.nc.getPoint(node);
            this.g.drawRect(point.x - 1, point.y - 1, 2, 2);
        }

        private void visit(Node node, Node node2) {
            Point point = this.nc.getPoint(node);
            Point point2 = this.nc.getPoint(node2);
            this.g.drawLine(point.x, point.y, point2.x, point2.y);
        }

        @Override
        public void visit(Way way) {
            Node node = null;
            for (Node node2 : way.getNodes()) {
                if (node == null) {
                    node = node2;
                    continue;
                }
                this.visit(node, node2);
                node = node2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visit(Relation relation) {
            if (!this.visited.contains(relation)) {
                this.visited.add(relation);
                try {
                    for (RelationMember relationMember : relation.getMembers()) {
                        relationMember.getMember().accept(this);
                    }
                }
                finally {
                    this.visited.remove(relation);
                }
            }
        }
    }

    class ResolveToTheirVersionAction
    extends ResolveToAction {
        ResolveToTheirVersionAction() {
            super(I18n.tr("Resolve to their versions", new Object[0]), I18n.tr("Resolves all unresolved conflicts to ''their'' version", new Object[0]), MergeDecisionType.KEEP_THEIR);
        }
    }

    class ResolveToMyVersionAction
    extends ResolveToAction {
        ResolveToMyVersionAction() {
            super(I18n.tr("Resolve to my versions", new Object[0]), I18n.tr("Resolves all unresolved conflicts to ''my'' version", new Object[0]), MergeDecisionType.KEEP_MINE);
        }
    }

    abstract class ResolveToAction
    extends ResolveAction {
        private final String name;
        private final MergeDecisionType type;

        ResolveToAction(String string, String string2, MergeDecisionType mergeDecisionType) {
            this.name = string;
            this.type = mergeDecisionType;
            this.putValue("Name", string);
            this.putValue("ShortDescription", string2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConflictResolver conflictResolver = new ConflictResolver();
            ArrayList<Command> arrayList = new ArrayList<Command>();
            for (OsmPrimitive osmPrimitive : ConflictDialog.this.lstConflicts.getSelectedValuesList()) {
                Conflict<?> conflict = ConflictDialog.this.conflicts.getConflictForMy(osmPrimitive);
                if (conflict == null) continue;
                conflictResolver.populate(conflict);
                conflictResolver.decideRemaining(this.type);
                arrayList.add(conflictResolver.buildResolveCommand());
            }
            Main.main.undoRedo.add(new SequenceCommand(this.name, arrayList));
            ConflictDialog.this.refreshView();
            Main.map.mapView.repaint();
        }
    }

    final class SelectAction
    extends AbstractSelectAction
    implements ListSelectionListener {
        private SelectAction() {
            this.putValue("help", HelpUtil.ht("/Dialog/ConflictList#SelectAction"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
            for (OsmPrimitive osmPrimitive : ConflictDialog.this.lstConflicts.getSelectedValuesList()) {
                linkedList.add(osmPrimitive);
            }
            DataSet dataSet = Main.getLayerManager().getEditDataSet();
            if (dataSet != null) {
                dataSet.setSelected(linkedList);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(ConflictDialog.this.isConflictSelected());
        }
    }

    class ResolveAction
    extends AbstractAction
    implements ListSelectionListener {
        ResolveAction() {
            this.putValue("Name", I18n.tr("Resolve", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Open a merge dialog of all selected items in the list above.", new Object[0]));
            new ImageProvider("dialogs", "conflict").getResource().attachImageIcon(this, true);
            this.putValue("help", HelpUtil.ht("/Dialog/ConflictList#ResolveAction"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConflictDialog.this.resolve();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(ConflictDialog.this.isConflictSelected());
        }
    }

    class ConflictListModel
    implements ListModel<OsmPrimitive> {
        private final CopyOnWriteArrayList<ListDataListener> listeners = new CopyOnWriteArrayList();

        ConflictListModel() {
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
            if (listDataListener != null) {
                this.listeners.addIfAbsent(listDataListener);
            }
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
            this.listeners.remove(listDataListener);
        }

        protected void fireContentChanged() {
            ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, this.getSize());
            for (ListDataListener listDataListener : this.listeners) {
                listDataListener.contentsChanged(listDataEvent);
            }
        }

        @Override
        public OsmPrimitive getElementAt(int n) {
            if (n < 0 || n >= this.getSize()) {
                return null;
            }
            return ConflictDialog.this.conflicts.get(n).getMy();
        }

        @Override
        public int getSize() {
            return ConflictDialog.this.conflicts != null ? ConflictDialog.this.conflicts.size() : 0;
        }

        public int indexOf(OsmPrimitive osmPrimitive) {
            if (ConflictDialog.this.conflicts != null) {
                for (int i = 0; i < ConflictDialog.this.conflicts.size(); ++i) {
                    if (!ConflictDialog.this.conflicts.get(i).isMatchingMy(osmPrimitive)) continue;
                    return i;
                }
            }
            return -1;
        }

        public OsmPrimitive get(int n) {
            return ConflictDialog.this.conflicts != null ? (OsmPrimitive)ConflictDialog.this.conflicts.get(n).getMy() : null;
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        MouseEventHandler() {
            super(ConflictDialog.this.popupMenu);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (MouseEventHandler.isDoubleClick(mouseEvent)) {
                ConflictDialog.this.resolve();
            }
        }
    }
}

