/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;

@NodeChild(value="value", type=RubyNode.class)
public abstract class BooleanCastWithDefaultNode
extends RubyNode {
    private final boolean defaultValue;

    public BooleanCastWithDefaultNode(boolean defaultValue) {
        this.defaultValue = defaultValue;
    }

    public abstract boolean executeBoolean(VirtualFrame var1, Object var2);

    @Specialization
    public boolean doDefault(NotProvided value) {
        return this.defaultValue;
    }

    @Specialization
    public boolean doBoolean(boolean value) {
        return value;
    }

    @Specialization(guards={"isNil(nil)"})
    public boolean doNil(Object nil) {
        return false;
    }

    @Specialization
    public boolean doIntegerFixnum(int value) {
        return true;
    }

    @Specialization
    public boolean doLongFixnum(long value) {
        return true;
    }

    @Specialization
    public boolean doFloat(double value) {
        return true;
    }

    @Specialization(guards={"!isNil(object)"})
    public boolean doBasicObject(DynamicObject object) {
        return true;
    }

    @Override
    public abstract boolean executeBoolean(VirtualFrame var1);
}

