/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.util.StringUtils;

@CoreClass(value="Truffle::String")
public class TruffleStringNodes {

    @CoreMethod(names={"truncate"}, onSingleton=true, required=2, lowerFixnum={2})
    public static abstract class TruncateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"newByteLength < 0"})
        @CompilerDirectives.TruffleBoundary
        public DynamicObject truncateLengthNegative(DynamicObject string, int newByteLength) {
            throw new RaiseException(this.getContext().getCoreExceptions().argumentError(this.formatNegativeError(newByteLength), this));
        }

        @Specialization(guards={"newByteLength >= 0", "isRubyString(string)", "isNewLengthTooLarge(string, newByteLength)"})
        @CompilerDirectives.TruffleBoundary
        public DynamicObject truncateLengthTooLong(DynamicObject string, int newByteLength) {
            throw new RaiseException(this.getContext().getCoreExceptions().argumentError(this.formatTooLongError(newByteLength, StringOperations.rope(string)), this));
        }

        @Specialization(guards={"newByteLength >= 0", "isRubyString(string)", "!isNewLengthTooLarge(string, newByteLength)"})
        public DynamicObject stealStorage(DynamicObject string, int newByteLength, @Cached(value="createX()") RopeNodes.MakeSubstringNode makeSubstringNode) {
            StringOperations.setRope(string, makeSubstringNode.executeMake(StringOperations.rope(string), 0, newByteLength));
            return string;
        }

        protected static boolean isNewLengthTooLarge(DynamicObject string, int newByteLength) {
            assert (RubyGuards.isRubyString(string));
            return newByteLength > StringOperations.rope(string).byteLength();
        }

        @CompilerDirectives.TruffleBoundary
        private String formatNegativeError(int count) {
            return StringUtils.format("Invalid byte count: %d is negative", count);
        }

        @CompilerDirectives.TruffleBoundary
        private String formatTooLongError(int count, Rope rope) {
            return StringUtils.format("Invalid byte count: %d exceeds string size of %d bytes", count, rope.byteLength());
        }
    }
}

