/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Instrumentable;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.kernel.TraceManager;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.ModuleBodyDefinitionNodeWrapper;
import org.jruby.truffle.language.methods.SharedMethodInfo;

@Instrumentable(factory=ModuleBodyDefinitionNodeWrapper.class)
public class ModuleBodyDefinitionNode
extends RubyNode {
    private final String name;
    private final SharedMethodInfo sharedMethodInfo;
    private final CallTarget callTarget;
    private final boolean captureBlock;

    public ModuleBodyDefinitionNode(RubyContext context, SourceSection sourceSection, String name, SharedMethodInfo sharedMethodInfo, CallTarget callTarget, boolean captureBlock) {
        super(context, sourceSection);
        this.name = name;
        this.sharedMethodInfo = sharedMethodInfo;
        this.callTarget = callTarget;
        this.captureBlock = captureBlock;
    }

    public ModuleBodyDefinitionNode(ModuleBodyDefinitionNode node) {
        this(node.getContext(), node.getSourceSection(), node.name, node.sharedMethodInfo, node.callTarget, node.captureBlock);
    }

    public InternalMethod executeMethod(VirtualFrame frame) {
        DynamicObject dummyModule = this.coreLibrary().getObjectClass();
        Visibility dummyVisibility = Visibility.PUBLIC;
        DynamicObject capturedBlock = this.captureBlock ? RubyArguments.getBlock(frame) : null;
        return new InternalMethod(this.sharedMethodInfo, this.name, dummyModule, dummyVisibility, false, null, this.callTarget, capturedBlock, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeMethod(frame);
    }

    @Override
    protected boolean isTaggedWith(Class<?> tag) {
        if (tag == TraceManager.ClassTag.class) {
            return true;
        }
        return super.isTaggedWith(tag);
    }
}

