/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.platform.openjdk;

import java.lang.invoke.MethodHandle;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.truffle.core.queue.DelegatingBlockingQueue;
import org.jruby.truffle.core.queue.LinkedBlockingQueueLocksConditions;
import org.jruby.truffle.language.control.JavaException;
import org.jruby.truffle.platform.openjdk.MethodHandleUtils;

public class OpenJDKLinkedBlockingQueueLocksConditions<T>
extends DelegatingBlockingQueue<T>
implements LinkedBlockingQueueLocksConditions<T> {
    private static final MethodHandle TAKE_LOCK_FIELD_GETTER = MethodHandleUtils.getPrivateGetter(LinkedBlockingQueue.class, "takeLock");
    private static final MethodHandle NOT_EMPTY_CONDITION_FIELD_GETTER = MethodHandleUtils.getPrivateGetter(LinkedBlockingQueue.class, "notEmpty");
    private final ReentrantLock lock;
    private final Condition notEmptyCondition;

    public OpenJDKLinkedBlockingQueueLocksConditions() {
        super(new LinkedBlockingQueue());
        LinkedBlockingQueue queue = (LinkedBlockingQueue)this.getQueue();
        try {
            this.lock = TAKE_LOCK_FIELD_GETTER.invokeExact(queue);
            this.notEmptyCondition = NOT_EMPTY_CONDITION_FIELD_GETTER.invokeExact(queue);
        }
        catch (Throwable throwable) {
            throw new JavaException(throwable);
        }
    }

    @Override
    public ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    public Condition getNotEmptyCondition() {
        return this.notEmptyCondition;
    }
}

