/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.bigdecimal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyRational;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalCoreMethodNode;

@ImportStatic(value={BigDecimalCoreMethodNode.class})
@NodeChildren(value={@NodeChild(value="value", type=RubyNode.class), @NodeChild(value="roundingMode", type=RubyNode.class)})
public abstract class BigDecimalCastNode
extends RubyNode {
    public abstract BigDecimal executeBigDecimal(VirtualFrame var1, Object var2, RoundingMode var3);

    public abstract Object executeObject(VirtualFrame var1, Object var2, RoundingMode var3);

    @Specialization
    public BigDecimal doInt(long value, Object roundingMode) {
        return BigDecimal.valueOf(value);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    public BigDecimal doDouble(double value, Object roundingMode) {
        return BigDecimal.valueOf(value);
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public BigDecimal doBignum(DynamicObject value, Object roundingMode) {
        return new BigDecimal(Layouts.BIGNUM.getValue(value));
    }

    @Specialization(guards={"isNormalRubyBigDecimal(value)"})
    public BigDecimal doBigDecimal(DynamicObject value, Object roundingMode) {
        return Layouts.BIG_DECIMAL.getValue(value);
    }

    @Specialization(guards={"!isRubyBignum(value)", "!isRubyBigDecimal(value)"})
    public Object doOther(VirtualFrame frame, DynamicObject value, Object roundingMode, @Cached(value="new()") SnippetNode isRationalSnippet, @Cached(value="createMethodCall()") CallDispatchHeadNode numeratorCallNode, @Cached(value="createMethodCall()") CallDispatchHeadNode denominatorCallNode, @Cached(value="createMethodCall()") CallDispatchHeadNode toFCallNode) {
        if (roundingMode instanceof RoundingMode && ((Boolean)isRationalSnippet.execute(frame, "value.is_a?(Rational)", "value", value)).booleanValue()) {
            Object numerator = numeratorCallNode.call(frame, value, "numerator", new Object[0]);
            Object denominator = denominatorCallNode.call(frame, value, "denominator", new Object[0]);
            RubyRational rubyRationalValue = this.newRationalRaw(numerator, denominator);
            return this.toBigDecimal(rubyRationalValue, (RoundingMode)((Object)roundingMode));
        }
        Object result = toFCallNode.call(frame, value, "to_f", new Object[0]);
        if (result != this.nil()) {
            return new BigDecimal((Double)result);
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private RubyRational newRationalRaw(Object numerator, Object denominator) {
        return RubyRational.newRationalRaw((Ruby)this.getContext().getJRubyRuntime(), (IRubyObject)this.toJRubyInteger(numerator), (IRubyObject)this.toJRubyInteger(denominator));
    }

    @CompilerDirectives.TruffleBoundary
    private BigDecimal toBigDecimal(RubyRational rubyRationalValue, RoundingMode roundingMode) {
        return RubyBigDecimal.getVpRubyObjectWithPrec19Inner((ThreadContext)this.getContext().getJRubyRuntime().getCurrentContext(), (RubyRational)rubyRationalValue, (RoundingMode)roundingMode).getBigDecimalValue();
    }

    @CompilerDirectives.TruffleBoundary
    private IRubyObject toJRubyInteger(Object value) {
        if (value instanceof Integer) {
            return RubyFixnum.newFixnum((Ruby)this.getContext().getJRubyRuntime(), (long)((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return RubyFixnum.newFixnum((Ruby)this.getContext().getJRubyRuntime(), (long)((Long)value));
        }
        if (RubyGuards.isRubyBignum(value)) {
            return RubyBignum.newBignum((Ruby)this.getContext().getJRubyRuntime(), (BigInteger)Layouts.BIGNUM.getValue((DynamicObject)value));
        }
        throw new UnsupportedOperationException(value.toString());
    }

    @Fallback
    public Object doBigDecimalFallback(Object value, Object roundingMode) {
        return this.nil();
    }
}

