/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.HashSet;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;

public class EnsureTempsAssigned
extends CompilerPass {
    @Override
    public String getLabel() {
        return "Ensure Temporary Variables Assigned";
    }

    @Override
    public Object execute(IRScope scope, Object ... data2) {
        this.processCFG(scope.getCFG());
        return null;
    }

    private void processCFG(CFG cfg) {
        HashSet<TemporaryVariable> names2 = new HashSet<TemporaryVariable>();
        for (BasicBlock b2 : cfg.getBasicBlocks()) {
            for (Instr i2 : b2.getInstrs()) {
                for (Variable v : i2.getUsedVariables()) {
                    if (!(v instanceof TemporaryVariable)) continue;
                    names2.add((TemporaryVariable)v);
                }
            }
        }
        BasicBlock bb = cfg.getEntryBB();
        int index2 = 0;
        TemporaryVariable first2 = null;
        for (TemporaryVariable name2 : names2) {
            if (first2 == null) {
                bb.getInstrs().add(index2++, new CopyInstr(name2, new Nil()));
                first2 = name2;
                continue;
            }
            bb.getInstrs().add(index2++, new CopyInstr(name2, first2));
        }
    }
}

