/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import com.google.common.collect.ImmutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.RangeCodegenUtil;
import org.jetbrains.kotlin.codegen.intrinsics.IteratorNext;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.org.objectweb.asm.Type;

public class ProgressionIteratorBasicValue
extends StrictBasicValue {
    private static final ImmutableMap<String, Type> VALUES_TYPENAME_TO_TYPE;
    private final Type valuesPrimitiveType;
    private final String valuesPrimitiveTypeName;

    @NotNull
    private static Type getValuesType(@NotNull String valuesTypeName) {
        if (valuesTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuesTypeName", "org/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue", "getValuesType"));
        }
        Type type2 = VALUES_TYPENAME_TO_TYPE.get(valuesTypeName);
        assert (type2 != null) : "Unexpected type " + valuesTypeName;
        Type type3 = type2;
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue", "getValuesType"));
        }
        return type3;
    }

    public ProgressionIteratorBasicValue(@NotNull String valuesPrimitiveTypeName) {
        if (valuesPrimitiveTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuesPrimitiveTypeName", "org/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue", "<init>"));
        }
        super(IteratorNext.Companion.getPrimitiveIteratorType(Name.identifier(valuesPrimitiveTypeName)));
        this.valuesPrimitiveType = ProgressionIteratorBasicValue.getValuesType(valuesPrimitiveTypeName);
        this.valuesPrimitiveTypeName = valuesPrimitiveTypeName;
    }

    @NotNull
    public Type getValuesPrimitiveType() {
        Type type2 = this.valuesPrimitiveType;
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue", "getValuesPrimitiveType"));
        }
        return type2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgressionIteratorBasicValue value = (ProgressionIteratorBasicValue)o;
        return this.valuesPrimitiveType.equals(value.valuesPrimitiveType);
    }

    @NotNull
    public String getNextMethodName() {
        String string = "next" + this.valuesPrimitiveTypeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue", "getNextMethodName"));
        }
        return string;
    }

    @NotNull
    public String getNextMethodDesc() {
        String string = "()" + this.getValuesPrimitiveType().getDescriptor();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue", "getNextMethodDesc"));
        }
        return string;
    }

    static {
        ImmutableMap.Builder<String, Type> builder = ImmutableMap.builder();
        for (PrimitiveType primitiveType : RangeCodegenUtil.supportedRangeTypes()) {
            builder.put(primitiveType.getTypeName().asString(), Type.getType(JvmPrimitiveType.get(primitiveType).getDesc()));
        }
        VALUES_TYPENAME_TO_TYPE = builder.build();
    }
}

