/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.traversal.Direction;
import java.util.ArrayList;
import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class BehaviorBase<C extends Control> {
    protected static final List<KeyBinding> TRAVERSAL_BINDINGS = new ArrayList<KeyBinding>();
    private C control;
    private List<KeyBinding> keyBindings = this.createKeyBindings();
    private final EventHandler<KeyEvent> keyEventListener = new EventHandler<KeyEvent>(){

        @Override
        public void handle(KeyEvent keyEvent) {
            BehaviorBase.this.callActionForEvent(keyEvent);
        }
    };

    public BehaviorBase(C c) {
        this.control = c;
        ((Node)c).addEventHandler(KeyEvent.ANY, this.keyEventListener);
    }

    protected List<KeyBinding> createKeyBindings() {
        return TRAVERSAL_BINDINGS;
    }

    public final C getControl() {
        return this.control;
    }

    protected void callActionForEvent(KeyEvent keyEvent) {
        KeyBinding keyBinding = null;
        int n = 0;
        int n2 = this.keyBindings.size();
        for (int i = 0; i < n2; ++i) {
            KeyBinding keyBinding2 = this.keyBindings.get(i);
            int n3 = keyBinding2.getSpecificity((Control)this.control, keyEvent);
            if (n3 <= n) continue;
            n = n3;
            keyBinding = keyBinding2;
        }
        if (keyBinding != null) {
            this.callAction(keyBinding.getAction());
            keyEvent.consume();
        }
    }

    protected void callAction(String string) {
        if ("TraverseUp".equals(string)) {
            this.traverseUp();
        } else if ("TraverseDown".equals(string)) {
            this.traverseDown();
        } else if ("TraverseLeft".equals(string)) {
            this.traverseLeft();
        } else if ("TraverseRight".equals(string)) {
            this.traverseRight();
        } else if ("TraverseNext".equals(string)) {
            this.traverseNext();
        } else if ("TraversePrevious".equals(string)) {
            this.traversePrevious();
        }
    }

    public void traverse(Node node, Direction direction) {
        node.impl_traverse(direction);
    }

    public void traverseUp() {
        this.traverse((Node)this.control, Direction.UP);
    }

    public void traverseDown() {
        this.traverse((Node)this.control, Direction.DOWN);
    }

    public void traverseLeft() {
        this.traverse((Node)this.control, Direction.LEFT);
    }

    public void traverseRight() {
        this.traverse((Node)this.control, Direction.RIGHT);
    }

    public void traverseNext() {
        this.traverse((Node)this.control, Direction.NEXT);
    }

    public void traversePrevious() {
        this.traverse((Node)this.control, Direction.PREVIOUS);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    static {
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.UP, "TraverseUp"));
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "TraverseDown"));
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "TraverseLeft"));
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "TraverseRight"));
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraverseNext"));
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraversePrevious").shift());
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.UP, "TraverseUp").shift().alt().ctrl());
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "TraverseDown").shift().alt().ctrl());
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "TraverseLeft").shift().alt().ctrl());
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "TraverseRight").shift().alt().ctrl());
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraverseNext").shift().alt().ctrl());
        TRAVERSAL_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraversePrevious").alt().ctrl());
    }
}

