/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.proc;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.proc.ProcType;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.FrameOnStackMarker;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.SharedMethodInfo;

public abstract class ProcOperations {
    public static Object[] packArguments(DynamicObject proc, Object ... args) {
        return RubyArguments.pack(Layouts.PROC.getDeclarationFrame(proc), null, Layouts.PROC.getMethod(proc), DeclarationContext.BLOCK, Layouts.PROC.getFrameOnStackMarker(proc), Layouts.PROC.getSelf(proc), Layouts.PROC.getBlock(proc), args);
    }

    public static Object rootCall(DynamicObject proc, Object ... args) {
        return Layouts.PROC.getCallTargetForType(proc).call(ProcOperations.packArguments(proc, args));
    }

    public static DynamicObject createRubyProc(DynamicObjectFactory instanceFactory, ProcType type, SharedMethodInfo sharedMethodInfo, CallTarget callTargetForProcs, CallTarget callTargetForLambdas, MaterializedFrame declarationFrame, InternalMethod method, Object self, DynamicObject block) {
        return ProcOperations.createRubyProc(instanceFactory, type, sharedMethodInfo, callTargetForProcs, callTargetForLambdas, declarationFrame, method, self, block, null);
    }

    public static DynamicObject createRubyProc(DynamicObjectFactory instanceFactory, ProcType type, SharedMethodInfo sharedMethodInfo, CallTarget callTargetForProcs, CallTarget callTargetForLambdas, MaterializedFrame declarationFrame, InternalMethod method, Object self, DynamicObject block, FrameOnStackMarker frameOnStackMarker) {
        CallTarget callTargetForType;
        assert (block == null || RubyGuards.isRubyProc(block));
        switch (type) {
            case PROC: {
                callTargetForType = callTargetForProcs;
                break;
            }
            case LAMBDA: {
                callTargetForType = callTargetForLambdas;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return Layouts.PROC.createProc(instanceFactory, type, sharedMethodInfo, callTargetForType, callTargetForLambdas, declarationFrame, method, self, block, frameOnStackMarker);
    }
}

