/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.bigdecimal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.math.BigDecimal;
import java.math.MathContext;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalOpNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalType;

public abstract class AbstractSubNode
extends BigDecimalOpNode {
    private final ConditionProfile nanProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile posInfinityProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile negInfinityProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile normalProfile = ConditionProfile.createBinaryProfile();

    @CompilerDirectives.TruffleBoundary
    private BigDecimal subBigDecimal(DynamicObject a, DynamicObject b, MathContext mathContext) {
        return Layouts.BIG_DECIMAL.getValue(a).subtract(Layouts.BIG_DECIMAL.getValue(b), mathContext);
    }

    protected Object subNormal(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
        return this.createBigDecimal(frame, this.subBigDecimal(a, b, new MathContext(precision, this.getRoundMode(frame))));
    }

    protected Object subSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
        BigDecimalType aType = Layouts.BIG_DECIMAL.getType(a);
        BigDecimalType bType = Layouts.BIG_DECIMAL.getType(b);
        if (this.nanProfile.profile(aType == BigDecimalType.NAN || bType == BigDecimalType.NAN || aType == BigDecimalType.POSITIVE_INFINITY && bType == BigDecimalType.POSITIVE_INFINITY || aType == BigDecimalType.NEGATIVE_INFINITY && bType == BigDecimalType.NEGATIVE_INFINITY)) {
            return this.createBigDecimal(frame, (Object)BigDecimalType.NAN);
        }
        if (this.posInfinityProfile.profile(aType == BigDecimalType.POSITIVE_INFINITY || bType == BigDecimalType.NEGATIVE_INFINITY)) {
            return this.createBigDecimal(frame, (Object)BigDecimalType.POSITIVE_INFINITY);
        }
        if (this.negInfinityProfile.profile(aType == BigDecimalType.NEGATIVE_INFINITY || bType == BigDecimalType.POSITIVE_INFINITY)) {
            return this.createBigDecimal(frame, (Object)BigDecimalType.NEGATIVE_INFINITY);
        }
        if (this.normalProfile.profile(AbstractSubNode.isNormal(a))) {
            return a;
        }
        return this.createBigDecimal(frame, Layouts.BIG_DECIMAL.getValue(b).negate());
    }
}

